/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class ChangeListCompletionContributor
extends CompletionContributor
implements DumbAware {
    public static final Key<ComboBox<ChangeList>> COMBO_BOX_KEY = Key.create((String)"CHANGELIST_COMBO_BOX");

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/openapi/vcs/changes/ChangeListCompletionContributor", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/changes/ChangeListCompletionContributor", "fillCompletionVariants"));
        }
        PsiFile file2 = parameters.getOriginalFile();
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getCachedDocument(file2);
        if (document == null) {
            return;
        }
        ComboBox comboBox = (ComboBox)document.getUserData(COMBO_BOX_KEY);
        if (comboBox == null) {
            return;
        }
        CompletionResultSet resultSet = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(document.getText()));
        for (int i2 = 0; i2 < comboBox.getItemCount(); ++i2) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((Object)comboBox.getItemAt(i2)));
        }
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/vcs/changes/ChangeListCompletionContributor", "invokeAutoPopup"));
        }
        return true;
    }
}

