/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterDialog;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class BrowseChangesAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/BrowseChangesAction", "actionPerformed"));
        }
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file2 = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        AbstractVcs vcs = (AbstractVcs)ObjectUtils.notNull((Object)ChangesUtil.getVcsForFile((VirtualFile)file2, (Project)project2));
        CommittedChangesProvider provider = (CommittedChangesProvider)ObjectUtils.notNull((Object)vcs.getCommittedChangesProvider());
        ChangeBrowserSettings settings = vcs.getConfiguration().CHANGE_BROWSER_SETTINGS.computeIfAbsent(vcs.getName(), key2 -> provider.createDefaultSettings());
        CommittedChangesFilterDialog dialog2 = new CommittedChangesFilterDialog(project2, provider.createFilterUI(true), settings);
        if (dialog2.showAndGet()) {
            BrowseChangesAction.showChanges(vcs, file2, settings);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/BrowseChangesAction", "update"));
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        e.getPresentation().setEnabled(project2 != null && file2 != null && BrowseChangesAction.isEnabled(project2, file2));
    }

    private static boolean isEnabled(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/BrowseChangesAction", "isEnabled"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/actions/BrowseChangesAction", "isEnabled"));
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)file2, (Project)project2);
        return vcs != null && vcs.getCommittedChangesProvider() != null && vcs.allowsRemoteCalls(file2) && AbstractVcs.fileInVcsByFileStatus((Project)project2, (VirtualFile)file2);
    }

    private static void showChanges(@NotNull AbstractVcs vcs, @NotNull VirtualFile file2, @NotNull ChangeBrowserSettings settings) {
        int maxCount;
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/actions/BrowseChangesAction", "showChanges"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/actions/BrowseChangesAction", "showChanges"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/vcs/changes/actions/BrowseChangesAction", "showChanges"));
        }
        int n = maxCount = !settings.isAnyFilterSpecified() ? BrowseChangesAction.askMaxCount(vcs.getProject()) : 0;
        if (maxCount >= 0) {
            AbstractVcsHelper.getInstance((Project)vcs.getProject()).openCommittedChangesTab(vcs, file2, settings, maxCount, null);
        }
    }

    private static int askMaxCount(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/BrowseChangesAction", "askMaxCount"));
        }
        switch (Messages.showYesNoCancelDialog((Project)project2, (String)VcsBundle.message((String)"browse.changes.no.filter.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.title", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.show.recent.button", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.show.all.button", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) {
            case 2: {
                return -1;
            }
            case 0: {
                return 50;
            }
        }
        return 0;
    }
}

