/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.dbCommitted;

import com.intellij.openapi.vcs.changes.Change;

public enum ChangeTypeEnum {
    ADD(0),
    DELETE(1),
    MODIFY(2),
    ADD_PLUS(3),
    MOVE(4),
    REPLACE(5);

    private final int myCode;

    private ChangeTypeEnum(int code2) {
        this.myCode = code2;
    }

    public int getCode() {
        return this.myCode;
    }

    public static ChangeTypeEnum getChangeType(long type) {
        ChangeTypeEnum[] values;
        for (ChangeTypeEnum value : values = ChangeTypeEnum.values()) {
            if ((long)value.getCode() != type) continue;
            return value;
        }
        return null;
    }

    public static ChangeTypeEnum getChangeType(Change change) {
        if (change.getBeforeRevision() == null) {
            return ADD;
        }
        if (change.getAfterRevision() == null) {
            return DELETE;
        }
        if (change.isIsReplaced()) {
            return REPLACE;
        }
        if (change.isMoved() || change.isRenamed()) {
            return MOVE;
        }
        return MODIFY;
    }
}

