/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.patch.DefaultPatchBaseVersionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ApplyPatchForBaseRevisionTexts {
    private final CharSequence myLocal;
    private CharSequence myBase;
    private String myPatched;
    private List<String> myWarnings = new ArrayList<String>();
    private boolean myBaseRevisionLoaded;

    @NotNull
    public static ApplyPatchForBaseRevisionTexts create(Project project2, VirtualFile file2, FilePath pathBeforeRename, TextFilePatch patch, Getter<CharSequence> baseContents) {
        assert (!patch.isNewFile());
        String beforeVersionId = patch.getBeforeVersionId();
        DefaultPatchBaseVersionProvider provider = null;
        if (beforeVersionId != null) {
            provider = new DefaultPatchBaseVersionProvider(project2, file2, beforeVersionId);
        }
        if (provider != null && provider.canProvideContent()) {
            ApplyPatchForBaseRevisionTexts applyPatchForBaseRevisionTexts = new ApplyPatchForBaseRevisionTexts(provider, pathBeforeRename, patch, file2, baseContents);
            if (applyPatchForBaseRevisionTexts == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "create"));
            }
            return applyPatchForBaseRevisionTexts;
        }
        ApplyPatchForBaseRevisionTexts applyPatchForBaseRevisionTexts = new ApplyPatchForBaseRevisionTexts(null, pathBeforeRename, patch, file2, baseContents);
        if (applyPatchForBaseRevisionTexts == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts", "create"));
        }
        return applyPatchForBaseRevisionTexts;
    }

    private ApplyPatchForBaseRevisionTexts(DefaultPatchBaseVersionProvider provider, FilePath pathBeforeRename, TextFilePatch patch, VirtualFile file2, Getter<CharSequence> baseContents) {
        CharSequence contents;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Document document = fileDocumentManager.getDocument(file2);
        if (document != null) {
            fileDocumentManager.saveDocument(document);
        }
        this.myLocal = LoadTextUtil.loadText(file2);
        final List hunks = patch.getHunks();
        if (provider != null) {
            try {
                provider.getBaseVersionContent(pathBeforeRename, new Processor<CharSequence>(){

                    public boolean process(CharSequence text) {
                        GenericPatchApplier applier = new GenericPatchApplier(text, hunks);
                        if (!applier.execute()) {
                            return true;
                        }
                        ApplyPatchForBaseRevisionTexts.this.myBase = text;
                        ApplyPatchForBaseRevisionTexts.this.setPatched(applier.getAfter());
                        return false;
                    }
                }, this.myWarnings);
            }
            catch (VcsException e) {
                this.myWarnings.add(e.getMessage());
            }
            boolean bl = this.myBaseRevisionLoaded = this.myPatched != null;
            if (this.myBaseRevisionLoaded) {
                return;
            }
        }
        if ((contents = (CharSequence)baseContents.get()) != null) {
            this.myBase = contents = StringUtil.convertLineSeparators((String)contents.toString());
            this.myBaseRevisionLoaded = true;
            GenericPatchApplier applier = new GenericPatchApplier(contents, hunks);
            if (!applier.execute()) {
                applier.trySolveSomehow();
            }
            this.setPatched(applier.getAfter());
            return;
        }
        GenericPatchApplier applier = new GenericPatchApplier(this.myLocal, hunks);
        if (!applier.execute()) {
            applier.trySolveSomehow();
        }
        this.setPatched(applier.getAfter());
    }

    public CharSequence getLocal() {
        return this.myLocal;
    }

    public CharSequence getBase() {
        return this.myBase;
    }

    private void setPatched(String text) {
        this.myPatched = StringUtil.convertLineSeparators((String)text);
    }

    public String getPatched() {
        return this.myPatched;
    }

    public static String getCannotLoadBaseMessage(String filePatch) {
        return VcsBundle.message((String)"patch.load.base.revision.error", (Object[])new Object[]{filePatch, ""});
    }
}

