/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.DnDTargetContentAdapter;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vcs.changes.shelf.DiffShelvedChangesAction;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.FontUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedChangesViewManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance(ShelvedChangesViewManager.class);
    @NonNls
    static final String SHELF_CONTEXT_MENU = "Vcs.Shelf.ContextMenu";
    private final ChangesViewContentManager myContentManager;
    private final ShelveChangesManager myShelveChangesManager;
    private final Project myProject;
    private final ShelfTree myTree;
    private Content myContent = null;
    private final DeleteProvider myDeleteProvider = new MyShelveDeleteProvider();
    private boolean myUpdatePending = false;
    private Runnable myPostUpdateRunnable = null;
    public static final DataKey<ShelvedChangeList[]> SHELVED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChangeListData");
    public static final DataKey<ShelvedChangeList[]> SHELVED_RECYCLED_CHANGELIST_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedRecycledChangeListData");
    public static final DataKey<List<ShelvedChange>> SHELVED_CHANGE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedChange");
    public static final DataKey<List<ShelvedBinaryFile>> SHELVED_BINARY_FILE_KEY = DataKey.create((String)"ShelveChangesManager.ShelvedBinaryFile");
    private static final Object ROOT_NODE_VALUE = new Object();
    private DefaultMutableTreeNode myRoot;
    private final Map<Couple<String>, String> myMoveRenameInfo;

    public static ShelvedChangesViewManager getInstance(Project project2) {
        return (ShelvedChangesViewManager)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, ShelvedChangesViewManager.class);
    }

    public ShelvedChangesViewManager(Project project2, ChangesViewContentManager contentManager, ShelveChangesManager shelveChangesManager, MessageBus bus) {
        this.myProject = project2;
        this.myContentManager = contentManager;
        this.myShelveChangesManager = shelveChangesManager;
        bus.connect().subscribe(ShelveChangesManager.SHELF_TOPIC, (Object)new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ShelvedChangesViewManager.this.myUpdatePending = true;
                ApplicationManager.getApplication().invokeLater(() -> ShelvedChangesViewManager.this.updateChangesContent(), ModalityState.NON_MODAL);
            }
        });
        this.myMoveRenameInfo = new HashMap<Couple<String>, String>();
        this.myTree = new ShelfTree();
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new ShelfTreeCellRenderer(project2, this.myMoveRenameInfo)));
        new TreeLinkMouseListener(new ShelfTreeCellRenderer(project2, this.myMoveRenameInfo)).installOn((Component)((Object)this.myTree));
        DnDSupport.createBuilder((JComponent)((Object)this.myTree)).disableAsTarget().setImageProvider(this::createDraggedImage).setBeanProvider(this::createDragStartBean).install();
        AnAction showDiffAction = ActionManager.getInstance().getAction("ShelvedChanges.Diff");
        showDiffAction.registerCustomShortcutSet(showDiffAction.getShortcutSet(), (JComponent)((Object)this.myTree));
        EditSourceAction editSourceAction = new EditSourceAction();
        editSourceAction.registerCustomShortcutSet(editSourceAction.getShortcutSet(), (JComponent)((Object)this.myTree));
        PopupHandler.installPopupHandler((JComponent)((Object)this.myTree), (String)"ShelvedChangesPopupMenu", (String)SHELF_CONTEXT_MENU);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                DiffShelvedChangesAction.showShelvedChangesDiff(DataManager.getInstance().getDataContext((Component)((Object)ShelvedChangesViewManager.this.myTree)));
                return true;
            }
        }.installOn((Component)((Object)this.myTree));
        new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                Object lastComponent;
                Object lc = o.getLastPathComponent();
                Object object = lastComponent = lc == null ? null : ((DefaultMutableTreeNode)lc).getUserObject();
                if (lastComponent instanceof ShelvedChangeList) {
                    return ((ShelvedChangeList)lastComponent).DESCRIPTION;
                }
                if (lastComponent instanceof ShelvedChange) {
                    ShelvedChange shelvedChange = (ShelvedChange)lastComponent;
                    return shelvedChange.getBeforeFileName() == null ? shelvedChange.getAfterFileName() : shelvedChange.getBeforeFileName();
                }
                if (lastComponent instanceof ShelvedBinaryFile) {
                    ShelvedBinaryFile sbf = (ShelvedBinaryFile)lastComponent;
                    String value = sbf.BEFORE_PATH == null ? sbf.AFTER_PATH : sbf.BEFORE_PATH;
                    int idx = value.lastIndexOf("/");
                    idx = idx == -1 ? value.lastIndexOf("\\") : idx;
                    return idx > 0 ? value.substring(idx + 1) : value;
                }
                return null;
            }
        }, true);
    }

    public void projectOpened() {
        StartupManager startupManager = StartupManager.getInstance((Project)this.myProject);
        if (startupManager == null) {
            LOG.error("Couldn't start loading shelved changes");
            return;
        }
        startupManager.registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> this.updateChangesContent()));
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ShelvedChangesViewManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager", "getComponentName"));
        }
        return "ShelvedChangesViewManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private void updateChangesContent() {
        this.myUpdatePending = false;
        ArrayList<ShelvedChangeList> changeLists = new ArrayList<ShelvedChangeList>(this.myShelveChangesManager.getShelvedChangeLists());
        changeLists.addAll(this.myShelveChangesManager.getRecycledShelvedChangeLists());
        if (changeLists.size() == 0) {
            if (this.myContent != null) {
                this.myContentManager.removeContent(this.myContent);
                this.myContentManager.selectContent("Local Changes");
            }
            this.myContent = null;
        } else {
            if (this.myContent == null) {
                this.myTree.updateUI();
                JPanel rootPanel = this.createRootPanel();
                this.myContent = new MyShelfContent(rootPanel, VcsBundle.message((String)"shelf.tab", (Object[])new Object[0]), false);
                this.myContent.setCloseable(false);
                this.myContentManager.addContent(this.myContent);
            }
            TreeState state = TreeState.createOn((JTree)((Object)this.myTree));
            this.myTree.setModel(this.buildChangesModel());
            state.applyTo((JTree)((Object)this.myTree));
            if (this.myPostUpdateRunnable != null) {
                this.myPostUpdateRunnable.run();
            }
        }
        this.myPostUpdateRunnable = null;
    }

    @NotNull
    private JPanel createRootPanel() {
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree));
        pane.setBorder(null);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAll((ActionGroup)ActionManager.getInstance().getAction("ShelvedChangesToolbar"));
        actionGroup.add(ActionManager.getInstance().getAction("ShelvedChangesToolbarGear"));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, false);
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add((Component)toolbar.getComponent(), "West");
        rootPanel.add((Component)pane, "Center");
        DataManager.registerDataProvider((JComponent)rootPanel, (DataProvider)this.myTree);
        JPanel jPanel = rootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager", "createRootPanel"));
        }
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    private TreeModel buildChangesModel() {
        this.myRoot = new DefaultMutableTreeNode(ROOT_NODE_VALUE);
        DefaultTreeModel model = new DefaultTreeModel(this.myRoot);
        ArrayList<ShelvedChangeList> changeLists = new ArrayList<ShelvedChangeList>(this.myShelveChangesManager.getShelvedChangeLists());
        Collections.sort(changeLists, ChangelistComparator.getInstance());
        if (this.myShelveChangesManager.isShowRecycled()) {
            ArrayList<ShelvedChangeList> recycled = new ArrayList<ShelvedChangeList>(this.myShelveChangesManager.getRecycledShelvedChangeLists());
            changeLists.addAll(recycled);
            Collections.sort(changeLists, ChangelistComparator.getInstance());
        }
        this.myMoveRenameInfo.clear();
        for (ShelvedChangeList changeList : changeLists) {
            void var9_9;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(changeList);
            model.insertNodeInto(node, this.myRoot, this.myRoot.getChildCount());
            ArrayList<Object> shelvedFilesNodes = new ArrayList<Object>();
            List<ShelvedChange> changes = changeList.getChanges(this.myProject);
            for (ShelvedChange shelvedChange : changes) {
                this.putMovedMessage(shelvedChange.getBeforePath(), shelvedChange.getAfterPath());
                shelvedFilesNodes.add(shelvedChange);
            }
            List<ShelvedBinaryFile> binaryFiles = changeList.getBinaryFiles();
            for (ShelvedBinaryFile file2 : binaryFiles) {
                this.putMovedMessage(file2.BEFORE_PATH, file2.AFTER_PATH);
                shelvedFilesNodes.add(file2);
            }
            Collections.sort(shelvedFilesNodes, ShelvedFilePatchComparator.getInstance());
            boolean bl = false;
            while (var9_9 < shelvedFilesNodes.size()) {
                Object filesNode = shelvedFilesNodes.get((int)var9_9);
                DefaultMutableTreeNode pathNode = new DefaultMutableTreeNode(filesNode);
                model.insertNodeInto(pathNode, node, (int)var9_9);
                ++var9_9;
            }
        }
        return model;
    }

    private void putMovedMessage(String beforeName, String afterName) {
        String movedMessage = RelativePathCalculator.getMovedString(beforeName, afterName);
        if (movedMessage != null) {
            this.myMoveRenameInfo.put((Couple<String>)Couple.of((Object)beforeName, (Object)afterName), movedMessage);
        }
    }

    public void activateView(ShelvedChangeList list) {
        Runnable runnable2 = () -> {
            if (list != null) {
                TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.myRoot, (Object)list));
            }
            this.myContentManager.setSelectedContent(this.myContent);
            ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
            if (!window.isVisible()) {
                window.activate(null);
            }
        };
        if (this.myUpdatePending) {
            this.myPostUpdateRunnable = runnable2;
        } else {
            runnable2.run();
        }
    }

    @NotNull
    public static List<ShelvedChangeList> getShelvedLists(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager", "getShelvedLists"));
        }
        Object[] shelved = (ShelvedChangeList[])SHELVED_CHANGELIST_KEY.getData(dataContext);
        Object[] recycled = (ShelvedChangeList[])SHELVED_RECYCLED_CHANGELIST_KEY.getData(dataContext);
        if (shelved == null && recycled == null) {
            List<ShelvedChangeList> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager", "getShelvedLists"));
            }
            return list;
        }
        ArrayList shelvedChangeLists = ContainerUtil.newArrayList();
        if (shelved != null) {
            ContainerUtil.addAll((Collection)shelvedChangeLists, (Object[])shelved);
        }
        if (recycled != null) {
            ContainerUtil.addAll((Collection)shelvedChangeLists, (Object[])recycled);
        }
        ArrayList arrayList = shelvedChangeLists;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager", "getShelvedLists"));
        }
        return arrayList;
    }

    @NotNull
    public static List<ShelvedChange> getShelveChanges(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager", "getShelveChanges"));
        }
        List list = ContainerUtil.notNullize((List)((List)dataContext.getData(SHELVED_CHANGE_KEY)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager", "getShelveChanges"));
        }
        return list;
    }

    @NotNull
    public static List<ShelvedBinaryFile> getBinaryShelveChanges(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager", "getBinaryShelveChanges"));
        }
        List list = ContainerUtil.notNullize((List)((List)dataContext.getData(SHELVED_BINARY_FILE_KEY)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager", "getBinaryShelveChanges"));
        }
        return list;
    }

    @Nullable
    private DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager", "createDragStartBean"));
        }
        if (info.isMove()) {
            DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)this.myTree));
            return new DnDDragStartBean((Object)new ShelvedChangeListDragBean(ShelvedChangesViewManager.getShelveChanges(dc), ShelvedChangesViewManager.getBinaryShelveChanges(dc), ShelvedChangesViewManager.getShelvedLists(dc)));
        }
        return null;
    }

    @NotNull
    private DnDImage createDraggedImage(@NotNull DnDActionInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager", "createDraggedImage"));
        }
        String imageText = "Unshelve changes";
        Image image = (Image)DnDAwareTree.getDragImage((Tree)this.myTree, imageText, null).getFirst();
        DnDImage dnDImage = new DnDImage(image, new Point(-image.getWidth(null), -image.getHeight(null)));
        if (dnDImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager", "createDraggedImage"));
        }
        return dnDImage;
    }

    public class MyShelfContent
    extends DnDTargetContentAdapter {
        private MyShelfContent(JPanel panel2, String displayName, boolean isLockable) {
            super(panel2, displayName, isLockable);
        }

        public void drop(DnDEvent event) {
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ChangeListDragBean) {
                FileDocumentManager.getInstance().saveAllDocuments();
                List<Change> changes = Arrays.asList(((ChangeListDragBean)attachedObject).getChanges());
                ShelvedChangesViewManager.this.myShelveChangesManager.shelveSilentlyUnderProgress(changes);
            }
        }

        public boolean update(DnDEvent event) {
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ChangeListDragBean) {
                event.setDropPossible(((ChangeListDragBean)attachedObject).getChanges().length > 0);
                return false;
            }
            return true;
        }
    }

    private class MyShelveDeleteProvider
    implements DeleteProvider {
        private MyShelveDeleteProvider() {
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "deleteElement"));
            }
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project2 == null) {
                return;
            }
            List shelvedListsToDelete = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)ShelvedChangesViewManager.this.myTree), ShelvedChangeList.class);
            ArrayList shelvedListsFromChanges = ContainerUtil.newArrayList(ShelvedChangesViewManager.getShelvedLists(dataContext));
            shelvedListsFromChanges.removeAll(shelvedListsToDelete);
            List<ShelvedChange> changesToDelete = this.getChangesNotInLists(shelvedListsToDelete, ShelvedChangesViewManager.getShelveChanges(dataContext));
            List<ShelvedBinaryFile> binariesToDelete = this.getBinariesNotInLists(shelvedListsToDelete, ShelvedChangesViewManager.getBinaryShelveChanges(dataContext));
            int changeListSize = shelvedListsToDelete.size();
            int fileListSize = binariesToDelete.size() + changesToDelete.size();
            if (fileListSize == 0 && changeListSize == 0) {
                return;
            }
            String message = VcsBundle.message((String)"shelve.changes.delete.items.confirm", (Object[])new Object[]{this.constructDeleteFilesInfoMessage(fileListSize), changeListSize != 0 && fileListSize != 0 ? " and " : "", this.constructShelvedListInfoMessage(changeListSize, (ShelvedChangeList)ContainerUtil.getFirstItem((List)shelvedListsToDelete))});
            int rc = Messages.showOkCancelDialog((Project)ShelvedChangesViewManager.this.myProject, (String)message, (String)VcsBundle.message((String)"shelvedChanges.delete.title", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
            if (rc != 0) {
                return;
            }
            for (ShelvedChangeList changeList : shelvedListsToDelete) {
                ShelveChangesManager.getInstance(ShelvedChangesViewManager.this.myProject).deleteChangeList(changeList);
            }
            for (ShelvedChangeList list : shelvedListsFromChanges) {
                this.removeChangesFromChangeList(project2, list, changesToDelete, binariesToDelete);
            }
        }

        private List<ShelvedBinaryFile> getBinariesNotInLists(@NotNull List<ShelvedChangeList> listsToDelete, @NotNull List<ShelvedBinaryFile> binaryFiles) {
            if (listsToDelete == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listsToDelete", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "getBinariesNotInLists"));
            }
            if (binaryFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryFiles", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "getBinariesNotInLists"));
            }
            ArrayList<ShelvedBinaryFile> result2 = new ArrayList<ShelvedBinaryFile>(binaryFiles);
            for (ShelvedChangeList list : listsToDelete) {
                result2.removeAll(list.getBinaryFiles());
            }
            return result2;
        }

        @NotNull
        private List<ShelvedChange> getChangesNotInLists(@NotNull List<ShelvedChangeList> listsToDelete, @NotNull List<ShelvedChange> shelvedChanges) {
            if (listsToDelete == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listsToDelete", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "getChangesNotInLists"));
            }
            if (shelvedChanges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shelvedChanges", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "getChangesNotInLists"));
            }
            ArrayList<ShelvedChange> result2 = new ArrayList<ShelvedChange>(shelvedChanges);
            for (ShelvedChangeList list : listsToDelete) {
                result2.removeAll(list.getChanges(ShelvedChangesViewManager.this.myProject));
            }
            ArrayList<ShelvedChange> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "getChangesNotInLists"));
            }
            return arrayList;
        }

        @NotNull
        private String constructShelvedListInfoMessage(int size, @Nullable ShelvedChangeList first) {
            if (size == 0) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "constructShelvedListInfoMessage"));
                }
                return "";
            }
            String message = size == 1 && first != null ? "<b> one shelved changelist</b> named [<b>" + first.DESCRIPTION + "</b>]" : "<b>" + size + " shelved " + StringUtil.pluralize((String)"changelist", (int)size) + "</b>";
            String string = message + " with all changes inside";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "constructShelvedListInfoMessage"));
            }
            return string;
        }

        @NotNull
        private String constructDeleteFilesInfoMessage(int size) {
            if (size == 0) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "constructDeleteFilesInfoMessage"));
                }
                return "";
            }
            String string = "<b>" + (size == 1 ? "one" : Integer.valueOf(size)) + StringUtil.pluralize((String)" file", (int)size) + "</b>";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "constructDeleteFilesInfoMessage"));
            }
            return string;
        }

        private void removeChangesFromChangeList(@NotNull Project project2, @NotNull ShelvedChangeList list, @NotNull List<ShelvedChange> changes, @NotNull List<ShelvedBinaryFile> binaryFiles) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "removeChangesFromChangeList"));
            }
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "removeChangesFromChangeList"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "removeChangesFromChangeList"));
            }
            if (binaryFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryFiles", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "removeChangesFromChangeList"));
            }
            ArrayList<ShelvedBinaryFile> oldBinaries = new ArrayList<ShelvedBinaryFile>(list.getBinaryFiles());
            ArrayList<ShelvedChange> oldChanges = new ArrayList<ShelvedChange>(list.getChanges(project2));
            oldBinaries.removeAll(binaryFiles);
            oldChanges.removeAll(changes);
            CommitContext commitContext = new CommitContext();
            ArrayList<FilePatch> patches = new ArrayList<FilePatch>();
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (ShelvedChange change : oldChanges) {
                try {
                    patches.add((FilePatch)change.loadFilePatch(ShelvedChangesViewManager.this.myProject, commitContext));
                }
                catch (PatchSyntaxException | IOException e) {
                    exceptions.add(new VcsException(e));
                }
            }
            ShelvedChangesViewManager.this.myShelveChangesManager.saveRemainingPatches(list, patches, oldBinaries, commitContext);
            if (!exceptions.isEmpty()) {
                String title = list.DESCRIPTION == null ? "" : list.DESCRIPTION;
                title = title.substring(0, Math.min(10, title.length()));
                AbstractVcsHelper.getInstance((Project)ShelvedChangesViewManager.this.myProject).showErrors(exceptions, "Deleting files from '" + title + "'");
            }
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider", "canDeleteElement"));
            }
            return !ShelvedChangesViewManager.getShelvedLists(dataContext).isEmpty();
        }
    }

    private static class ShelfTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final IssueLinkRenderer myIssueLinkRenderer;
        private final Map<Couple<String>, String> myMoveRenameInfo;
        private static final Icon PatchIcon = StdFileTypes.PATCH.getIcon();
        private static final Icon DisabledPatchIcon = AllIcons.Nodes.DisabledPointcut;
        private static final Icon DisabledToDeleteIcon = IconUtil.desaturate((Icon)AllIcons.Actions.GC);

        public ShelfTreeCellRenderer(Project project2, Map<Couple<String>, String> moveRenameInfo) {
            this.myMoveRenameInfo = moveRenameInfo;
            this.myIssueLinkRenderer = new IssueLinkRenderer(project2, (SimpleColoredComponent)this);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfTreeCellRenderer", "customizeCellRenderer"));
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeValue = node.getUserObject();
            if (nodeValue instanceof ShelvedChangeList) {
                ShelvedChangeList changeListData = (ShelvedChangeList)nodeValue;
                if (changeListData.isRecycled()) {
                    this.myIssueLinkRenderer.appendTextWithLinks(changeListData.DESCRIPTION, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                    this.setIcon(changeListData.isMarkedToDelete() ? DisabledToDeleteIcon : DisabledPatchIcon);
                } else {
                    this.myIssueLinkRenderer.appendTextWithLinks(changeListData.DESCRIPTION);
                    this.setIcon(PatchIcon);
                }
                int count = node.getChildCount();
                String numFilesText = FontUtil.spaceAndThinSpace() + count + " " + StringUtil.pluralize((String)"file", (int)count) + ",";
                this.append(numFilesText, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                String date = DateFormatUtil.formatPrettyDateTime((Date)changeListData.DATE);
                this.append(" " + date, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else if (nodeValue instanceof ShelvedChange) {
                ShelvedChange change = (ShelvedChange)nodeValue;
                String movedMessage = this.myMoveRenameInfo.get(Couple.of((Object)change.getBeforePath(), (Object)change.getAfterPath()));
                this.renderFileName(change.getBeforePath(), change.getFileStatus(), movedMessage);
            } else if (nodeValue instanceof ShelvedBinaryFile) {
                ShelvedBinaryFile binaryFile = (ShelvedBinaryFile)nodeValue;
                String path = binaryFile.BEFORE_PATH;
                if (path == null) {
                    path = binaryFile.AFTER_PATH;
                }
                String movedMessage = this.myMoveRenameInfo.get(Couple.of((Object)binaryFile.BEFORE_PATH, (Object)binaryFile.AFTER_PATH));
                this.renderFileName(path, binaryFile.getFileStatus(), movedMessage);
            }
        }

        private void renderFileName(String path, FileStatus fileStatus, String movedMessage) {
            String fileName;
            String directory;
            int pos = (path = path.replace('/', File.separatorChar)).lastIndexOf(File.separatorChar);
            if (pos >= 0) {
                directory = path.substring(0, pos).replace(File.separatorChar, File.separatorChar);
                fileName = path.substring(pos + 1);
            } else {
                directory = "<project root>";
                fileName = path;
            }
            this.append(fileName, new SimpleTextAttributes(0, fileStatus.getColor()));
            if (movedMessage != null) {
                this.append(movedMessage, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            this.append(FontUtil.spaceAndThinSpace() + directory, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(fileName).getIcon());
        }
    }

    private static final class ShelvedFilePatchComparator
    implements Comparator<Object> {
        private static final ShelvedFilePatchComparator ourInstance = new ShelvedFilePatchComparator();

        private ShelvedFilePatchComparator() {
        }

        public static ShelvedFilePatchComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(Object o1, Object o2) {
            String path1 = ShelvedFilePatchComparator.getPath(o1);
            String path2 = ShelvedFilePatchComparator.getPath(o2);
            if (path1 == null) {
                return -1;
            }
            if (path2 == null) {
                return 1;
            }
            return path1.compareToIgnoreCase(path2);
        }

        private static String getPath(Object patch) {
            String path = null;
            if (patch instanceof ShelvedBinaryFile) {
                ShelvedBinaryFile binaryFile = (ShelvedBinaryFile)patch;
                path = binaryFile.BEFORE_PATH;
                path = path == null ? binaryFile.AFTER_PATH : path;
            } else if (patch instanceof ShelvedChange) {
                ShelvedChange shelvedChange = (ShelvedChange)patch;
                path = shelvedChange.getBeforePath().replace('/', File.separatorChar);
            }
            if (path == null) {
                return null;
            }
            int pos = path.lastIndexOf(File.separatorChar);
            return pos >= 0 ? path.substring(pos + 1) : path;
        }
    }

    private class ShelfTree
    extends Tree
    implements DataProvider {
        private ShelfTree() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (SHELVED_CHANGELIST_KEY.is(dataId)) {
                Set<ShelvedChangeList> changeLists = this.getSelectedLists(false);
                if (changeLists.size() > 0) {
                    return changeLists.toArray(new ShelvedChangeList[changeLists.size()]);
                }
            } else if (SHELVED_RECYCLED_CHANGELIST_KEY.is(dataId)) {
                Set<ShelvedChangeList> changeLists = this.getSelectedLists(true);
                if (changeLists.size() > 0) {
                    return changeLists.toArray(new ShelvedChangeList[changeLists.size()]);
                }
            } else {
                if (SHELVED_CHANGE_KEY.is(dataId)) {
                    return TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedChange.class);
                }
                if (SHELVED_BINARY_FILE_KEY.is(dataId)) {
                    return TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedBinaryFile.class);
                }
                if (VcsDataKeys.HAVE_SELECTED_CHANGES.is(dataId)) {
                    return this.getSelectionCount() > 0;
                }
                if (VcsDataKeys.CHANGES.is(dataId)) {
                    List<ShelvedChange> shelvedChanges = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedChange.class);
                    List shelvedBinaryFiles = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedBinaryFile.class);
                    if (!shelvedChanges.isEmpty() || !shelvedBinaryFiles.isEmpty()) {
                        ArrayList<Change> changes = new ArrayList<Change>(shelvedChanges.size() + shelvedBinaryFiles.size());
                        for (ShelvedChange shelvedChange : shelvedChanges) {
                            changes.add(shelvedChange.getChange(ShelvedChangesViewManager.this.myProject));
                        }
                        for (ShelvedBinaryFile binaryFile : shelvedBinaryFiles) {
                            changes.add(binaryFile.createChange(ShelvedChangesViewManager.this.myProject));
                        }
                        return changes.toArray(new Change[changes.size()]);
                    }
                    List changeLists = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedChangeList.class);
                    ArrayList<Change> changes = new ArrayList<Change>();
                    for (ShelvedChangeList changeList : changeLists) {
                        shelvedChanges = changeList.getChanges(ShelvedChangesViewManager.this.myProject);
                        for (ShelvedChange shelvedChange : shelvedChanges) {
                            changes.add(shelvedChange.getChange(ShelvedChangesViewManager.this.myProject));
                        }
                        List<ShelvedBinaryFile> binaryFiles = changeList.getBinaryFiles();
                        for (ShelvedBinaryFile file2 : binaryFiles) {
                            changes.add(file2.createChange(ShelvedChangesViewManager.this.myProject));
                        }
                    }
                    return changes.toArray(new Change[changes.size()]);
                }
                if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                    return ShelvedChangesViewManager.this.myDeleteProvider;
                }
                if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                    ArrayList<ShelvedChange> shelvedChanges = new ArrayList<ShelvedChange>(TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedChange.class));
                    ArrayDeque<1> navigatables = new ArrayDeque<1>();
                    List changeLists = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this), ShelvedChangeList.class);
                    for (ShelvedChangeList changeList : changeLists) {
                        shelvedChanges.addAll(changeList.getChanges(ShelvedChangesViewManager.this.myProject));
                    }
                    for (final ShelvedChange shelvedChange : shelvedChanges) {
                        if (shelvedChange.getBeforePath() == null || FileStatus.ADDED.equals(shelvedChange.getFileStatus())) continue;
                        NavigatableAdapter navigatable = new NavigatableAdapter(){

                            public void navigate(boolean requestFocus) {
                                VirtualFile vf = shelvedChange.getBeforeVFUnderProject(ShelvedChangesViewManager.this.myProject);
                                if (vf != null) {
                                    1.navigate((Project)ShelvedChangesViewManager.this.myProject, (VirtualFile)vf, (boolean)true);
                                }
                            }
                        };
                        navigatables.add(navigatable);
                    }
                    return navigatables.toArray(new Navigatable[navigatables.size()]);
                }
            }
            return null;
        }

        private Set<ShelvedChangeList> getSelectedLists(boolean recycled) {
            TreePath[] selections = this.getSelectionPaths();
            HashSet<ShelvedChangeList> changeLists = new HashSet<ShelvedChangeList>();
            if (selections != null) {
                for (TreePath path : selections) {
                    DefaultMutableTreeNode node;
                    if (path.getPathCount() < 2 || !((node = (DefaultMutableTreeNode)path.getPathComponent(1)).getUserObject() instanceof ShelvedChangeList)) continue;
                    ShelvedChangeList list = (ShelvedChangeList)node.getUserObject();
                    if ((recycled || list.isRecycled()) && (!recycled || !list.isRecycled())) continue;
                    changeLists.add(list);
                }
            }
            return changeLists;
        }
    }

    private static class ChangelistComparator
    implements Comparator<ShelvedChangeList> {
        private static final ChangelistComparator ourInstance = new ChangelistComparator();

        private ChangelistComparator() {
        }

        public static ChangelistComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(ShelvedChangeList o1, ShelvedChangeList o2) {
            return o2.DATE.compareTo(o1.DATE);
        }
    }
}

