/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.IgnoredViewDialog;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilesNode;
import com.intellij.openapi.vcs.changes.ui.IgnoreUnversionedDialog;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserIgnoredFilesNode
extends ChangesBrowserSpecificFilesNode {
    private final boolean myUpdatingMode;

    protected ChangesBrowserIgnoredFilesNode(Project project2, int filesSize, int dirsSize, boolean many, boolean updatingMode) {
        super(IGNORED_FILES_TAG, filesSize, dirsSize, many, () -> new IgnoredViewDialog(project2).show());
        this.myUpdatingMode = updatingMode;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserIgnoredFilesNode", "render"));
        }
        super.render(renderer, selected, expanded, hasFocus);
        if (this.myUpdatingMode) {
            this.appendUpdatingState(renderer);
        }
    }

    @Override
    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return dragBean.getUnversionedFiles().size() > 0;
    }

    @Override
    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
        IgnoreUnversionedDialog.ignoreSelectedFiles(dragOwner.getProject(), dragBean.getUnversionedFiles(), null);
    }

    @Override
    public int getSortWeight() {
        return 10;
    }
}

