/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesViewContentManager
extends AbstractProjectComponent
implements ChangesViewContentI {
    public static final String TOOLWINDOW_ID = ToolWindowId.VCS;
    private static final Key<ChangesViewContentEP> myEPKey = Key.create((String)"ChangesViewContentEP");
    private MyContentManagerListener myContentManagerListener;
    private final ProjectLevelVcsManager myVcsManager;
    private ContentManager myContentManager;
    private final VcsListener myVcsListener;
    private final Alarm myVcsChangeAlarm;
    private final List<Content> myAddedContents;
    @NotNull
    private final CountDownLatch myInitializationWaiter;
    public static final String LOCAL_CHANGES = "Local Changes";
    public static final String REPOSITORY = "Repository";
    public static final String INCOMING = "Incoming";
    public static final String SHELF = "Shelf";
    private static final String[] ourPresetOrder = new String[]{"Local Changes", "Repository", "Incoming", "Shelf"};

    public static ChangesViewContentI getInstance(Project project2) {
        return (ChangesViewContentI)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, ChangesViewContentI.class);
    }

    public ChangesViewContentManager(@NotNull Project project2, ProjectLevelVcsManager vcsManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesViewContentManager", "<init>"));
        }
        super(project2);
        this.myVcsListener = new MyVcsListener();
        this.myAddedContents = new ArrayList<Content>();
        this.myInitializationWaiter = new CountDownLatch(1);
        this.myVcsManager = vcsManager;
        this.myVcsChangeAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project2);
        this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this.myVcsListener);
    }

    @Override
    public void setUp(ToolWindow toolWindow) {
        final ContentManager contentManager = toolWindow.getContentManager();
        this.myContentManagerListener = new MyContentManagerListener();
        contentManager.addContentManagerListener((ContentManagerListener)this.myContentManagerListener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                contentManager.removeContentManagerListener((ContentManagerListener)ChangesViewContentManager.this.myContentManagerListener);
            }
        });
        this.loadExtensionTabs();
        this.myContentManager = contentManager;
        List<Content> ordered = ChangesViewContentManager.doPresetOrdering(this.myAddedContents);
        for (Content content : ordered) {
            this.myContentManager.addContent(content);
        }
        this.myAddedContents.clear();
        if (contentManager.getContentCount() > 0) {
            contentManager.setSelectedContent(contentManager.getContent(0));
        }
        this.myInitializationWaiter.countDown();
    }

    private void loadExtensionTabs() {
        ChangesViewContentEP[] contentEPs;
        LinkedList<Content> contentList = new LinkedList<Content>();
        for (ChangesViewContentEP ep : contentEPs = (ChangesViewContentEP[])this.myProject.getExtensions(ChangesViewContentEP.EP_NAME)) {
            NotNullFunction<Project, Boolean> predicate = ep.newPredicateInstance(this.myProject);
            if (predicate != null && !((Boolean)predicate.fun((Object)this.myProject)).equals(Boolean.TRUE)) continue;
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)new ContentStub(ep), ep.getTabName(), false);
            content.setCloseable(false);
            content.putUserData(myEPKey, (Object)ep);
            contentList.add(content);
        }
        this.myAddedContents.addAll(0, contentList);
    }

    private void addExtensionTab(ChangesViewContentEP ep) {
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)new ContentStub(ep), ep.getTabName(), false);
        content.setCloseable(false);
        content.putUserData(myEPKey, (Object)ep);
        this.addIntoCorrectPlace(content);
    }

    private void updateExtensionTabs() {
        ChangesViewContentEP[] contentEPs;
        for (ChangesViewContentEP ep : contentEPs = (ChangesViewContentEP[])this.myProject.getExtensions(ChangesViewContentEP.EP_NAME)) {
            NotNullFunction<Project, Boolean> predicate = ep.newPredicateInstance(this.myProject);
            if (predicate == null) continue;
            Content epContent = this.findEPContent(ep);
            Boolean predicateResult = (Boolean)predicate.fun((Object)this.myProject);
            if (predicateResult.equals(Boolean.TRUE) && epContent == null) {
                this.addExtensionTab(ep);
                continue;
            }
            if (!predicateResult.equals(Boolean.FALSE) || epContent == null) continue;
            this.myContentManager.removeContent(epContent, true);
        }
    }

    @Nullable
    private Content findEPContent(ChangesViewContentEP ep) {
        Content[] contents;
        for (Content content : contents = this.myContentManager.getContents()) {
            if (content.getUserData(myEPKey) != ep) continue;
            return content;
        }
        return null;
    }

    private void updateToolWindowAvailability() {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOLWINDOW_ID);
        if (toolWindow != null) {
            boolean available = this.isAvailable();
            toolWindow.setShowStripeButton(available);
            toolWindow.setAvailable(available, null);
        }
    }

    @Override
    public boolean isAvailable() {
        List mappings = this.myVcsManager.getDirectoryMappings();
        return mappings.stream().anyMatch(mapping -> !StringUtil.isEmpty((String)mapping.getVcs()));
    }

    public void projectClosed() {
        this.myVcsChangeAlarm.cancelAllRequests();
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ChangesViewContentManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesViewContentManager", "getComponentName"));
        }
        return "ChangesViewContentManager";
    }

    @Override
    public void addContent(Content content) {
        if (this.myContentManager == null) {
            this.myAddedContents.add(content);
        } else {
            this.addIntoCorrectPlace(content);
        }
    }

    @Override
    public void removeContent(Content content) {
        if (this.myContentManager != null && !this.myContentManager.isDisposed()) {
            this.myContentManager.removeContent(content, true);
        }
    }

    @Override
    public void setSelectedContent(Content content) {
        this.myContentManager.setSelectedContent(content);
    }

    @Override
    @Nullable
    public <T> T getActiveComponent(Class<T> aClass) {
        if (this.myContentManager == null) {
            return null;
        }
        Content content = this.myContentManager.getSelectedContent();
        if (content != null && aClass.isInstance(content.getComponent())) {
            return (T)content.getComponent();
        }
        return null;
    }

    public boolean isContentSelected(@NotNull String contentName) {
        if (contentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentName", "com/intellij/openapi/vcs/changes/ui/ChangesViewContentManager", "isContentSelected"));
        }
        Content selectedContent = this.myContentManager.getSelectedContent();
        if (selectedContent == null) {
            return false;
        }
        return Comparing.equal((String)contentName, (String)selectedContent.getTabName());
    }

    @Override
    public void selectContent(@NotNull String tabName) {
        if (tabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/intellij/openapi/vcs/changes/ui/ChangesViewContentManager", "selectContent"));
        }
        this.selectContent(tabName, false);
    }

    public void selectContent(@NotNull String tabName, boolean requestFocus) {
        if (tabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/intellij/openapi/vcs/changes/ui/ChangesViewContentManager", "selectContent"));
        }
        for (Content content : this.myContentManager.getContents()) {
            if (!content.getDisplayName().equals(tabName)) continue;
            this.myContentManager.setSelectedContent(content, requestFocus);
            break;
        }
    }

    private static List<Content> doPresetOrdering(List<Content> contents) {
        ArrayList<Content> result2 = new ArrayList<Content>(contents.size());
        for (String preset : ourPresetOrder) {
            Iterator<Content> iterator = contents.iterator();
            while (iterator.hasNext()) {
                Content current = iterator.next();
                if (!preset.equals(current.getTabName())) continue;
                iterator.remove();
                result2.add(current);
            }
        }
        result2.addAll(contents);
        return result2;
    }

    private void addIntoCorrectPlace(Content content) {
        String name = content.getTabName();
        Content[] contents = this.myContentManager.getContents();
        int idxOfBeingInserted = -1;
        for (int i2 = 0; i2 < ourPresetOrder.length; ++i2) {
            Content[] s = ourPresetOrder[i2];
            if (!s.equals(name)) continue;
            idxOfBeingInserted = i2;
        }
        if (idxOfBeingInserted == -1) {
            this.myContentManager.addContent(content);
            return;
        }
        HashSet<String> existingNames = new HashSet<String>();
        for (Content existingContent : contents) {
            existingNames.add(existingContent.getTabName());
        }
        int place = idxOfBeingInserted;
        for (int i3 = 0; i3 < idxOfBeingInserted; ++i3) {
            if (existingNames.contains(ourPresetOrder[i3])) continue;
            --place;
        }
        this.myContentManager.addContent(content, place);
    }

    private class MyContentManagerListener
    extends ContentManagerAdapter {
        private MyContentManagerListener() {
        }

        public void selectionChanged(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content.getComponent() instanceof ContentStub) {
                ChangesViewContentEP ep = ((ContentStub)content.getComponent()).getEP();
                final ChangesViewContentProvider provider = ep.getInstance(ChangesViewContentManager.this.myProject);
                JComponent contentComponent = provider.initContent();
                content.setComponent(contentComponent);
                content.setDisposer(new Disposable(){

                    public void dispose() {
                        provider.disposeContent();
                    }
                });
            }
        }
    }

    private static class ContentStub
    extends JPanel {
        private final ChangesViewContentEP myEP;

        private ContentStub(ChangesViewContentEP EP) {
            this.myEP = EP;
        }

        public ChangesViewContentEP getEP() {
            return this.myEP;
        }
    }

    private class MyVcsListener
    implements VcsListener {
        private MyVcsListener() {
        }

        public void directoryMappingChanged() {
            ChangesViewContentManager.this.myVcsChangeAlarm.cancelAllRequests();
            ChangesViewContentManager.this.myVcsChangeAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    if (ChangesViewContentManager.this.myProject.isDisposed()) {
                        return;
                    }
                    ChangesViewContentManager.this.updateToolWindowAvailability();
                    if (ChangesViewContentManager.this.myContentManager != null) {
                        ChangesViewContentManager.this.updateExtensionTabs();
                    }
                }
            }, 100, ModalityState.NON_MODAL);
        }
    }
}

