/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetVersionAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(GetVersionAction.class);

    public GetVersionAction() {
        super(VcsBundle.message((String)"action.name.get.file.content.from.repository", (Object[])new Object[0]), VcsBundle.message((String)"action.description.get.file.content.from.repository", (Object[])new Object[0]), AllIcons.Actions.Get);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/GetVersionAction", "update"));
        }
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (e.getProject() == null || filePath == null || revision == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(this.isContentAvailable(filePath, revision, e));
        }
    }

    protected boolean isContentAvailable(@NotNull FilePath filePath, @NotNull VcsFileRevision revision, @NotNull AnActionEvent e) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/GetVersionAction", "isContentAvailable"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/history/GetVersionAction", "isContentAvailable"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/GetVersionAction", "isContentAvailable"));
        }
        return !filePath.isDirectory();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/GetVersionAction", "actionPerformed"));
        }
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(null)) {
            return;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getRequiredData(VcsDataKeys.VCS_FILE_REVISION);
        FilePath filePath = (FilePath)e.getRequiredData(VcsDataKeys.FILE_PATH);
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile != null) {
            ReplaceFileConfirmationDialog confirmationDialog = new ReplaceFileConfirmationDialog(project2, VcsBundle.message((String)"acton.name.get.revision", (Object[])new Object[0]));
            if (!confirmationDialog.confirmFor(new VirtualFile[]{virtualFile})) {
                return;
            }
        }
        new MyWriteVersionTask(project2, filePath, revision).queue();
        GetVersionAction.refreshFile(filePath, revision, project2);
    }

    private static void refreshFile(@NotNull FilePath filePath, @NotNull VcsFileRevision revision, @NotNull Project project2) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/GetVersionAction", "refreshFile"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/history/GetVersionAction", "refreshFile"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/history/GetVersionAction", "refreshFile"));
        }
        Runnable refresh = null;
        VirtualFile vf = filePath.getVirtualFile();
        if (vf == null) {
            LocalHistoryAction action = GetVersionAction.startLocalHistoryAction(filePath, revision);
            VirtualFile vp = filePath.getVirtualFileParent();
            if (vp != null) {
                refresh = () -> vp.refresh(false, true, () -> ((LocalHistoryAction)action).finish());
            }
        } else {
            refresh = () -> vf.refresh(false, false);
        }
        if (refresh != null) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(refresh, "Refreshing Files...", false, project2);
        }
    }

    private static LocalHistoryAction startLocalHistoryAction(@NotNull FilePath filePath, @NotNull VcsFileRevision revision) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/GetVersionAction", "startLocalHistoryAction"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/history/GetVersionAction", "startLocalHistoryAction"));
        }
        return LocalHistory.getInstance().startAction(GetVersionAction.createGetActionTitle(filePath, revision));
    }

    @NotNull
    private static String createGetActionTitle(@NotNull FilePath filePath, @NotNull VcsFileRevision revision) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/GetVersionAction", "createGetActionTitle"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/history/GetVersionAction", "createGetActionTitle"));
        }
        String string = VcsBundle.message((String)"action.name.for.file.get.version", (Object[])new Object[]{filePath.getPath(), revision.getRevisionNumber()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/GetVersionAction", "createGetActionTitle"));
        }
        return string;
    }

    private static void write(@NotNull FilePath filePath, byte[] revision, @NotNull Project project2) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/GetVersionAction", "write"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/history/GetVersionAction", "write"));
        }
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile == null) {
            FileUtil.writeToFile((File)filePath.getIOFile(), (byte[])revision);
        } else {
            Document document = !virtualFile.getFileType().isBinary() ? FileDocumentManager.getInstance().getDocument(virtualFile) : null;
            if (document == null) {
                virtualFile.setBinaryContent(revision);
            } else {
                String content = StringUtil.convertLineSeparators((String)new String(revision, filePath.getCharset().name()));
                CommandProcessor.getInstance().executeCommand(project2, () -> document.replaceString(0, document.getTextLength(), (CharSequence)content), VcsBundle.message((String)"message.title.get.version", (Object[])new Object[0]), null);
            }
        }
    }

    private static class MyWriteVersionTask
    extends Task.Backgroundable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final VcsFileRevision myRevision;
        @Nullable
        private final VirtualFile myFile;

        public MyWriteVersionTask(@NotNull Project project2, @NotNull FilePath filePath, @NotNull VcsFileRevision revision) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/history/GetVersionAction$MyWriteVersionTask", "<init>"));
            }
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/GetVersionAction$MyWriteVersionTask", "<init>"));
            }
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/history/GetVersionAction$MyWriteVersionTask", "<init>"));
            }
            super(project2, VcsBundle.message((String)"show.diff.progress.title", (Object[])new Object[0]));
            this.myProject = project2;
            this.myFilePath = filePath;
            this.myRevision = revision;
            this.myFile = filePath.getVirtualFile();
        }

        public void run(@NotNull ProgressIndicator indicator) {
            byte[] revisionContent;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/history/GetVersionAction$MyWriteVersionTask", "run"));
            }
            LocalHistoryAction action = this.myFile != null ? GetVersionAction.startLocalHistoryAction(this.myFilePath, this.myRevision) : LocalHistoryAction.NULL;
            try {
                revisionContent = VcsHistoryUtil.loadRevisionContent(this.myRevision);
            }
            catch (VcsException | IOException e) {
                LOG.info(e);
                ApplicationManager.getApplication().invokeLater(() -> MyWriteVersionTask.lambda$run$0((Exception)e));
                return;
            }
            catch (ProcessCanceledException ex) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    new WriteCommandAction.Simple(this.myProject, new PsiFile[0]){

                        protected void run() throws Throwable {
                            if (myFile != null && !myFile.isWritable() && ReadonlyStatusHandler.getInstance((Project)myProject).ensureFilesWritable(new VirtualFile[]{myFile}).hasReadonlyFiles()) {
                                return;
                            }
                            try {
                                GetVersionAction.write(myFilePath, revisionContent, myProject);
                            }
                            catch (IOException e) {
                                Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.save.content", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                            }
                        }
                    }.execute();
                    if (this.myFile != null) {
                        VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(this.myFile);
                    }
                }
                finally {
                    action.finish();
                }
            });
        }

        private static /* synthetic */ void lambda$run$0(Exception e) {
            Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
        }
    }
}

