/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MappingsToRoots {
    private final NewMappings myMappings;
    private final Project myProject;

    public MappingsToRoots(NewMappings mappings, Project project2) {
        this.myMappings = mappings;
        this.myProject = project2;
    }

    @NotNull
    public VirtualFile[] getRootsUnderVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/impl/projectlevelman/MappingsToRoots", "getRootsUnderVcs"));
        }
        List result2 = this.myMappings.getMappingsAsFilesUnderVcs(vcs);
        AbstractVcs.RootsConvertor convertor = vcs.getCustomConvertor();
        if (convertor != null) {
            result2 = convertor.convertRoots(result2);
        }
        Collections.sort(result2, FilePathComparator.getInstance());
        if (!vcs.allowsNestedRoots()) {
            FileIndexFacade facade = (FileIndexFacade)PeriodicalTasksCloser.getInstance().safeGetService(this.myProject, FileIndexFacade.class);
            List finalResult = result2;
            ApplicationManager.getApplication().runReadAction(() -> {
                int i2 = 1;
                while (i2 < finalResult.size()) {
                    VirtualFile current;
                    VirtualFile previous = (VirtualFile)finalResult.get(i2 - 1);
                    if (facade.isValidAncestor(previous, current = (VirtualFile)finalResult.get(i2))) {
                        finalResult.remove(i2);
                        continue;
                    }
                    ++i2;
                }
            });
        }
        result2.removeIf(file2 -> !file2.isDirectory());
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)result2);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/projectlevelman/MappingsToRoots", "getRootsUnderVcs"));
        }
        return virtualFileArray;
    }

    public List<VirtualFile> getDetailedVcsMappings(AbstractVcs vcs) {
        List<VirtualFile> result2 = this.myMappings.getMappingsAsFilesUnderVcs(vcs);
        boolean addInnerModules = true;
        String vcsName = vcs.getName();
        List<VcsDirectoryMapping> directoryMappings = this.myMappings.getDirectoryMappings(vcsName);
        for (VcsDirectoryMapping directoryMapping : directoryMappings) {
            if (!directoryMapping.isDefaultMapping()) continue;
            addInnerModules = false;
            break;
        }
        Collections.sort(result2, FilePathComparator.getInstance());
        if (addInnerModules) {
            FileIndexFacade facade = (FileIndexFacade)PeriodicalTasksCloser.getInstance().safeGetService(this.myProject, FileIndexFacade.class);
            List<VirtualFile> modules = DefaultVcsRootPolicy.getInstance(this.myProject).getDefaultVcsRoots(this.myMappings, vcsName);
            ApplicationManager.getApplication().runReadAction(() -> {
                Iterator iterator = modules.iterator();
                while (iterator.hasNext()) {
                    VirtualFile module2 = (VirtualFile)iterator.next();
                    boolean included = false;
                    for (VirtualFile root : result2) {
                        if (!facade.isValidAncestor(root, module2)) continue;
                        included = true;
                        break;
                    }
                    if (included) continue;
                    iterator.remove();
                }
            });
            result2.addAll(modules);
        }
        result2.removeIf(file2 -> !file2.isDirectory());
        return result2;
    }
}

