/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.Producer;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileEncodingConfigurable
extends PerFileConfigurableBase<Charset> {
    private JPanel myPanel;
    private JCheckBox myTransparentNativeToAsciiCheckBox;
    private JPanel myPropertiesFilesEncodingCombo;
    private JPanel myTablePanel;
    private Charset myPropsCharset;

    public FileEncodingConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "<init>"));
        }
        super(project2, FileEncodingConfigurable.createMappings(project2));
        this.$$$setupUI$$$();
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"file.encodings.configurable", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settingsdialog.project.file.encodings";
    }

    @Override
    @NotNull
    public String getId() {
        if ("File.Encoding" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "getId"));
        }
        return "File.Encoding";
    }

    @Override
    protected <S> Object getParameter(@NotNull Key<S> key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "getParameter"));
        }
        if (key2 == DESCRIPTION) {
            return IdeBundle.message((String)"encodings.dialog.caption", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        }
        if (key2 == MAPPING_TITLE) {
            return "Encoding";
        }
        if (key2 == TARGET_TITLE) {
            return "Path";
        }
        if (key2 == OVERRIDE_QUESTION) {
            return null;
        }
        if (key2 == OVERRIDE_TITLE) {
            return null;
        }
        if (key2 == EMPTY_TEXT) {
            return IdeBundle.message((String)"file.encodings.not.configured", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    protected void renderValue(@Nullable Object target, @NotNull Charset t, @NotNull ColoredTextContainer renderer) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "renderValue"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "renderValue"));
        }
        VirtualFile file2 = target instanceof VirtualFile ? (VirtualFile)target : null;
        Pair<Charset, String> check = file2 == null || file2.isDirectory() ? null : EncodingUtil.checkSomeActionEnabled(file2);
        String failReason = check == null ? null : (String)check.second;
        String encodingText = t.displayName();
        SimpleTextAttributes attributes = failReason == null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
        renderer.append(encodingText + (failReason == null ? "" : " (" + failReason + ")"), attributes);
    }

    @Override
    @NotNull
    protected ActionGroup createActionListGroup(@Nullable Object target, final @NotNull Consumer<Charset> onChosen) {
        if (onChosen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onChosen", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "createActionListGroup"));
        }
        VirtualFile file2 = target instanceof VirtualFile ? (VirtualFile)target : null;
        byte[] b = null;
        try {
            b = file2 == null || file2.isDirectory() ? null : file2.contentsToByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] bytes = b;
        Document document = file2 == null ? null : FileDocumentManager.getInstance().getDocument(file2);
        DefaultActionGroup defaultActionGroup = new ChangeFileEncodingAction(true){

            @Override
            protected boolean chosen(Document document, Editor editor, VirtualFile virtualFile, byte[] bytes, @NotNull Charset charset) {
                if (charset == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable$1", "chosen"));
                }
                onChosen.consume((Object)charset);
                return true;
            }
        }.createActionGroup(file2, null, document, bytes, this.getClearValueText(target));
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "createActionListGroup"));
        }
        return defaultActionGroup;
    }

    @Override
    @Nullable
    protected String getClearValueText(@Nullable Object target) {
        if (target == null) {
            return "<System Default>";
        }
        return super.getClearValueText(target);
    }

    @Override
    @Nullable
    protected String getNullValueText(@Nullable Object target) {
        if (target == null) {
            return IdeBundle.message((String)"encoding.name.system.default", (Object[])new Object[]{CharsetToolkit.getDefaultSystemCharset().displayName()});
        }
        return super.getNullValueText(target);
    }

    @Override
    @NotNull
    protected Collection<Charset> getValueVariants(@Nullable Object target) {
        List<Charset> list = Arrays.asList(CharsetToolkit.getAvailableCharsets());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "getValueVariants"));
        }
        return list;
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        this.myTablePanel.add((Component)super.createComponent(), "Center");
        JPanel p = this.createActionPanel(null, () -> this.myPropsCharset, o -> {
            this.myPropsCharset = o;
        });
        this.myPropertiesFilesEncodingCombo.add((Component)p, "Center");
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "createComponent"));
        }
        return jPanel;
    }

    @Override
    @NotNull
    protected List<Trinity<String, Producer<Charset>, Consumer<Charset>>> getDefaultMappings() {
        EncodingManager app = EncodingManager.getInstance();
        EncodingProjectManagerImpl prj = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject);
        List<Trinity<String, Producer<Charset>, Consumer<Charset>>> list = Arrays.asList(Trinity.create((Object)"Global Encoding", () -> app.getDefaultCharsetName().isEmpty() ? null : app.getDefaultCharset(), o -> app.setDefaultCharsetName(FileEncodingConfigurable.getCharsetName(o))), Trinity.create((Object)"Project Encoding", () -> prj.getConfiguredDefaultCharset(), o -> prj.setDefaultCharsetName(FileEncodingConfigurable.getCharsetName(o))));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "getDefaultMappings"));
        }
        return list;
    }

    @Override
    protected Charset adjustChosenValue(@Nullable Object target, Charset chosen) {
        return chosen == ChooseFileEncodingAction.NO_ENCODING ? null : chosen;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        EncodingProjectManagerImpl prjManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject);
        boolean same = Comparing.equal((Object)prjManager.getDefaultCharsetForPropertiesFiles(null), (Object)this.myPropsCharset) && prjManager.isNative2AsciiForPropertiesFiles() == this.myTransparentNativeToAsciiCheckBox.isSelected();
        return !same;
    }

    @NotNull
    private static String getCharsetName(@Nullable Charset c) {
        String string = c == null ? "" : c.name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "getCharsetName"));
        }
        return string;
    }

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        EncodingProjectManagerImpl prjManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject);
        prjManager.setDefaultCharsetForPropertiesFiles(null, this.myPropsCharset);
        prjManager.setNative2AsciiForPropertiesFiles(null, this.myTransparentNativeToAsciiCheckBox.isSelected());
    }

    @Override
    public void reset() {
        EncodingProjectManager prjManager = EncodingProjectManager.getInstance((Project)this.myProject);
        this.myTransparentNativeToAsciiCheckBox.setSelected(prjManager.isNative2AsciiForPropertiesFiles());
        this.myPropsCharset = prjManager.getDefaultCharsetForPropertiesFiles(null);
        super.reset();
    }

    @Override
    protected boolean canEditTarget(@Nullable Object target, Charset value) {
        return target == null || target instanceof VirtualFile && (((VirtualFile)target).isDirectory() || EncodingUtil.checkSomeActionEnabled((VirtualFile)target) == null);
    }

    @NotNull
    private static PerFileMappings<Charset> createMappings(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "createMappings"));
        }
        final EncodingProjectManagerImpl prjManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)project2);
        PerFileMappings<Charset> perFileMappings = new PerFileMappings<Charset>(){

            @NotNull
            public Map<VirtualFile, Charset> getMappings() {
                Map<VirtualFile, Charset> map = prjManager.getAllMappings();
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable$2", "getMappings"));
                }
                return map;
            }

            public void setMappings(@NotNull Map<VirtualFile, Charset> mappings) {
                if (mappings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable$2", "setMappings"));
                }
                prjManager.setMapping(mappings);
            }

            public void setMapping(@Nullable VirtualFile file2, Charset value) {
                throw new UnsupportedOperationException();
            }

            public Charset getMapping(@Nullable VirtualFile file2) {
                throw new UnsupportedOperationException();
            }

            @Nullable
            public Charset getDefaultMapping(@Nullable VirtualFile file2) {
                return prjManager.getEncoding(file2, true);
            }
        };
        if (perFileMappings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable", "createMappings"));
        }
        return perFileMappings;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Properties Files (*.properties)", (int)0, (int)0, null, null));
        this.myPropertiesFilesEncodingCombo = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("editbox.default.encoding.for.properties.files"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTransparentNativeToAsciiCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.transparent.native.to.ascii.conversion"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

