/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipEntryMap;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipHandler
extends ArchiveHandler {
    private volatile String myCanonicalPathToZip;
    private volatile long myFileStamp;
    private volatile long myFileLength;
    private static final FileAccessorCache<ZipHandler, ZipFile> ourZipFileFileAccessorCache = new FileAccessorCache<ZipHandler, ZipFile>(20, 10){

        protected ZipFile createAccessor(ZipHandler key2) throws IOException {
            String canonicalPathToZip = key2.getCanonicalPathToZip();
            ZipHandler.setFileStampAndLength(key2, canonicalPathToZip);
            return new ZipFile(canonicalPathToZip);
        }

        protected void disposeAccessor(ZipFile fileAccessor) throws IOException {
            fileAccessor.close();
        }

        public boolean isEqual(ZipHandler val1, ZipHandler val2) {
            return val1 == val2;
        }
    };

    public ZipHandler(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/ZipHandler", "<init>"));
        }
        super(path);
    }

    protected static synchronized void setFileStampAndLength(ZipHandler zipHandler, String pathToZip) {
        FileAttributes attributes = FileSystemUtil.getAttributes((String)pathToZip);
        zipHandler.myFileStamp = attributes != null ? attributes.lastModified : -1L;
        zipHandler.myFileLength = attributes != null ? attributes.length : 0L;
    }

    @NotNull
    private String getCanonicalPathToZip() throws IOException {
        String value = this.myCanonicalPathToZip;
        if (value == null) {
            this.myCanonicalPathToZip = value = this.getFileToUse().getCanonicalPath();
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getCanonicalPathToZip"));
        }
        return string;
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        FileAccessorCache.Handle<ZipFile> existingZipRef = this.getCachedZipFileHandle(true);
        assert (existingZipRef != null);
        Map<String, ArchiveHandler.EntryInfo> map = this.buildEntryMapForZipFile((ZipFile)existingZipRef.get());
        Map<String, ArchiveHandler.EntryInfo> map2 = map;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "createEntriesMap"));
        }
        return map2;
        finally {
            existingZipRef.release();
        }
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> buildEntryMapForZipFile(ZipFile zip) {
        ZipEntryMap map = new ZipEntryMap(zip.size());
        map.put("", this.createRootEntry());
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            this.getOrCreate(entries.nextElement(), (Map<String, ArchiveHandler.EntryInfo>)map, zip);
        }
        ZipEntryMap zipEntryMap = map;
        if (zipEntryMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "buildEntryMapForZipFile"));
        }
        return zipEntryMap;
    }

    @Nullable
    protected FileAccessorCache.Handle<ZipFile> getCachedZipFileHandle(boolean createHandleIfNeeded) throws IOException {
        FileAccessorCache.Handle handle;
        FileAccessorCache.Handle handle2 = handle = createHandleIfNeeded ? ourZipFileFileAccessorCache.get((Object)this) : ourZipFileFileAccessorCache.getIfCached((Object)this);
        if (handle != null && this.getFile() == this.getFileToUse()) {
            FileAttributes attributes = FileSystemUtil.getAttributes((String)this.getCanonicalPathToZip());
            if (attributes == null) {
                throw new FileNotFoundException(this.getCanonicalPathToZip());
            }
            if (attributes.lastModified == this.myFileStamp && attributes.length == this.myFileLength) {
                return handle;
            }
            this.removeZipHandlerFromCache();
            handle.release();
            handle = ourZipFileFileAccessorCache.get((Object)this);
        }
        return handle;
    }

    private void removeZipHandlerFromCache() {
        ourZipFileFileAccessorCache.remove((Object)this);
    }

    @NotNull
    protected File getFileToUse() {
        File file2 = this.getFile();
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getFileToUse"));
        }
        return file2;
    }

    public void dispose() {
        super.dispose();
        this.removeZipHandlerFromCache();
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull ZipEntry entry, @NotNull Map<String, ArchiveHandler.EntryInfo> map, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info;
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        if (zip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zip", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        boolean isDirectory = entry.isDirectory();
        String entryName = entry.getName();
        if (StringUtil.endsWithChar((CharSequence)entryName, (char)'/')) {
            entryName = entryName.substring(0, entryName.length() - 1);
            isDirectory = true;
        }
        if ((info = map.get(entryName)) != null) {
            ArchiveHandler.EntryInfo entryInfo = info;
            if (entryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
            }
            return entryInfo;
        }
        Pair path = this.splitPath(entryName);
        ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map, zip);
        if (".".equals(path.second)) {
            ArchiveHandler.EntryInfo entryInfo = parentInfo;
            if (entryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
            }
            return entryInfo;
        }
        ArchiveHandler.EntryInfo entryInfo = info = ZipHandler.store(map, parentInfo, (CharSequence)path.second, isDirectory, entry.getSize(), this.myFileStamp, entryName);
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        return entryInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static ArchiveHandler.EntryInfo store(@NotNull Map<String, ArchiveHandler.EntryInfo> map, @Nullable ArchiveHandler.EntryInfo parentInfo, @NotNull CharSequence shortName, boolean isDirectory, long size, long time, @NotNull String string) {
        void entryName;
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryName", "com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        CharSequence sequence = shortName instanceof ByteArrayCharSequence ? shortName : ByteArrayCharSequence.convertToBytesIfAsciiString((CharSequence)shortName);
        ArchiveHandler.EntryInfo info = new ArchiveHandler.EntryInfo(sequence, isDirectory, size, time, parentInfo);
        map.put((String)entryName, info);
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "store"));
        }
        return entryInfo;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull String entryName, Map<String, ArchiveHandler.EntryInfo> map, @NotNull ZipFile zip) {
        if (entryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryName", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        if (zip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zip", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        ArchiveHandler.EntryInfo info = map.get(entryName);
        if (info == null) {
            ZipEntry entry = zip.getEntry(entryName + "/");
            if (entry != null) {
                ArchiveHandler.EntryInfo entryInfo = this.getOrCreate(entry, map, zip);
                if (entryInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
                }
                return entryInfo;
            }
            Pair path = this.splitPath(entryName);
            ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map, zip);
            info = ZipHandler.store(map, parentInfo, (CharSequence)path.second, true, 0L, -1L, entryName);
        }
        if (!info.isDirectory) {
            Logger.getInstance(((Object)((Object)this)).getClass()).info(zip.getName() + ": " + entryName + " should be a directory");
            info = ZipHandler.store(map, info.parent, info.shortName, true, info.length, info.timestamp, entryName);
        }
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "getOrCreate"));
        }
        return entryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block10: {
            byte[] byArray;
            InputStream stream;
            FileAccessorCache.Handle<ZipFile> zipRef;
            block11: {
                if (relativePath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/ZipHandler", "contentsToByteArray"));
                }
                try {
                    zipRef = this.getCachedZipFileHandle(true);
                }
                catch (RuntimeException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw ex;
                }
                ZipFile zip = (ZipFile)zipRef.get();
                ZipEntry entry = zip.getEntry(relativePath);
                if (entry == null || (stream = zip.getInputStream(entry)) == null) break block10;
                byArray = FileUtil.loadBytes((InputStream)stream, (int)((int)entry.getSize()));
                stream.close();
                if (byArray != null) break block11;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ZipHandler", "contentsToByteArray"));
            }
            return byArray;
            {
                catch (Throwable throwable) {
                    stream.close();
                    throw throwable;
                }
            }
            finally {
                zipRef.release();
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    public static void clearFileAccessorCache() {
        ourZipFileFileAccessorCache.clear();
    }
}

