/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DesktopLayout {
    @NonNls
    static final String TAG = "layout";
    private final Map<String, WindowInfoImpl> myRegisteredId2Info = new HashMap();
    private final Map<String, WindowInfoImpl> myUnregisteredId2Info = new HashMap();
    private static final MyWindowInfoComparator ourWindowInfoComparator = new MyWindowInfoComparator();
    private WindowInfoImpl[] myRegisteredInfos;
    private WindowInfoImpl[] myUnregisteredInfos;
    private WindowInfoImpl[] myAllInfos;
    @NonNls
    private static final String ID_ATTR = "id";

    public final void copyFrom(@NotNull DesktopLayout layout) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TAG, "com/intellij/openapi/wm/impl/DesktopLayout", "copyFrom"));
        }
        for (WindowInfoImpl info1 : layout.getAllInfos()) {
            WindowInfoImpl info = this.myRegisteredId2Info.get(info1.getId());
            if (info != null) {
                info.copyFrom(info1);
                continue;
            }
            info = this.myUnregisteredId2Info.get(info1.getId());
            if (info != null) {
                info.copyFrom(info1);
                continue;
            }
            this.myUnregisteredId2Info.put(info1.getId(), info1.copy());
        }
        this.myRegisteredInfos = null;
        this.myUnregisteredInfos = null;
        this.myAllInfos = null;
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.TOP));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.LEFT));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.BOTTOM));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.RIGHT));
    }

    final WindowInfoImpl register(@NotNull String id, @NotNull ToolWindowAnchor anchor, boolean splitMode) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ID_ATTR, "com/intellij/openapi/wm/impl/DesktopLayout", "register"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/DesktopLayout", "register"));
        }
        WindowInfoImpl info = this.myUnregisteredId2Info.get(id);
        if (info != null) {
            this.myUnregisteredId2Info.remove(id);
        } else {
            info = new WindowInfoImpl(id);
            info.setAnchor(anchor);
            info.setSplit(splitMode);
        }
        this.myRegisteredId2Info.put(id, info);
        this.myRegisteredInfos = null;
        this.myUnregisteredInfos = null;
        this.myAllInfos = null;
        return info;
    }

    final void unregister(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ID_ATTR, "com/intellij/openapi/wm/impl/DesktopLayout", "unregister"));
        }
        WindowInfoImpl info = this.myRegisteredId2Info.remove(id).copy();
        this.myUnregisteredId2Info.put(id, info);
        this.myRegisteredInfos = null;
        this.myUnregisteredInfos = null;
        this.myAllInfos = null;
    }

    final WindowInfoImpl getInfo(String id, boolean onlyRegistered) {
        WindowInfoImpl info = this.myRegisteredId2Info.get(id);
        if (onlyRegistered || info != null) {
            return info;
        }
        return this.myUnregisteredId2Info.get(id);
    }

    @Nullable
    final String getActiveId() {
        WindowInfoImpl[] infos;
        for (WindowInfoImpl info : infos = this.getInfos()) {
            if (!info.isActive()) continue;
            return info.getId();
        }
        return null;
    }

    @NotNull
    final WindowInfoImpl[] getInfos() {
        if (this.myRegisteredInfos == null) {
            this.myRegisteredInfos = this.myRegisteredId2Info.values().toArray(new WindowInfoImpl[this.myRegisteredId2Info.size()]);
        }
        if (this.myRegisteredInfos == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/DesktopLayout", "getInfos"));
        }
        return this.myRegisteredInfos;
    }

    @NotNull
    private WindowInfoImpl[] getUnregisteredInfos() {
        if (this.myUnregisteredInfos == null) {
            this.myUnregisteredInfos = this.myUnregisteredId2Info.values().toArray(new WindowInfoImpl[this.myUnregisteredId2Info.size()]);
        }
        if (this.myUnregisteredInfos == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/DesktopLayout", "getUnregisteredInfos"));
        }
        return this.myUnregisteredInfos;
    }

    @NotNull
    private WindowInfoImpl[] getAllInfos() {
        Object[] registeredInfos = this.getInfos();
        Object[] unregisteredInfos = this.getUnregisteredInfos();
        this.myAllInfos = (WindowInfoImpl[])ArrayUtil.mergeArrays((Object[])registeredInfos, (Object[])unregisteredInfos);
        if (this.myAllInfos == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/DesktopLayout", "getAllInfos"));
        }
        return this.myAllInfos;
    }

    @NotNull
    private WindowInfoImpl[] getAllInfos(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/DesktopLayout", "getAllInfos"));
        }
        WindowInfoImpl[] infos = this.getAllInfos();
        ArrayList<WindowInfoImpl> list = new ArrayList<WindowInfoImpl>(infos.length);
        for (WindowInfoImpl info : infos) {
            if (anchor != info.getAnchor()) continue;
            list.add(info);
        }
        infos = list.toArray(new WindowInfoImpl[list.size()]);
        Arrays.sort(infos, ourWindowInfoComparator);
        if (infos == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/DesktopLayout", "getAllInfos"));
        }
        return infos;
    }

    private static void normalizeOrder(@NotNull WindowInfoImpl[] infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/openapi/wm/impl/DesktopLayout", "normalizeOrder"));
        }
        for (int i2 = 0; i2 < infos.length; ++i2) {
            infos[i2].setOrder(i2);
        }
    }

    final boolean isToolWindowRegistered(String id) {
        return this.myRegisteredId2Info.containsKey(id);
    }

    final boolean isToolWindowUnregistered(String id) {
        return this.myUnregisteredId2Info.containsKey(id);
    }

    @NotNull
    final Comparator<StripeButton> comparator(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/DesktopLayout", "comparator"));
        }
        MyStripeButtonComparator myStripeButtonComparator = new MyStripeButtonComparator(anchor);
        if (myStripeButtonComparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/DesktopLayout", "comparator"));
        }
        return myStripeButtonComparator;
    }

    private int getMaxOrder(@NotNull ToolWindowAnchor anchor) {
        WindowInfoImpl[] infos;
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/DesktopLayout", "getMaxOrder"));
        }
        int res = -1;
        for (WindowInfoImpl info : infos = this.getAllInfos()) {
            if (anchor != info.getAnchor() || res >= info.getOrder()) continue;
            res = info.getOrder();
        }
        return res;
    }

    final void setAnchor(@NotNull String id, @NotNull ToolWindowAnchor newAnchor, int newOrder) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ID_ATTR, "com/intellij/openapi/wm/impl/DesktopLayout", "setAnchor"));
        }
        if (newAnchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newAnchor", "com/intellij/openapi/wm/impl/DesktopLayout", "setAnchor"));
        }
        if (newOrder == -1) {
            newOrder = this.getMaxOrder(newAnchor) + 1;
        }
        WindowInfoImpl info = this.getInfo(id, true);
        ToolWindowAnchor oldAnchor = info.getAnchor();
        WindowInfoImpl[] infos = this.getAllInfos(newAnchor);
        for (int i2 = infos.length - 1; i2 > -1; --i2) {
            WindowInfoImpl info2 = infos[i2];
            if (newOrder > info2.getOrder()) continue;
            info2.setOrder(info2.getOrder() + 1);
        }
        info.setAnchor(newAnchor);
        info.setOrder(newOrder);
        DesktopLayout.normalizeOrder(this.getAllInfos(oldAnchor));
        if (oldAnchor != newAnchor) {
            DesktopLayout.normalizeOrder(this.getAllInfos(newAnchor));
        }
    }

    final void setSplitMode(@NotNull String id, boolean split) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ID_ATTR, "com/intellij/openapi/wm/impl/DesktopLayout", "setSplitMode"));
        }
        WindowInfoImpl info = this.getInfo(id, true);
        info.setSplit(split);
    }

    public final void readExternal(@NotNull Element layoutElement) {
        if (layoutElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutElement", "com/intellij/openapi/wm/impl/DesktopLayout", "readExternal"));
        }
        this.myUnregisteredInfos = null;
        for (Element e : layoutElement.getChildren()) {
            if (!"window_info".equals(e.getName())) continue;
            String id = e.getAttributeValue(ID_ATTR);
            assert (id != null);
            WindowInfoImpl info = new WindowInfoImpl(id);
            info.readExternal(e);
            if (info.getOrder() == -1) {
                info.setOrder(this.getMaxOrder(info.getAnchor()) + 1);
            }
            this.myUnregisteredId2Info.put(info.getId(), info);
        }
    }

    @Nullable
    public final Element writeExternal(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/openapi/wm/impl/DesktopLayout", "writeExternal"));
        }
        WindowInfoImpl[] infos = this.getAllInfos();
        if (infos.length == 0) {
            return null;
        }
        Element state = new Element(tagName);
        for (WindowInfoImpl info : infos) {
            Element element = new Element("window_info");
            info.writeExternal(element);
            state.addContent(element);
        }
        return state;
    }

    @NotNull
    List<String> getVisibleIdsOn(@NotNull ToolWindowAnchor anchor, @NotNull ToolWindowManagerImpl manager) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/DesktopLayout", "getVisibleIdsOn"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/wm/impl/DesktopLayout", "getVisibleIdsOn"));
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (WindowInfoImpl each : this.getAllInfos(anchor)) {
            ToolWindow window = manager.getToolWindow(each.getId());
            if (window == null || !window.isAvailable() && !UISettings.getInstance().getAlwaysShowWindowsButton()) continue;
            ids.add(each.getId());
        }
        ArrayList<String> arrayList = ids;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/DesktopLayout", "getVisibleIdsOn"));
        }
        return arrayList;
    }

    private final class MyStripeButtonComparator
    implements Comparator<StripeButton> {
        private final HashMap<String, WindowInfoImpl> myId2Info;

        public MyStripeButtonComparator(ToolWindowAnchor anchor) {
            WindowInfoImpl[] infos;
            if (anchor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/DesktopLayout$MyStripeButtonComparator", "<init>"));
            }
            this.myId2Info = new HashMap();
            for (WindowInfoImpl info : infos = DesktopLayout.this.getInfos()) {
                if (anchor != info.getAnchor()) continue;
                this.myId2Info.put((Object)info.getId(), (Object)info.copy());
            }
        }

        @Override
        public final int compare(StripeButton obj1, StripeButton obj2) {
            WindowInfoImpl info1 = (WindowInfoImpl)this.myId2Info.get((Object)obj1.getWindowInfo().getId());
            int order1 = info1 != null ? info1.getOrder() : 0;
            WindowInfoImpl info2 = (WindowInfoImpl)this.myId2Info.get((Object)obj2.getWindowInfo().getId());
            int order2 = info2 != null ? info2.getOrder() : 0;
            return order1 - order2;
        }
    }

    private static final class MyWindowInfoComparator
    implements Comparator<WindowInfoImpl> {
        private MyWindowInfoComparator() {
        }

        @Override
        public int compare(WindowInfoImpl info1, WindowInfoImpl info2) {
            return info1.getOrder() - info2.getOrder();
        }
    }
}

