/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButtonUI;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StripeButton
extends AnchoredButton
implements ActionListener,
Disposable {
    private final Color ourBackgroundColor;
    private int myMnemonic;
    private final InternalDecorator myDecorator;
    private boolean myPressedWhenSelected;
    private JLayeredPane myDragPane;
    private final ToolWindowsPane myPane;
    private JLabel myDragButtonImage;
    private Point myPressedPoint;
    private Stripe myLastStripe;
    private KeyEventDispatcher myDragKeyEventDispatcher;
    private boolean myDragCancelled;
    private final MyKeymapListener myKeymapListener;

    StripeButton(@NotNull InternalDecorator decorator, ToolWindowsPane pane) {
        if (decorator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decorator", "com/intellij/openapi/wm/impl/StripeButton", "<init>"));
        }
        this.ourBackgroundColor = new Color(247, 243, 239);
        this.myDragCancelled = false;
        this.myDecorator = decorator;
        this.myKeymapListener = new MyKeymapListener();
        this.myPane = pane;
        this.init();
    }

    @Override
    public void setMnemonic(int mnemonic) {
        throw new UnsupportedOperationException("use setMnemonic2(int)");
    }

    private void setMnemonic2(int mnemonic) {
        this.myMnemonic = mnemonic;
        this.revalidate();
        this.repaint();
    }

    @Override
    public int getMnemonic2() {
        return this.myMnemonic;
    }

    @Override
    public ToolWindowAnchor getAnchor() {
        return this.getWindowInfo().getAnchor();
    }

    @NotNull
    WindowInfoImpl getWindowInfo() {
        WindowInfoImpl windowInfoImpl = this.myDecorator.getWindowInfo();
        if (windowInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/StripeButton", "getWindowInfo"));
        }
        return windowInfoImpl;
    }

    private void init() {
        this.setFocusable(false);
        this.setBackground(this.ourBackgroundColor);
        JBEmptyBorder border = JBUI.Borders.empty((int)5, (int)5, (int)0, (int)5);
        this.setBorder((Border)border);
        this.updatePresentation();
        this.apply(this.myDecorator.getWindowInfo());
        this.addActionListener(this);
        this.addMouseListener((MouseListener)((Object)new MyPopupHandler()));
        this.setRolloverEnabled(true);
        this.setOpaque(false);
        this.enableEvents(16L);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                StripeButton.this.processDrag(e);
            }
        });
        KeymapManager.getInstance().addKeymapManagerListener((KeymapManagerListener)this.myKeymapListener, (Disposable)this);
    }

    public boolean isFirst() {
        return this.is(true);
    }

    public boolean isLast() {
        return this.is(false);
    }

    public boolean isOppositeSide() {
        return this.getWindowInfo().isSplit();
    }

    private boolean is(boolean first) {
        Container parent = this.getParent();
        if (parent == null) {
            return false;
        }
        int max = first ? Integer.MAX_VALUE : 0;
        ToolWindowAnchor anchor = this.getAnchor();
        Component c = null;
        int count = parent.getComponentCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Component component = parent.getComponent(i2);
            if (!component.isVisible()) continue;
            Rectangle r = component.getBounds();
            if (anchor == ToolWindowAnchor.LEFT || anchor == ToolWindowAnchor.RIGHT) {
                if ((!first || max <= r.y) && (first || max >= r.y)) continue;
                max = r.y;
                c = component;
                continue;
            }
            if ((!first || max <= r.x) && (first || max >= r.x)) continue;
            max = r.x;
            c = component;
        }
        return c == this;
    }

    @NotNull
    public InternalDecorator getDecorator() {
        InternalDecorator internalDecorator = this.myDecorator;
        if (internalDecorator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/StripeButton", "getDecorator"));
        }
        return internalDecorator;
    }

    private void processDrag(MouseEvent e) {
        if (this.myDragCancelled || !MouseDragHelper.checkModifiers((InputEvent)e)) {
            return;
        }
        if (!this.isDraggingNow()) {
            if (this.myPressedPoint == null) {
                return;
            }
            if (this.isWithinDeadZone(e)) {
                return;
            }
            this.myDragPane = StripeButton.findLayeredPane(e);
            if (this.myDragPane == null) {
                return;
            }
            int width = this.getWidth() - 1;
            int height = this.getHeight() - 1;
            BufferedImage image = UIUtil.createImage((Component)e.getComponent(), (int)width, (int)height, (int)1);
            Graphics graphics = image.getGraphics();
            graphics.setColor(UIUtil.getBgFillColor((Component)this.getParent()));
            graphics.fillRect(0, 0, width, height);
            this.paint(graphics);
            graphics.dispose();
            this.myDragButtonImage = new JLabel((Icon)new JBImageIcon((Image)image)){

                @Override
                public String toString() {
                    return "Image for: " + StripeButton.this.toString();
                }
            };
            this.myDragButtonImage.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    StripeButton.this.finishDragging();
                    StripeButton.this.myPressedPoint = null;
                    StripeButton.this.myDragButtonImage = null;
                    super.mouseReleased(e);
                }
            });
            this.myDragPane.add((Component)this.myDragButtonImage, JLayeredPane.POPUP_LAYER);
            this.myDragButtonImage.setSize(this.myDragButtonImage.getPreferredSize());
            this.setVisible(false);
            this.myPane.startDrag();
            this.myDragKeyEventDispatcher = new DragKeyEventDispatcher();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.myDragKeyEventDispatcher);
        }
        if (!this.isDraggingNow()) {
            return;
        }
        Point xy = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.myDragPane);
        if (this.myPressedPoint != null) {
            xy.x -= this.myPressedPoint.x;
            xy.y -= this.myPressedPoint.y;
        }
        this.myDragButtonImage.setLocation(xy);
        SwingUtilities.convertPointToScreen(xy, this.myDragPane);
        Stripe stripe = this.myPane.getStripeFor(new Rectangle(xy, this.myDragButtonImage.getSize()), (Stripe)this.getParent());
        if (stripe == null) {
            if (this.myLastStripe != null) {
                this.myLastStripe.resetDrop();
            }
        } else {
            if (this.myLastStripe != null && this.myLastStripe != stripe) {
                this.myLastStripe.resetDrop();
            }
            stripe.processDropButton(this, this.myDragButtonImage, xy);
        }
        this.myLastStripe = stripe;
    }

    private boolean isWithinDeadZone(MouseEvent e) {
        return Math.abs(this.myPressedPoint.x - e.getPoint().x) < 7 && Math.abs(this.myPressedPoint.y - e.getPoint().y) < 7;
    }

    @Nullable
    private static JLayeredPane findLayeredPane(MouseEvent e) {
        if (!(e.getComponent() instanceof JComponent)) {
            return null;
        }
        JRootPane root = ((JComponent)e.getComponent()).getRootPane();
        return root.getLayeredPane();
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger() && e.getComponent().isShowing()) {
            super.processMouseEvent(e);
            return;
        }
        if (UIUtil.isCloseClick((MouseEvent)e)) {
            this.myDecorator.fireHiddenSide();
            return;
        }
        if (e.getButton() == 1) {
            if (501 == e.getID()) {
                this.myPressedPoint = e.getPoint();
                this.myPressedWhenSelected = this.isSelected();
                this.myDragCancelled = false;
            } else if (502 == e.getID()) {
                this.finishDragging();
                this.myPressedPoint = null;
                this.myDragButtonImage = null;
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.myPressedWhenSelected) {
            this.myDecorator.fireHidden();
        } else {
            this.myDecorator.fireActivated();
        }
        this.myPressedWhenSelected = false;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("toolwindow.clickstat." + this.myDecorator.getToolWindow().getId());
    }

    public void apply(@NotNull WindowInfoImpl info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/StripeButton", "apply"));
        }
        this.setSelected(info.isVisible() || info.isActive());
        this.updateState();
    }

    public void dispose() {
    }

    private void showPopup(Component component, int x, int y) {
        ActionGroup group = this.myDecorator.createPopupGroup();
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", group);
        popupMenu.getComponent().show(component, x, y);
    }

    @Override
    public void updateUI() {
        this.setUI(StripeButtonUI.createUI(this));
        Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
        this.setFont(font);
    }

    void updatePresentation() {
        this.updateState();
        this.updateText();
        Icon icon = this.myDecorator.getToolWindow().getIcon();
        this.setIcon(icon);
        this.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
    }

    private void updateText() {
        String text = this.myDecorator.getToolWindow().getStripeTitle();
        if (UISettings.getInstance().getShowToolWindowsNumbers()) {
            String toolWindowId = this.myDecorator.getToolWindow().getId();
            int mnemonic = ActivateToolWindowAction.getMnemonicForToolWindow(toolWindowId);
            if (mnemonic != -1) {
                text = (char)mnemonic + ": " + text;
                this.setMnemonic2(mnemonic);
            } else {
                this.setMnemonic2(0);
            }
        }
        this.setText(text);
    }

    private void updateState() {
        boolean toShow;
        ToolWindowImpl window = this.myDecorator.getToolWindow();
        boolean bl = toShow = window.isAvailable() || window.isPlaceholderMode();
        if (UISettings.getInstance().getAlwaysShowWindowsButton()) {
            this.setVisible(window.isShowStripeButton() || this.isSelected());
        } else {
            this.setVisible(toShow && (window.isShowStripeButton() || this.isSelected()));
        }
        this.setEnabled(toShow && !window.isPlaceholderMode());
    }

    private boolean isDraggingNow() {
        return this.myDragButtonImage != null;
    }

    private void finishDragging() {
        if (!this.isDraggingNow()) {
            return;
        }
        this.myDragPane.remove(this.myDragButtonImage);
        this.myDragButtonImage = null;
        this.myPane.stopDrag();
        this.myDragPane.repaint();
        this.setVisible(true);
        if (this.myLastStripe != null) {
            this.myLastStripe.finishDrop();
            this.myLastStripe = null;
        }
        if (this.myDragKeyEventDispatcher != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.myDragKeyEventDispatcher);
            this.myDragKeyEventDispatcher = null;
        }
    }

    @Override
    public String toString() {
        return StringUtil.getShortName((String)this.getClass().getName()) + " text: " + this.getText();
    }

    private final class MyKeymapListener
    implements KeymapManagerListener {
        private MyKeymapListener() {
        }

        public void activeKeymapChanged(Keymap keymap) {
            StripeButton.this.updatePresentation();
        }
    }

    private final class MyPopupHandler
    extends PopupHandler {
        private MyPopupHandler() {
        }

        public void invokePopup(Component component, int x, int y) {
            StripeButton.this.showPopup(component, x, y);
        }
    }

    private class DragKeyEventDispatcher
    implements KeyEventDispatcher {
        private DragKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (StripeButton.this.isDraggingNow() && e.getKeyCode() == 27 && e.getID() == 401) {
                StripeButton.this.myDragCancelled = true;
                StripeButton.this.finishDragging();
                return true;
            }
            return false;
        }
    }
}

