/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.header.AuxiliaryRightPanel;
import com.intellij.profile.codeInspection.ui.header.ManageButton;
import com.intellij.profile.codeInspection.ui.header.ManageButtonBuilder;
import com.intellij.profile.codeInspection.ui.header.ProfilesChooser;
import com.intellij.profile.codeInspection.ui.header.SaveInputComponentValidator;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionToolsConfigurable
extends BaseConfigurable
implements ErrorsConfigurable,
SearchableConfigurable,
Configurable.NoScroll {
    public static final String ID = "Errors";
    public static final String DISPLAY_NAME = "Inspections";
    private static final String HEADER_TITLE = "Profile:";
    private static final Logger LOG = Logger.getInstance(InspectionToolsConfigurable.class);
    private static final Pattern COPIED_PROFILE_SUFFIX_PATTERN = Pattern.compile("(.*\\s*copy)\\s*(\\d*)");
    protected final BaseInspectionProfileManager myApplicationProfileManager;
    protected final ProjectInspectionProfileManager myProjectProfileManager;
    private final List<SingleInspectionProfilePanel> myPanels;
    private final List<InspectionProfileModifiableModel> myDeletedProfiles;
    protected ProfilesChooser myProfiles;
    private JPanel myProfilePanelHolder;
    private AuxiliaryRightPanel myAuxiliaryRightPanel;
    private Alarm mySelectionAlarm;

    public InspectionToolsConfigurable(@NotNull ProjectInspectionProfileManager projectProfileManager) {
        if (projectProfileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectProfileManager", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "<init>"));
        }
        this.myPanels = new ArrayList<SingleInspectionProfilePanel>();
        this.myDeletedProfiles = new SmartList();
        this.myProjectProfileManager = projectProfileManager;
        this.myApplicationProfileManager = (BaseInspectionProfileManager)InspectionProfileManager.getInstance();
    }

    private static JComponent withBorderOnTop(JComponent component) {
        JPanel panel2 = new JPanel();
        panel2.add(component);
        panel2.setBorder(IdeBorderFactory.createEmptyBorder((int)(UIUtil.isUnderDarcula() ? 10 : 13), (int)0, (int)0, (int)0));
        return panel2;
    }

    private Project getProject() {
        return this.myProjectProfileManager.getProject();
    }

    @NotNull
    private InspectionProfileImpl copyToNewProfile(@NotNull InspectionProfileImpl selectedProfile, @NotNull Project project2, boolean modifyName, boolean modifyLevel) {
        if (selectedProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedProfile", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "copyToNewProfile"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "copyToNewProfile"));
        }
        LOG.assertTrue(modifyLevel || modifyName);
        String profileDefaultName = selectedProfile.getName();
        boolean isProjectLevel = selectedProfile.isProjectLevel() ^ modifyLevel;
        if (modifyName) {
            int nextIdx;
            Matcher matcher = COPIED_PROFILE_SUFFIX_PATTERN.matcher(profileDefaultName);
            if (matcher.matches()) {
                profileDefaultName = matcher.group(1);
                nextIdx = matcher.group(2).isEmpty() ? 1 : Integer.valueOf(matcher.group(2));
            } else {
                profileDefaultName = profileDefaultName + " copy";
                nextIdx = 1;
            }
            if (this.hasName(profileDefaultName, isProjectLevel)) {
                String currentProfileDefaultName;
                do {
                    currentProfileDefaultName = profileDefaultName + " " + String.valueOf(nextIdx);
                    ++nextIdx;
                } while (this.hasName(currentProfileDefaultName, isProjectLevel));
                profileDefaultName = currentProfileDefaultName;
            }
        }
        BaseInspectionProfileManager profileManager = isProjectLevel ? this.myProjectProfileManager : this.myApplicationProfileManager;
        InspectionProfileImpl inspectionProfile = new InspectionProfileImpl(profileDefaultName, InspectionToolRegistrar.getInstance(), profileManager);
        inspectionProfile.copyFrom(selectedProfile);
        inspectionProfile.setName(profileDefaultName);
        inspectionProfile.initInspectionTools(project2);
        inspectionProfile.setProjectLevel(isProjectLevel);
        InspectionProfileModifiableModel modifiableModel = new InspectionProfileModifiableModel(inspectionProfile);
        modifiableModel.setModified(true);
        this.addProfile(modifiableModel);
        InspectionProfileModifiableModel inspectionProfileModifiableModel = modifiableModel;
        if (inspectionProfileModifiableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "copyToNewProfile"));
        }
        return inspectionProfileModifiableModel;
    }

    protected void addProfile(InspectionProfileModifiableModel model) {
        SingleInspectionProfilePanel panel2 = this.createPanel(model);
        this.myPanels.add(panel2);
        this.myProfilePanelHolder.add(panel2);
        this.myProfiles.getProfilesComboBox().addProfile(model);
        this.myProfiles.getProfilesComboBox().selectProfile(model);
    }

    protected boolean setActiveProfileAsDefaultOnApply() {
        return true;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return "preferences.inspections";
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "getId"));
        }
        return ID;
    }

    public Runnable enableSearch(String option) {
        return () -> {
            SingleInspectionProfilePanel panel2 = this.getSelectedPanel();
            if (panel2 != null) {
                panel2.setFilter(option);
            }
        };
    }

    public JComponent createComponent() {
        final JPanel wholePanel = new JPanel();
        wholePanel.setLayout(new BorderLayout());
        JPanel toolbar = new JPanel();
        toolbar.setBorder(BorderFactory.createEmptyBorder(0, 0, 7, 0));
        this.myProfilePanelHolder = new JPanel(){

            @Override
            public void doLayout() {
                Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
                JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
                for (Component component : this.getComponents()) {
                    component.setBounds(bounds);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                for (Component component : this.getComponents()) {
                    if (!component.isVisible()) continue;
                    return component.getPreferredSize();
                }
                return super.getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                for (Component component : this.getComponents()) {
                    if (!component.isVisible()) continue;
                    return component.getMinimumSize();
                }
                return super.getMinimumSize();
            }
        };
        wholePanel.add((Component)toolbar, "First");
        wholePanel.add((Component)this.myProfilePanelHolder, "Center");
        this.myAuxiliaryRightPanel = new AuxiliaryRightPanel(new AuxiliaryRightPanel.DescriptionSaveListener(){

            @Override
            public void saveDescription(@NotNull String description) {
                if (description == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable$2", "saveDescription"));
                }
                InspectionProfileModifiableModel inspectionProfile = InspectionToolsConfigurable.this.getSelectedObject();
                if (!Comparing.strEqual((String)description, (String)inspectionProfile.getDescription())) {
                    inspectionProfile.setDescription(description);
                    inspectionProfile.setModified(true);
                }
                InspectionToolsConfigurable.this.myAuxiliaryRightPanel.showDescription(description);
            }

            @Override
            public void cancel() {
                InspectionToolsConfigurable.this.myAuxiliaryRightPanel.showDescription(InspectionToolsConfigurable.this.getSelectedObject().getDescription());
            }
        });
        this.myProfiles = new ProfilesChooser(this.myProjectProfileManager.getProject()){

            @Override
            public void onProfileChosen(InspectionProfileImpl inspectionProfile) {
                InspectionToolsConfigurable.this.showProfile(inspectionProfile);
                InspectionToolsConfigurable.this.myAuxiliaryRightPanel.showDescription(inspectionProfile.getDescription());
            }
        };
        JPanel profilesHolder = new JPanel();
        profilesHolder.setLayout(new CardLayout());
        JComponent manageButton = new ManageButton(new ManageButtonBuilder(){

            @Override
            public boolean isProjectLevel() {
                SingleInspectionProfilePanel panel2 = InspectionToolsConfigurable.this.getSelectedPanel();
                return panel2 != null && panel2.getProfile().isProjectLevel();
            }

            @Override
            public boolean canChangeProfileLevel() {
                return !InspectionToolsConfigurable.this.hasName(InspectionToolsConfigurable.this.getSelectedPanel().getProfile().getName(), !this.isProjectLevel());
            }

            @Override
            public void copyToAnotherLevel() {
                SingleInspectionProfilePanel selectedPanel = InspectionToolsConfigurable.this.getSelectedPanel();
                LOG.assertTrue(selectedPanel != null, (Object)("No settings selectedPanel for: " + InspectionToolsConfigurable.this.getSelectedObject()));
                InspectionToolsConfigurable.this.copyToNewProfile(InspectionToolsConfigurable.this.getSelectedObject(), InspectionToolsConfigurable.this.getProject(), false, true);
            }

            @Override
            public void copy() {
                this.rename(InspectionToolsConfigurable.this.copyToNewProfile(InspectionToolsConfigurable.this.getSelectedObject(), InspectionToolsConfigurable.this.getProject(), true, false));
            }

            @Override
            public void rename() {
                this.rename(InspectionToolsConfigurable.this.getSelectedObject());
            }

            private void rename(final @NotNull InspectionProfileImpl inspectionProfile) {
                if (inspectionProfile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable$4", "rename"));
                }
                final String initialName = InspectionToolsConfigurable.this.getSelectedPanel().getProfile().getName();
                InspectionToolsConfigurable.this.myProfiles.showEditCard(initialName, new SaveInputComponentValidator(){

                    @Override
                    public void doSave(@NotNull String text) {
                        if (text == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable$4$1", "doSave"));
                        }
                        if (!text.equals(initialName)) {
                            inspectionProfile.setName(text);
                            InspectionToolsConfigurable.this.myProfiles.getProfilesComboBox().resort();
                        }
                        InspectionToolsConfigurable.this.myProfiles.showComboBoxCard();
                    }

                    @Override
                    public boolean checkValid(@NotNull String text) {
                        boolean isValid;
                        if (text == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable$4$1", "checkValid"));
                        }
                        boolean bl = isValid = text.equals(initialName) || !InspectionToolsConfigurable.this.hasName(text, inspectionProfile.isProjectLevel());
                        if (isValid) {
                            InspectionToolsConfigurable.this.myAuxiliaryRightPanel.showDescription(InspectionToolsConfigurable.this.getSelectedObject().getDescription());
                        } else {
                            InspectionToolsConfigurable.this.myAuxiliaryRightPanel.showError("Name is already in use. Please change name to unique.");
                        }
                        return isValid;
                    }

                    @Override
                    public void cancel() {
                        InspectionToolsConfigurable.this.myProfiles.showComboBoxCard();
                        InspectionToolsConfigurable.this.myAuxiliaryRightPanel.showDescription(InspectionToolsConfigurable.this.getSelectedObject().getDescription());
                    }
                });
            }

            @Override
            public boolean canDelete() {
                return InspectionToolsConfigurable.this.isDeleteEnabled(InspectionToolsConfigurable.this.myProfiles.getProfilesComboBox().getSelectedProfile());
            }

            @Override
            public void delete() {
                InspectionProfileModifiableModel selectedProfile = InspectionToolsConfigurable.this.myProfiles.getProfilesComboBox().getSelectedProfile();
                InspectionToolsConfigurable.this.myProfiles.getProfilesComboBox().removeProfile(selectedProfile);
                InspectionToolsConfigurable.this.myPanels.remove(InspectionToolsConfigurable.this.getProfilePanel(selectedProfile));
                InspectionToolsConfigurable.this.myDeletedProfiles.add(selectedProfile);
                InspectionToolsConfigurable.this.myProfiles.getProfilesComboBox().setSelectedIndex(0);
            }

            @Override
            public boolean canEditDescription() {
                return true;
            }

            @Override
            public void editDescription() {
                InspectionToolsConfigurable.this.myAuxiliaryRightPanel.editDescription(InspectionToolsConfigurable.this.getSelectedObject().getDescription());
            }

            @Override
            public boolean hasDescription() {
                return !StringUtil.isEmpty((String)InspectionToolsConfigurable.this.getSelectedObject().getDescription());
            }

            @Override
            public void export() {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                descriptor.setDescription("Choose directory to store profile file");
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)InspectionToolsConfigurable.this.getProject(), (Component)wholePanel, null, dir -> {
                    try {
                        SingleInspectionProfilePanel panel2 = InspectionToolsConfigurable.this.getSelectedPanel();
                        LOG.assertTrue(panel2 != null);
                        InspectionProfileModifiableModel profile2 = InspectionToolsConfigurable.this.getSelectedObject();
                        LOG.assertTrue(true);
                        Element element = profile2.writeScheme(false);
                        File file2 = new File(FileUtil.toSystemDependentName((String)dir.getPath()), FileUtil.sanitizeFileName((String)profile2.getName()) + ".xml");
                        if (file2.isFile() && Messages.showOkCancelDialog((Component)wholePanel, (String)("File '" + file2 + "' already exist. Do you want to overwrite it?"), (String)"Warning", (Icon)Messages.getQuestionIcon()) != 0) {
                            return;
                        }
                        JDOMUtil.writeParent((Parent)element, (File)file2, (String)"\n");
                    }
                    catch (IOException e1) {
                        LOG.error((Throwable)e1);
                    }
                });
            }

            @Override
            public void doImport() {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile file2) {
                        return file2.getFileType().equals(StdFileTypes.XML);
                    }
                };
                descriptor.setDescription("Choose profile file");
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)InspectionToolsConfigurable.this.getProject(), (Component)wholePanel, null, file2 -> {
                    if (file2 != null) {
                        try {
                            InspectionProfileImpl profile2 = InspectionToolsConfigurable.importInspectionProfile(JDOMUtil.load((InputStream)file2.getInputStream()), InspectionToolsConfigurable.this.myApplicationProfileManager, InspectionToolsConfigurable.this.getProject(), wholePanel);
                            SingleInspectionProfilePanel existed = InspectionToolsConfigurable.this.getProfilePanel(profile2);
                            if (existed != null) {
                                if (Messages.showOkCancelDialog((Component)wholePanel, (String)("Profile with name '" + profile2.getName() + "' already exists. Do you want to overwrite it?"), (String)"Warning", (Icon)Messages.getInformationIcon()) != 0) {
                                    return;
                                }
                                InspectionToolsConfigurable.this.myProfiles.getProfilesComboBox().removeProfile(existed.getProfile());
                                InspectionToolsConfigurable.this.myPanels.remove(existed);
                            }
                            InspectionProfileModifiableModel model = new InspectionProfileModifiableModel(profile2);
                            model.setModified(true);
                            InspectionToolsConfigurable.this.addProfile(model);
                            InspectionToolsConfigurable.this.selectProfile(model);
                        }
                        catch (InvalidDataException | IOException | JDOMException e) {
                            LOG.error(e);
                        }
                    }
                });
            }
        }).build();
        toolbar.setLayout(new GridBagLayout());
        JLabel headerTitleLabel = new JLabel(HEADER_TITLE);
        headerTitleLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)10, (int)0, (int)0, (int)0));
        toolbar.add((Component)headerTitleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        toolbar.add((Component)this.myProfiles, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, (Insets)JBUI.insetsLeft((int)6), 0, 0));
        toolbar.add((Component)InspectionToolsConfigurable.withBorderOnTop(manageButton), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 3, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        toolbar.add((Component)this.myAuxiliaryRightPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 2, (Insets)JBUI.insetsLeft((int)15), 0, 0));
        return wholePanel;
    }

    public static InspectionProfileImpl importInspectionProfile(@NotNull Element rootElement, @NotNull BaseInspectionProfileManager profileManager, @NotNull Project project2, @Nullable JPanel anchorPanel) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "importInspectionProfile"));
        }
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "importInspectionProfile"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "importInspectionProfile"));
        }
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (!unitTestMode) {
            LOG.assertTrue(anchorPanel != null);
        }
        InspectionProfileImpl profile2 = new InspectionProfileImpl("TempProfile", InspectionToolRegistrar.getInstance(), profileManager);
        if (Comparing.strEqual((String)rootElement.getName(), (String)"component")) {
            rootElement = (Element)rootElement.getChildren().get(0);
        }
        HashSet<String> levels = new HashSet<String>();
        for (Element inspectElement : rootElement.getChildren("inspection_tool")) {
            InspectionToolsConfigurable.addLevelIfNotNull(levels, inspectElement);
            for (Element s : inspectElement.getChildren("scope")) {
                InspectionToolsConfigurable.addLevelIfNotNull(levels, s);
            }
        }
        Iterator iterator = levels.iterator();
        while (iterator.hasNext()) {
            String level = (String)iterator.next();
            if (profileManager.getOwnSeverityRegistrar().getSeverity(level) == null) continue;
            iterator.remove();
        }
        if (!levels.isEmpty()) {
            if (!unitTestMode) {
                if (Messages.showYesNoDialog((Component)anchorPanel, (String)("Undefined severities detected: " + StringUtil.join(levels, (String)", ") + ". Do you want to create them?"), (String)"Warning", (Icon)Messages.getWarningIcon()) == 0) {
                    for (String level : levels) {
                        TextAttributes textAttributes = CodeInsightColors.WARNINGS_ATTRIBUTES.getDefaultAttributes();
                        HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(new HighlightSeverity(level, 50), TextAttributesKey.createTextAttributesKey((String)level));
                        profileManager.getOwnSeverityRegistrar().registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
                    }
                }
            } else {
                throw new AssertionError((Object)("All of levels must exist in unit-test mode, but actual not exist levels = " + levels));
            }
        }
        profile2.readExternal(rootElement);
        profile2.setProjectLevel(false);
        profile2.initInspectionTools(project2);
        return profile2;
    }

    private static void addLevelIfNotNull(Set<String> levels, Element inspectElement) {
        String level = inspectElement.getAttributeValue("level");
        if (level != null) {
            levels.add(level);
        }
    }

    protected abstract InspectionProfileImpl getCurrentProfile();

    public boolean isModified() {
        InspectionProfileImpl currentProfile;
        InspectionProfileModifiableModel selectedProfile = this.getSelectedObject();
        if (!Comparing.equal((Object)selectedProfile, (Object)(currentProfile = this.getCurrentProfile()))) {
            return true;
        }
        for (SingleInspectionProfilePanel panel2 : this.myPanels) {
            if (!panel2.isModified()) continue;
            return true;
        }
        return this.getProfiles().size() != this.myPanels.size() || !this.myDeletedProfiles.isEmpty();
    }

    public void apply() {
        for (InspectionProfileModifiableModel profile2 : this.myDeletedProfiles) {
            profile2.getProfileManager().deleteProfile(profile2.getSource());
        }
        this.myDeletedProfiles.clear();
        SingleInspectionProfilePanel selectedPanel = this.getSelectedPanel();
        for (SingleInspectionProfilePanel panel2 : this.myPanels) {
            panel2.apply();
            if (!this.setActiveProfileAsDefaultOnApply() || panel2 != selectedPanel) continue;
            this.applyRootProfile(panel2.getProfile().getName(), panel2.getProfile().isProjectLevel());
        }
    }

    protected abstract void applyRootProfile(@NotNull String var1, boolean var2);

    protected boolean acceptTool(InspectionToolWrapper entry) {
        return true;
    }

    public void reset() {
        this.doReset();
    }

    private void doReset() {
        this.myDeletedProfiles.clear();
        this.disposeUIResources();
        Collection<InspectionProfileImpl> profiles = this.getProfiles();
        ArrayList<InspectionProfileModifiableModel> modifiableProfiles = new ArrayList<InspectionProfileModifiableModel>(profiles.size());
        for (InspectionProfileImpl profile2 : profiles) {
            InspectionProfileModifiableModel inspectionProfile = new InspectionProfileModifiableModel(profile2);
            modifiableProfiles.add(inspectionProfile);
            SingleInspectionProfilePanel panel2 = this.createPanel(inspectionProfile);
            this.myPanels.add(panel2);
            this.myProfilePanelHolder.add(panel2);
        }
        this.myProfiles.getProfilesComboBox().reset(modifiableProfiles);
        this.myAuxiliaryRightPanel.showDescription(this.getSelectedObject().getDescription());
        InspectionProfileImpl inspectionProfile = this.getCurrentProfile();
        this.myProfiles.getProfilesComboBox().selectProfile(inspectionProfile);
        this.showProfile(inspectionProfile);
        SingleInspectionProfilePanel panel3 = this.getSelectedPanel();
        if (panel3 != null) {
            panel3.setVisible(true);
            this.mySelectionAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            this.mySelectionAlarm.cancelAllRequests();
            this.mySelectionAlarm.addRequest(panel3::updateSelection, 200);
        }
    }

    private SingleInspectionProfilePanel createPanel(InspectionProfileModifiableModel profile2) {
        return new SingleInspectionProfilePanel(this.myProjectProfileManager, profile2){

            @Override
            protected boolean accept(InspectionToolWrapper entry) {
                return super.accept(entry) && InspectionToolsConfigurable.this.acceptTool(entry);
            }
        };
    }

    private boolean isDeleteEnabled(@NotNull InspectionProfileImpl inspectionProfile) {
        boolean isProjectProfile;
        InspectionProfileImpl profile2;
        if (inspectionProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "isDeleteEnabled"));
        }
        boolean projectProfileFound = false;
        boolean ideProfileFound = false;
        Iterator<InspectionProfileModifiableModel> iterator = this.myProfiles.getProfilesComboBox().getProfiles().iterator();
        while (!(!iterator.hasNext() || inspectionProfile != (profile2 = (InspectionProfileImpl)iterator.next()) && (ideProfileFound |= !(isProjectProfile = profile2.getProfileManager() == this.myProjectProfileManager)) && (projectProfileFound |= isProjectProfile))) {
        }
        return inspectionProfile.getProfileManager() == this.myProjectProfileManager ? projectProfileFound : ideProfileFound;
    }

    protected Collection<InspectionProfileImpl> getProfiles() {
        ArrayList<InspectionProfileImpl> result2 = new ArrayList<InspectionProfileImpl>();
        result2.addAll(new TreeSet<InspectionProfileImpl>(this.myApplicationProfileManager.getProfiles()));
        result2.addAll(this.myProjectProfileManager.getProfiles());
        return result2;
    }

    public void disposeUIResources() {
        for (SingleInspectionProfilePanel panel2 : this.myPanels) {
            panel2.disposeUI();
        }
        this.myPanels.clear();
        if (this.mySelectionAlarm != null) {
            Disposer.dispose((Disposable)this.mySelectionAlarm);
            this.mySelectionAlarm = null;
        }
    }

    @Override
    public void selectProfile(InspectionProfileImpl profile2) {
        this.myProfiles.getProfilesComboBox().selectProfile(profile2);
    }

    private SingleInspectionProfilePanel getProfilePanel(InspectionProfileImpl profile2) {
        for (SingleInspectionProfilePanel panel2 : this.myPanels) {
            if (!panel2.getProfile().equals(profile2)) continue;
            return panel2;
        }
        return null;
    }

    @Override
    public void selectInspectionTool(String selectedToolShortName) {
        InspectionProfileModifiableModel inspectionProfile = this.getSelectedObject();
        SingleInspectionProfilePanel panel2 = this.getProfilePanel(inspectionProfile);
        LOG.assertTrue(panel2 != null, (Object)("No settings panel for: " + inspectionProfile + "; " + this.configuredProfiles()));
        panel2.selectInspectionTool(selectedToolShortName);
    }

    @Override
    public void selectInspectionGroup(String[] groupPath) {
        this.getProfilePanel(this.getSelectedObject()).selectInspectionGroup(groupPath);
    }

    protected SingleInspectionProfilePanel getSelectedPanel() {
        InspectionProfileModifiableModel inspectionProfile = this.getSelectedObject();
        return this.getProfilePanel(inspectionProfile);
    }

    private String configuredProfiles() {
        return "configured profiles: " + StringUtil.join((Collection)this.myPanels.stream().map(p -> p.getProfile().getName()).collect(Collectors.toList()), (String)", ");
    }

    private boolean hasName(@NotNull String name, boolean shared) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "hasName"));
        }
        for (SingleInspectionProfilePanel p : this.myPanels) {
            if (!name.equals(p.getProfile().getName()) || shared != p.getProfile().isProjectLevel()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public InspectionProfileModifiableModel getSelectedObject() {
        InspectionProfileModifiableModel inspectionProfileModifiableModel = this.myProfiles.getProfilesComboBox().getSelectedProfile();
        if (inspectionProfileModifiableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "getSelectedObject"));
        }
        return inspectionProfileModifiableModel;
    }

    public JComponent getPreferredFocusedComponent() {
        SingleInspectionProfilePanel panel2 = this.getSelectedPanel();
        return panel2 == null ? null : panel2.getPreferredFocusedComponent();
    }

    private void showProfile(InspectionProfileImpl profile2) {
        SingleInspectionProfilePanel panel2 = this.getProfilePanel(profile2);
        for (Component component : this.myProfilePanelHolder.getComponents()) {
            component.setVisible(component == panel2);
        }
    }
}

