/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.NewInspectionProfile;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class ProfilesComboBox<T extends InspectionProfileImpl>
extends ComboBox<T> {
    private static final String PROJECT_LEVEL_SEPARATOR_TEXT = "Project Level";
    private static final String GLOBAL_LEVEL_SEPARATOR_TEXT = "Global Level";
    private SortedComboBoxModel<T> myComboModel = new SortedComboBoxModel(Comparator.comparing(NewInspectionProfile::isProjectLevel).reversed().thenComparing(InspectionProfileImpl::getDisplayName));
    private T myFirstGlobalProfile;

    public ProfilesComboBox() {
        this.setModel((ComboBoxModel)this.myComboModel);
        this.setRenderer(new ListCellRenderer<InspectionProfileImpl>(){
            ListCellRendererWrapper<InspectionProfileImpl> baseRenderer = new ListCellRendererWrapper<InspectionProfileImpl>(){

                public void customize(JList list, InspectionProfileImpl value, int index, boolean selected, boolean hasFocus) {
                    if (index == -1) {
                        this.setIcon(value.isProjectLevel() ? AllIcons.General.ProjectSettings : AllIcons.General.Settings);
                    }
                    this.setText(value.getDisplayName());
                }
            };

            @Override
            public Component getListCellRendererComponent(JList list, InspectionProfileImpl o, int index, boolean isSelected, boolean cellHasFocus) {
                TitledSeparator separator = null;
                if (index != -1) {
                    if (!o.isProjectLevel()) {
                        if (o == ProfilesComboBox.this.myFirstGlobalProfile) {
                            separator = new TitledSeparator(ProfilesComboBox.GLOBAL_LEVEL_SEPARATOR_TEXT);
                        }
                    } else if (o == ProfilesComboBox.this.myComboModel.get(0)) {
                        separator = new TitledSeparator(ProfilesComboBox.PROJECT_LEVEL_SEPARATOR_TEXT);
                    }
                }
                Component renderedComponent = this.baseRenderer.getListCellRendererComponent(list, (Object)o, index, isSelected, cellHasFocus);
                if (separator == null) {
                    return renderedComponent;
                }
                UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)separator.getLabel());
                separator.getLabel().setIcon(separator.getText().equals(ProfilesComboBox.PROJECT_LEVEL_SEPARATOR_TEXT) ? AllIcons.General.ProjectSettings : AllIcons.General.Settings);
                separator.setBackground(renderedComponent.getBackground());
                separator.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)0, (int)2));
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                p.add((Component)separator, "North");
                p.add(renderedComponent, "Center");
                p.setBackground(renderedComponent.getBackground());
                return p;
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object profile2 = ProfilesComboBox.this.getSelectedProfile();
                if (profile2 != null) {
                    ProfilesComboBox.this.onProfileChosen((InspectionProfileImpl)profile2);
                }
            }
        });
    }

    protected abstract void onProfileChosen(InspectionProfileImpl var1);

    public void selectProfile(InspectionProfileImpl inspectionProfile) {
        this.setSelectedItem(inspectionProfile);
    }

    public void reset(Collection<T> profiles) {
        this.myComboModel.clear();
        for (InspectionProfileImpl profile2 : profiles) {
            this.myComboModel.add((Object)profile2);
        }
        this.findFirstGlobalProfile();
        this.setSelectedIndex(0);
        this.resort();
    }

    void removeProfile(T profile2) {
        this.myComboModel.remove(profile2);
        if (!((NewInspectionProfile)profile2).isProjectLevel() && profile2 == this.myFirstGlobalProfile) {
            this.findFirstGlobalProfile();
        }
    }

    public void addProfile(T inspectionProfile) {
        this.myComboModel.add(inspectionProfile);
        if (!((NewInspectionProfile)inspectionProfile).isProjectLevel()) {
            this.findFirstGlobalProfile();
        }
    }

    T getSelectedProfile() {
        return (T)((InspectionProfileImpl)this.myComboModel.getSelectedItem());
    }

    @NotNull
    List<T> getProfiles() {
        List list = this.myComboModel.getItems();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/header/ProfilesComboBox", "getProfiles"));
        }
        return list;
    }

    private void findFirstGlobalProfile() {
        this.myFirstGlobalProfile = null;
        for (InspectionProfileImpl profile2 : this.getProfiles()) {
            if (profile2.isProjectLevel()) continue;
            this.myFirstGlobalProfile = profile2;
            break;
        }
    }

    public void resort() {
        this.myComboModel.setAll((Collection)this.myComboModel.getItems());
        this.findFirstGlobalProfile();
    }
}

