/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionsConfigTreeRenderer
extends ColoredTreeCellRenderer {
    protected abstract String getFilter();

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String text;
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeRenderer", "customizeCellRenderer"));
        }
        if (!(value instanceof InspectionConfigTreeNode)) {
            return;
        }
        InspectionConfigTreeNode node = (InspectionConfigTreeNode)value;
        Object object = node.getUserObject();
        Color foreground = selected ? UIUtil.getTreeSelectionForeground() : (node.isProperSetting() ? PlatformColors.BLUE : UIUtil.getTreeTextForeground());
        int style = 0;
        String hint = null;
        if (object instanceof String) {
            text = (String)object;
            style = 1;
        } else {
            ToolDescriptors descriptors = node.getDescriptors();
            assert (descriptors != null);
            Descriptor defaultDescriptor = descriptors.getDefaultDescriptor();
            text = defaultDescriptor.getText();
            hint = InspectionsConfigTreeRenderer.getHint(defaultDescriptor);
        }
        if (text != null) {
            SearchUtil.appendFragments(this.getFilter(), text, style, foreground, this.getBackground(), (SimpleColoredComponent)this);
        }
        if (hint != null) {
            this.append(" " + hint, selected ? new SimpleTextAttributes(0, foreground) : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        this.setForeground(foreground);
    }

    @Nullable
    private static String getHint(Descriptor descriptor) {
        InspectionToolWrapper toolWrapper = descriptor.getToolWrapper();
        if (toolWrapper instanceof LocalInspectionToolWrapper || toolWrapper instanceof GlobalInspectionToolWrapper && !((GlobalInspectionToolWrapper)toolWrapper).worksInBatchModeOnly()) {
            return null;
        }
        return InspectionsBundle.message((String)"inspection.tool.availability.in.tree.node1", (Object[])new Object[0]);
    }
}

