/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DetectAndAdjustIndentOptionsTask;
import com.intellij.psi.codeStyle.EditorNotificationInfo;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.TimeStampedIndentOptions;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectableIndentOptionsProvider
extends FileIndentOptionsProvider {
    private static final ExecutorService BOUNDED_EXECUTOR = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"DetectableIndentOptionsProvider pool");
    private boolean myIsEnabledInTest;
    private final List<VirtualFile> myAcceptedFiles = new WeakList();
    private final List<VirtualFile> myDisabledFiles = new WeakList();

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile file2) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "getIndentOptions"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "getIndentOptions"));
        }
        if (!this.isEnabled(settings, file2)) {
            return null;
        }
        Project project2 = file2.getProject();
        PsiDocumentManager psiManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = psiManager.getDocument(file2);
        if (document == null) {
            return null;
        }
        CommonCodeStyleSettings.IndentOptions options = this.getValidCachedIndentOptions(file2, document);
        if (options != null) {
            return options;
        }
        TimeStampedIndentOptions indentOptions = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(file2, document);
        indentOptions.associateWithDocument(document);
        DetectAndAdjustIndentOptionsTask task = new DetectAndAdjustIndentOptionsTask(project2, document, indentOptions, BOUNDED_EXECUTOR);
        task.scheduleInBackgroundForCommittedDocument();
        return indentOptions;
    }

    public boolean useOnFullReformat() {
        return false;
    }

    public void setEnabledInTest(boolean isEnabledInTest) {
        this.myIsEnabledInTest = isEnabledInTest;
    }

    private boolean isEnabled(@NotNull CodeStyleSettings settings, @NotNull PsiFile file2) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "isEnabled"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "isEnabled"));
        }
        if (file2 instanceof PsiCompiledFile || file2.getFileType() == ScratchFileType.INSTANCE) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myIsEnabledInTest;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null || vFile instanceof LightVirtualFile || this.myDisabledFiles.contains(vFile)) {
            return false;
        }
        return LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null && settings.AUTODETECT_INDENTS;
    }

    @Nullable
    public static DetectableIndentOptionsProvider getInstance() {
        return (DetectableIndentOptionsProvider)((Object)FileIndentOptionsProvider.EP_NAME.findExtension(DetectableIndentOptionsProvider.class));
    }

    @Nullable
    public EditorNotificationInfo getNotificationInfo(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull CommonCodeStyleSettings.IndentOptions userOptions, @NotNull CommonCodeStyleSettings.IndentOptions detectedOptions) {
        Editor editor;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "getNotificationInfo"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "getNotificationInfo"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "getNotificationInfo"));
        }
        if (userOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userOptions", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "getNotificationInfo"));
        }
        if (detectedOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detectedOptions", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "getNotificationInfo"));
        }
        final NotificationLabels labels = DetectableIndentOptionsProvider.getNotificationLabels(userOptions, detectedOptions);
        Editor editor2 = editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        if (labels == null || editor == null) {
            return null;
        }
        EditorNotificationInfo.ActionLabelData okAction = new EditorNotificationInfo.ActionLabelData(ApplicationBundle.message((String)"code.style.indents.detector.accept", (Object[])new Object[0]), () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "lambda$getNotificationInfo$0"));
            }
            this.setAccepted(file2);
        });
        EditorNotificationInfo.ActionLabelData disableForSingleFile = new EditorNotificationInfo.ActionLabelData(labels.revertToOldSettingsLabel, () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "lambda$getNotificationInfo$1"));
            }
            this.disableForFile(file2);
            if (editor instanceof EditorEx) {
                ((EditorEx)editor).reinitSettings();
            }
        });
        EditorNotificationInfo.ActionLabelData showSettings = new EditorNotificationInfo.ActionLabelData(ApplicationBundle.message((String)"code.style.indents.detector.show.settings", (Object[])new Object[0]), () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "lambda$getNotificationInfo$2"));
            }
            ShowSettingsUtilImpl.showSettingsDialog(project2, "preferences.sourceCode", "detect indent");
        });
        final ArrayList actions = ContainerUtil.newArrayList((Object[])new EditorNotificationInfo.ActionLabelData[]{okAction, disableForSingleFile, showSettings});
        return new EditorNotificationInfo(){

            @NotNull
            public List<EditorNotificationInfo.ActionLabelData> getLabelAndActions() {
                List list = actions;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$1", "getLabelAndActions"));
                }
                return list;
            }

            @NotNull
            public String getTitle() {
                String string = labels.title;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$1", "getTitle"));
                }
                return string;
            }
        };
    }

    @Nullable
    private static NotificationLabels getNotificationLabels(@NotNull CommonCodeStyleSettings.IndentOptions userOptions, @NotNull CommonCodeStyleSettings.IndentOptions detectedOptions) {
        if (userOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userOptions", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "getNotificationLabels"));
        }
        if (detectedOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detectedOptions", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "getNotificationLabels"));
        }
        if (userOptions.USE_TAB_CHARACTER) {
            if (!detectedOptions.USE_TAB_CHARACTER) {
                return new NotificationLabels(ApplicationBundle.message((String)"code.style.space.indent.detected", (Object[])new Object[]{detectedOptions.INDENT_SIZE}), ApplicationBundle.message((String)"code.style.detector.use.tabs", (Object[])new Object[0]));
            }
        } else {
            String restoreToSpaces = ApplicationBundle.message((String)"code.style.detector.use.spaces", (Object[])new Object[]{userOptions.INDENT_SIZE});
            if (detectedOptions.USE_TAB_CHARACTER) {
                return new NotificationLabels(ApplicationBundle.message((String)"code.style.tab.usage.detected", (Object[])new Object[]{userOptions.INDENT_SIZE}), restoreToSpaces);
            }
            if (userOptions.INDENT_SIZE != detectedOptions.INDENT_SIZE) {
                return new NotificationLabels(ApplicationBundle.message((String)"code.style.different.indent.size.detected", (Object[])new Object[]{detectedOptions.INDENT_SIZE, userOptions.INDENT_SIZE}), restoreToSpaces);
            }
        }
        return null;
    }

    private void disableForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "disableForFile"));
        }
        this.myDisabledFiles.add(file2);
    }

    public void setAccepted(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "setAccepted"));
        }
        this.myAcceptedFiles.add(file2);
    }

    public boolean isAcceptedWithoutWarning(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider", "isAcceptedWithoutWarning"));
        }
        return !FileIndentOptionsProvider.isShowNotification() || this.myAcceptedFiles.contains(file2);
    }

    public CommonCodeStyleSettings.IndentOptions getValidCachedIndentOptions(PsiFile file2, Document document) {
        TimeStampedIndentOptions defaultIndentOptions;
        TimeStampedIndentOptions cachedInDocument;
        CommonCodeStyleSettings.IndentOptions options = CommonCodeStyleSettings.IndentOptions.retrieveFromAssociatedDocument((PsiFile)file2);
        if (options instanceof TimeStampedIndentOptions && !(cachedInDocument = (TimeStampedIndentOptions)options).isOutdated(document, defaultIndentOptions = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(file2, document))) {
            return cachedInDocument;
        }
        return null;
    }

    private static class NotificationLabels {
        public final String title;
        public final String revertToOldSettingsLabel;

        public NotificationLabels(@NotNull String title, @NotNull String revertToOldSettingsLabel) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$NotificationLabels", "<init>"));
            }
            if (revertToOldSettingsLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revertToOldSettingsLabel", "com/intellij/psi/codeStyle/DetectableIndentOptionsProvider$NotificationLabels", "<init>"));
            }
            this.title = title;
            this.revertToOldSettingsLabel = revertToOldSettingsLabel;
        }
    }
}

