/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.DebugUtil");
    public static boolean CHECK = false;
    public static final boolean DO_EXPENSIVE_CHECKS;
    public static final boolean CHECK_INSIDE_ATOMIC_ACTION_ENABLED;
    private static final ThreadLocal<Object> ourPsiModificationTrace;
    private static final ThreadLocal<Integer> ourPsiModificationDepth;
    private static final Set<Integer> ourNonTransactedTraces;

    public static String psiTreeToString(@NotNull PsiElement element, boolean skipWhitespaces) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/DebugUtil", "psiTreeToString"));
        }
        ASTNode node = SourceTreeToPsiMap.psiElementToTree(element);
        assert (node != null) : element;
        return DebugUtil.treeToString(node, skipWhitespaces);
    }

    public static String treeToString(@NotNull ASTNode root, boolean skipWhitespaces) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/DebugUtil", "treeToString"));
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBuffer(ruler, root, 0, skipWhitespaces, false, false, true);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, false, false, true);
        return buffer.toString();
    }

    public static String nodeTreeToString(@NotNull ASTNode root, boolean skipWhitespaces) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/DebugUtil", "nodeTreeToString"));
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBuffer(ruler, root, 0, skipWhitespaces, false, false, false);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, false, false, false);
        return buffer.toString();
    }

    public static String treeToString(@NotNull ASTNode root, boolean skipWhitespaces, boolean showRanges) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/DebugUtil", "treeToString"));
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBuffer(ruler, root, 0, skipWhitespaces, showRanges, false, true);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, showRanges, false, true);
        return buffer.toString();
    }

    public static String treeToStringWithUserData(TreeElement root, boolean skipWhitespaces) {
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBufferWithUserData((Appendable)ruler, root, 0, skipWhitespaces);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBufferWithUserData((Appendable)buffer, root, 0, skipWhitespaces);
        return buffer.toString();
    }

    public static String treeToStringWithUserData(PsiElement root, boolean skipWhitespaces) {
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBufferWithUserData((Appendable)ruler, root, 0, skipWhitespaces);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBufferWithUserData((Appendable)buffer, root, 0, skipWhitespaces);
        return buffer.toString();
    }

    public static void treeToBuffer(@NotNull Appendable buffer, @NotNull ASTNode root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/DebugUtil", "treeToBuffer"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/DebugUtil", "treeToBuffer"));
        }
        DebugUtil.treeToBuffer(buffer, root, indent, skipWhiteSpaces, showRanges, showChildrenRanges, usePsi, null);
    }

    public static void treeToBuffer(final @NotNull Appendable buffer, @NotNull ASTNode root, final int indent, final boolean skipWhiteSpaces, boolean showRanges, final boolean showChildrenRanges, final boolean usePsi, @Nullable PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/DebugUtil", "treeToBuffer"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/DebugUtil", "treeToBuffer"));
        }
        if (skipWhiteSpaces && root.getElementType() == TokenType.WHITE_SPACE) {
            return;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            PsiElement psiElement = null;
            if (root instanceof CompositeElement) {
                if (usePsi) {
                    psiElement = root.getPsi();
                    if (psiElement != null) {
                        buffer.append(psiElement.toString());
                    } else {
                        buffer.append(root.getElementType().toString());
                    }
                } else {
                    buffer.append(root.toString());
                }
            } else {
                String text = DebugUtil.fixWhiteSpaces(root.getText());
                buffer.append(root.toString()).append("('").append(text).append("')");
            }
            if (showRanges) {
                buffer.append(root.getTextRange().toString());
            }
            buffer.append("\n");
            if (root instanceof CompositeElement) {
                ASTNode child = root.getFirstChildNode();
                if (child == null) {
                    StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(indent + 2));
                    buffer.append("<empty list>\n");
                } else {
                    while (child != null) {
                        DebugUtil.treeToBuffer(buffer, child, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, usePsi, extra);
                        child = child.getTreeNext();
                    }
                }
            }
            if (psiElement != null && extra != null) {
                extra.consume((Object)psiElement, (Object)new Consumer<PsiElement>(){

                    public void consume(PsiElement element) {
                        DebugUtil.treeToBuffer(buffer, element.getNode(), indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, usePsi, null);
                    }
                });
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static String lightTreeToString(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, boolean skipWhitespaces) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/DebugUtil", "lightTreeToString"));
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.lightTreeToBuffer(tree, (LighterASTNode)tree.getRoot(), ruler, 0, skipWhitespaces);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.lightTreeToBuffer(tree, (LighterASTNode)tree.getRoot(), buffer, 0, skipWhitespaces);
        return buffer.toString();
    }

    public static void lightTreeToBuffer(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode node, @NotNull Appendable buffer, int indent, boolean skipWhiteSpaces) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/DebugUtil", "lightTreeToBuffer"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/DebugUtil", "lightTreeToBuffer"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/DebugUtil", "lightTreeToBuffer"));
        }
        IElementType tokenType = node.getTokenType();
        if (skipWhiteSpaces && tokenType == TokenType.WHITE_SPACE) {
            return;
        }
        boolean isLeaf = node instanceof LighterASTTokenNode;
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            if (tokenType == TokenType.ERROR_ELEMENT) {
                buffer.append("PsiErrorElement:").append(PsiBuilderImpl.getErrorMessage(node));
            } else if (tokenType == TokenType.WHITE_SPACE) {
                buffer.append("PsiWhiteSpace");
            } else {
                buffer.append(isLeaf ? "PsiElement" : "Element").append('(').append(tokenType.toString()).append(')');
            }
            if (isLeaf) {
                String text = ((LighterASTTokenNode)node).getText().toString();
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text)).append("')");
            }
            buffer.append('\n');
            if (!isLeaf) {
                Ref kids = new Ref();
                int numKids = tree.getChildren(tree.prepareForGetChildren((Object)node), kids);
                if (numKids == 0) {
                    StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(indent + 2));
                    buffer.append("<empty list>\n");
                } else {
                    for (int i2 = 0; i2 < numKids; ++i2) {
                        DebugUtil.lightTreeToBuffer(tree, ((LighterASTNode[])kids.get())[i2], buffer, indent + 2, skipWhiteSpaces);
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static String stubTreeToString(Stub root) {
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.stubTreeToBuffer(root, ruler, 0);
        StringBuilder builder = new StringBuilder(ruler.getLength());
        DebugUtil.stubTreeToBuffer(root, builder, 0);
        return builder.toString();
    }

    public static void stubTreeToBuffer(Stub node, Appendable buffer, int indent) {
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            ObjectStubSerializer stubType = node.getStubType();
            if (stubType != null) {
                buffer.append(stubType.toString()).append(':');
            }
            buffer.append(node.toString()).append('\n');
            List children2 = node.getChildrenStubs();
            for (Stub child : children2) {
                DebugUtil.stubTreeToBuffer(child, buffer, indent + 2);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void treeToBufferWithUserData(Appendable buffer, TreeElement root, int indent, boolean skipWhiteSpaces) {
        if (skipWhiteSpaces && root.getElementType() == TokenType.WHITE_SPACE) {
            return;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            PsiElement psi = SourceTreeToPsiMap.treeElementToPsi(root);
            assert (psi != null) : root;
            if (root instanceof CompositeElement) {
                buffer.append(psi.toString());
            } else {
                String text = DebugUtil.fixWhiteSpaces(root.getText());
                buffer.append(root.toString()).append("('").append(text).append("')");
            }
            buffer.append(root.getUserDataString());
            buffer.append("\n");
            if (root instanceof CompositeElement) {
                PsiElement[] children2;
                for (PsiElement child : children2 = psi.getChildren()) {
                    DebugUtil.treeToBufferWithUserData(buffer, (TreeElement)SourceTreeToPsiMap.psiElementToTree(child), indent + 2, skipWhiteSpaces);
                }
                if (children2.length == 0) {
                    StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(indent + 2));
                    buffer.append("<empty list>\n");
                }
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void treeToBufferWithUserData(Appendable buffer, PsiElement root, int indent, boolean skipWhiteSpaces) {
        if (skipWhiteSpaces && root instanceof PsiWhiteSpace) {
            return;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            PsiElement[] children2;
            if (root instanceof CompositeElement) {
                buffer.append(root.toString());
            } else {
                String text = DebugUtil.fixWhiteSpaces(root.getText());
                buffer.append(root.toString()).append("('").append(text).append("')");
            }
            buffer.append(((UserDataHolderBase)root).getUserDataString());
            buffer.append("\n");
            for (PsiElement child : children2 = root.getChildren()) {
                DebugUtil.treeToBufferWithUserData(buffer, child, indent + 2, skipWhiteSpaces);
            }
            if (children2.length == 0) {
                StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(indent + 2));
                buffer.append("<empty list>\n");
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void doCheckTreeStructure(@Nullable ASTNode anyElement) {
        if (anyElement == null) {
            return;
        }
        ASTNode root = anyElement;
        while (root.getTreeParent() != null) {
            root = root.getTreeParent();
        }
        if (root instanceof CompositeElement) {
            DebugUtil.checkSubtree((CompositeElement)root);
        }
    }

    private static void checkSubtree(CompositeElement root) {
        if (root.rawFirstChild() == null) {
            if (root.rawLastChild() != null) {
                throw new IncorrectTreeStructureException(root, "firstChild == null, but lastChild != null");
            }
        } else {
            for (TreeElement child = root.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child instanceof CompositeElement) {
                    DebugUtil.checkSubtree((CompositeElement)child);
                }
                if (child.getTreeParent() != root) {
                    throw new IncorrectTreeStructureException(child, "child has wrong parent value");
                }
                if (child == root.getFirstChildNode()) {
                    if (child.getTreePrev() != null) {
                        throw new IncorrectTreeStructureException(root, "firstChild.prev != null");
                    }
                } else {
                    if (child.getTreePrev() == null) {
                        throw new IncorrectTreeStructureException(child, "not first child has prev == null");
                    }
                    if (child.getTreePrev().getTreeNext() != child) {
                        throw new IncorrectTreeStructureException(child, "element.prev.next != element");
                    }
                }
                if (child.getTreeNext() != null || root.getLastChildNode() == child) continue;
                throw new IncorrectTreeStructureException(child, "not last child has next == null");
            }
        }
    }

    public static void checkParentChildConsistent(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/DebugUtil", "checkParentChildConsistent"));
        }
        ASTNode treeParent = element.getTreeParent();
        if (treeParent == null) {
            return;
        }
        Object[] elements = treeParent.getChildren(null);
        if (ArrayUtil.find((Object[])elements, (Object)element) == -1) {
            throw new IncorrectTreeStructureException(element, "child cannot be found among parents children");
        }
    }

    public static void checkSameCharTabs(@NotNull ASTNode element1, @NotNull ASTNode element2) {
        CharTable toCharTab;
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/psi/impl/DebugUtil", "checkSameCharTabs"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/psi/impl/DebugUtil", "checkSameCharTabs"));
        }
        CharTable fromCharTab = SharedImplUtil.findCharTableByTree(element1);
        LOG.assertTrue(fromCharTab == (toCharTab = SharedImplUtil.findCharTableByTree(element2)));
    }

    public static String psiToString(@NotNull PsiElement element, boolean skipWhitespaces) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/DebugUtil", "psiToString"));
        }
        return DebugUtil.psiToString(element, skipWhitespaces, false);
    }

    public static String psiToString(@NotNull PsiElement root, boolean skipWhiteSpaces, boolean showRanges) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/DebugUtil", "psiToString"));
        }
        return DebugUtil.psiToString(root, skipWhiteSpaces, showRanges, null);
    }

    public static String psiToString(@NotNull PsiElement root, boolean skipWhiteSpaces, boolean showRanges, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/DebugUtil", "psiToString"));
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.psiToBuffer(ruler, root, skipWhiteSpaces, showRanges, extra);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.psiToBuffer(buffer, root, skipWhiteSpaces, showRanges, extra);
        return buffer.toString();
    }

    private static void psiToBuffer(Appendable buffer, PsiElement root, boolean skipWhiteSpaces, boolean showRanges, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        ASTNode node = root.getNode();
        if (node == null) {
            DebugUtil.psiToBuffer(buffer, root, 0, skipWhiteSpaces, showRanges, showRanges, extra);
        } else {
            DebugUtil.treeToBuffer(buffer, node, 0, skipWhiteSpaces, showRanges, showRanges, true, extra);
        }
    }

    public static void psiToBuffer(@NotNull Appendable buffer, @NotNull PsiElement root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/DebugUtil", "psiToBuffer"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/DebugUtil", "psiToBuffer"));
        }
        DebugUtil.psiToBuffer(buffer, root, indent, skipWhiteSpaces, showRanges, showChildrenRanges, null);
    }

    public static void psiToBuffer(final @NotNull Appendable buffer, @NotNull PsiElement root, final int indent, final boolean skipWhiteSpaces, boolean showRanges, final boolean showChildrenRanges, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/DebugUtil", "psiToBuffer"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/DebugUtil", "psiToBuffer"));
        }
        if (skipWhiteSpaces && root instanceof PsiWhiteSpace) {
            return;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            buffer.append(root.toString());
            PsiElement child = root.getFirstChild();
            if (child == null) {
                String text = root.getText();
                assert (text != null) : "text is null for <" + root + ">";
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text)).append("')");
            }
            if (showRanges) {
                buffer.append(root.getTextRange().toString());
            }
            buffer.append("\n");
            while (child != null) {
                DebugUtil.psiToBuffer(buffer, child, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, extra);
                child = child.getNextSibling();
            }
            if (extra != null) {
                extra.consume((Object)root, (Object)new Consumer<PsiElement>(){

                    public void consume(PsiElement element) {
                        DebugUtil.psiToBuffer(buffer, element, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, null);
                    }
                });
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static String fixWhiteSpaces(String text) {
        text = StringUtil.replace((String)text, (String)"\n", (String)"\\n");
        text = StringUtil.replace((String)text, (String)"\r", (String)"\\r");
        text = StringUtil.replace((String)text, (String)"\t", (String)"\\t");
        return text;
    }

    public static String currentStackTrace() {
        return ExceptionUtil.currentStackTrace();
    }

    public static void startPsiModification(@Nullable String trace) {
        Integer depth;
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return;
        }
        if (ourPsiModificationTrace.get() == null) {
            ourPsiModificationTrace.set(trace != null ? trace : new Throwable());
        }
        if ((depth = ourPsiModificationDepth.get()) == null) {
            depth = 0;
        }
        ourPsiModificationDepth.set(depth + 1);
    }

    public static void finishPsiModification() {
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return;
        }
        Integer depth = ourPsiModificationDepth.get();
        if (depth == null) {
            LOG.warn("Unmatched PSI modification end", new Throwable());
            depth = 0;
        } else {
            Integer n = depth;
            Integer n2 = depth = Integer.valueOf(depth - 1);
            ourPsiModificationDepth.set(depth);
        }
        if (depth == 0) {
            ourPsiModificationTrace.set(null);
        }
    }

    public static void onInvalidated(@NotNull ASTNode treeElement) {
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/psi/impl/DebugUtil", "onInvalidated"));
        }
        Object trace = DebugUtil.calcInvalidationTrace(treeElement);
        if (trace != null) {
            PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)treeElement, (Object)trace);
        }
    }

    public static void onInvalidated(@NotNull PsiElement o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/psi/impl/DebugUtil", "onInvalidated"));
        }
        Object trace = PsiInvalidElementAccessException.getInvalidationTrace((UserDataHolder)o);
        if (trace != null) {
            return;
        }
        PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)o, (Object)DebugUtil.currentInvalidationTrace());
    }

    public static void onInvalidated(@NotNull FileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/DebugUtil", "onInvalidated"));
        }
        Object trace = DebugUtil.calcInvalidationTrace(null);
        if (trace != null) {
            PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)provider, (Object)trace);
        }
    }

    @Nullable
    private static Object calcInvalidationTrace(@Nullable ASTNode treeElement) {
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return null;
        }
        if (PsiInvalidElementAccessException.findInvalidationTrace((ASTNode)treeElement) != null) {
            return null;
        }
        return DebugUtil.currentInvalidationTrace();
    }

    @NotNull
    private static Object currentInvalidationTrace() {
        Object trace = ourPsiModificationTrace.get();
        if (trace == null && ourNonTransactedTraces.add(ExceptionUtil.getThrowableText((Throwable)((Throwable)(trace = new Throwable()))).hashCode())) {
            LOG.info("PSI invalidated outside transaction", (Throwable)trace);
        }
        Object object = trace;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DebugUtil", "currentInvalidationTrace"));
        }
        return object;
    }

    public static void revalidateNode(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/DebugUtil", "revalidateNode"));
        }
        PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)element, null);
    }

    public static void sleep(long millis) {
        TimeoutUtil.sleep((long)millis);
    }

    public static void checkTreeStructure(ASTNode element) {
        if (CHECK) {
            DebugUtil.doCheckTreeStructure(element);
        }
    }

    @NotNull
    public static String diagnosePsiDocumentInconsistency(@NotNull PsiElement element, @NotNull Document document) {
        int docLength;
        FileViewProvider actualViewProvider;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
        }
        PsiUtilCore.ensureValid((PsiElement)element);
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            String string = "no file for " + element + " of " + element.getClass();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
            }
            return string;
        }
        PsiUtilCore.ensureValid((PsiElement)file2);
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file2.getProject());
        Document actualDocument = manager.getDocument(file2);
        String fileDiagnostics = "File[" + file2 + " " + file2.getName() + ", " + file2.getLanguage() + ", " + viewProvider + "]";
        if (actualDocument != document) {
            String string = "wrong document for " + fileDiagnostics + "; expected " + document + "; actual " + actualDocument;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
            }
            return string;
        }
        PsiFile cachedPsiFile = manager.getCachedPsiFile(document);
        FileViewProvider fileViewProvider = actualViewProvider = cachedPsiFile == null ? null : cachedPsiFile.getViewProvider();
        if (actualViewProvider != viewProvider) {
            String string = "wrong view provider for " + document + ", expected " + viewProvider + "; actual " + actualViewProvider;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
            }
            return string;
        }
        if (!manager.isCommitted(document)) {
            String string = "not committed document " + document + ", " + fileDiagnostics;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
            }
            return string;
        }
        int fileLength = file2.getTextLength();
        if (fileLength != (docLength = document.getTextLength())) {
            String string = "file/doc text length different, " + fileDiagnostics + " file.length=" + fileLength + "; doc.length=" + docLength;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
            }
            return string;
        }
        String string = "unknown inconsistency in " + fileDiagnostics;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
        }
        return string;
    }

    static {
        Application application = ApplicationManager.getApplication();
        CHECK_INSIDE_ATOMIC_ACTION_ENABLED = DO_EXPENSIVE_CHECKS = application != null && application.isUnitTestMode();
        ourPsiModificationTrace = new ThreadLocal();
        ourPsiModificationDepth = new ThreadLocal();
        ourNonTransactedTraces = ContainerUtil.newConcurrentSet();
    }

    public static class IncorrectTreeStructureException
    extends RuntimeException {
        private final ASTNode myElement;

        public IncorrectTreeStructureException(ASTNode element, String message) {
            super(message);
            this.myElement = element;
        }

        public ASTNode getElement() {
            return this.myElement;
        }
    }

    public static class LengthBuilder
    implements Appendable {
        private int myLength = 0;

        public int getLength() {
            return this.myLength;
        }

        @Override
        public Appendable append(CharSequence csq) {
            this.myLength += csq.length();
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) {
            this.myLength += csq.subSequence(start, end).length();
            return this;
        }

        @Override
        public Appendable append(char c) {
            ++this.myLength;
            return this;
        }
    }
}

