/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaModuleReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsJavaModuleImpl
extends ClsRepositoryPsiElement<PsiJavaModuleStub>
implements PsiJavaModule {
    private PsiJavaModuleReferenceElement myReference;

    public ClsJavaModuleImpl(PsiJavaModuleStub stub) {
        super(stub);
        this.myReference = new ClsJavaModuleReferenceElementImpl((PsiElement)this, stub.getName());
    }

    @NotNull
    public PsiJavaModuleReferenceElement getNameElement() {
        PsiJavaModuleReferenceElement psiJavaModuleReferenceElement = this.myReference;
        if (psiJavaModuleReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getNameElement"));
        }
        return psiJavaModuleReferenceElement;
    }

    @NotNull
    public String getModuleName() {
        String string = this.myReference.getReferenceText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        JBIterable jBIterable = JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.REQUIRES_STATEMENT, (PsiElement[])PsiRequiresStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getRequires"));
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<PsiExportsStatement> getExports() {
        JBIterable jBIterable = JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.EXPORTS_STATEMENT, (PsiElement[])PsiExportsStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getExports"));
        }
        return jBIterable;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "appendMirrorText"));
        }
        buffer.append("module ").append(this.getModuleName()).append(" {\n");
        int newIndentLevel = indentLevel + this.getIndentSize();
        int position = buffer.length();
        for (PsiRequiresStatement psiRequiresStatement : this.getRequires()) {
            ClsJavaModuleImpl.appendText((PsiElement)psiRequiresStatement, newIndentLevel, buffer);
        }
        if (buffer.length() > position) {
            buffer.append('\n');
        }
        position = buffer.length();
        for (PsiExportsStatement psiExportsStatement : this.getExports()) {
            ClsJavaModuleImpl.appendText((PsiElement)psiExportsStatement, newIndentLevel, buffer);
        }
        if (buffer.length() > position) {
            buffer.append('\n');
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)newIndentLevel);
        buffer.append("/* ... */\n}");
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "setMirror"));
        }
        PsiJavaModule mirror = (PsiJavaModule)SourceTreeToPsiMap.treeToPsiNotNull(element);
        this.setMirrorCheckingType(element, JavaElementType.MODULE);
        ClsJavaModuleImpl.setMirror(this.getNameElement(), mirror.getNameElement());
        ClsJavaModuleImpl.setMirrors(Arrays.asList(((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.REQUIRES_STATEMENT, (PsiElement[])PsiRequiresStatement.EMPTY_ARRAY)), PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)mirror, PsiRequiresStatement.class));
        ClsJavaModuleImpl.setMirrors(Arrays.asList(((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.EXPORTS_STATEMENT, (PsiElement[])PsiExportsStatement.EMPTY_ARRAY)), PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)mirror, PsiExportsStatement.class));
    }

    @Override
    public String getName() {
        return this.getModuleName();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "setName"));
        }
        throw ClsJavaModuleImpl.cannotModifyException(this);
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiJavaModuleReferenceElement psiJavaModuleReferenceElement = this.getNameElement();
        if (psiJavaModuleReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getNavigationElement"));
        }
        return psiJavaModuleReferenceElement;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModule((PsiJavaModule)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiJavaModule:" + this.getModuleName();
    }
}

