/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.java.stubs.JavaClassElementType;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.BitUtil;
import org.jetbrains.annotations.Nullable;

public class PsiClassStubImpl<T extends PsiClass>
extends StubBase<T>
implements PsiClassStub<T> {
    private static final int DEPRECATED = 1;
    private static final int INTERFACE = 2;
    private static final int ENUM = 4;
    private static final int ENUM_CONSTANT_INITIALIZER = 8;
    private static final int ANONYMOUS = 16;
    private static final int ANON_TYPE = 32;
    private static final int IN_QUALIFIED_NEW = 64;
    private static final int DEPRECATED_ANNOTATION = 128;
    private final String myQualifiedName;
    private final String myName;
    private final String myBaseRefText;
    private final byte myFlags;
    private String mySourceFileName;

    public PsiClassStubImpl(JavaClassElementType type, StubElement parent, @Nullable String qualifiedName, @Nullable String name, @Nullable String baseRefText, byte flags) {
        super(parent, (IStubElementType)type);
        this.myQualifiedName = qualifiedName;
        this.myName = name;
        this.myBaseRefText = baseRefText;
        this.myFlags = flags;
        if (StubBasedPsiElementBase.ourTraceStubAstBinding) {
            String creationTrace = "Stub creation thread: " + Thread.currentThread() + "\n" + DebugUtil.currentStackTrace();
            this.putUserData(StubBasedPsiElementBase.CREATION_TRACE, creationTrace);
        }
    }

    public String getName() {
        return this.myName;
    }

    @Override
    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    @Override
    public String getBaseClassReferenceText() {
        return this.myBaseRefText;
    }

    @Override
    public boolean isDeprecated() {
        return BitUtil.isSet((int)this.myFlags, (int)1);
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return BitUtil.isSet((int)this.myFlags, (int)128);
    }

    @Override
    public boolean isInterface() {
        return BitUtil.isSet((int)this.myFlags, (int)2);
    }

    @Override
    public boolean isEnum() {
        return BitUtil.isSet((int)this.myFlags, (int)4);
    }

    @Override
    public boolean isEnumConstantInitializer() {
        return PsiClassStubImpl.isEnumConstInitializer(this.myFlags);
    }

    public static boolean isEnumConstInitializer(byte flags) {
        return BitUtil.isSet((int)flags, (int)8);
    }

    @Override
    public boolean isAnonymous() {
        return PsiClassStubImpl.isAnonymous(this.myFlags);
    }

    public static boolean isAnonymous(byte flags) {
        return BitUtil.isSet((int)flags, (int)16);
    }

    @Override
    public boolean isAnnotationType() {
        return BitUtil.isSet((int)this.myFlags, (int)32);
    }

    @Override
    public LanguageLevel getLanguageLevel() {
        LanguageLevel level;
        StubElement parent = this.getParentStub();
        if (parent instanceof PsiJavaFileStub && (level = ((PsiJavaFileStub)parent).getLanguageLevel()) != null) {
            return level;
        }
        return LanguageLevel.HIGHEST;
    }

    @Override
    public String getSourceFileName() {
        return this.mySourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.mySourceFileName = sourceFileName;
    }

    @Override
    public boolean isAnonymousInQualifiedNew() {
        return BitUtil.isSet((int)this.myFlags, (int)64);
    }

    public byte getFlags() {
        return this.myFlags;
    }

    public static byte packFlags(boolean isDeprecated, boolean isInterface, boolean isEnum, boolean isEnumConstantInitializer, boolean isAnonymous, boolean isAnnotationType, boolean isInQualifiedNew, boolean hasDeprecatedAnnotation) {
        byte flags = 0;
        if (isDeprecated) {
            flags = (byte)(flags | 1);
        }
        if (isInterface) {
            flags = (byte)(flags | 2);
        }
        if (isEnum) {
            flags = (byte)(flags | 4);
        }
        if (isEnumConstantInitializer) {
            flags = (byte)(flags | 8);
        }
        if (isAnonymous) {
            flags = (byte)(flags | 0x10);
        }
        if (isAnnotationType) {
            flags = (byte)(flags | 0x20);
        }
        if (isInQualifiedNew) {
            flags = (byte)(flags | 0x40);
        }
        if (hasDeprecatedAnnotation) {
            flags = (byte)(flags | 0x80);
        }
        return flags;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiClassStub[");
        if (this.isInterface()) {
            builder.append("interface ");
        }
        if (this.isAnonymous()) {
            builder.append("anonymous ");
        }
        if (this.isEnum()) {
            builder.append("enum ");
        }
        if (this.isAnnotationType()) {
            builder.append("annotation ");
        }
        if (this.isEnumConstantInitializer()) {
            builder.append("enumInit ");
        }
        if (this.isDeprecated()) {
            builder.append("deprecated ");
        }
        if (this.hasDeprecatedAnnotation()) {
            builder.append("deprecatedA ");
        }
        builder.append("name=").append(this.getName()).append(" fqn=").append(this.getQualifiedName());
        if (this.getBaseClassReferenceText() != null) {
            builder.append(" baseref=").append(this.getBaseClassReferenceText());
        }
        if (this.isAnonymousInQualifiedNew()) {
            builder.append(" inqualifnew");
        }
        builder.append("]");
        return builder.toString();
    }
}

