/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightParameterWrapper;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class LightParameterListWrapper
extends LightElement
implements PsiParameterList,
PsiMirrorElement {
    @NotNull
    private final PsiParameterList myDelegate;
    @NotNull
    private final PsiSubstitutor mySubstitutor;

    public LightParameterListWrapper(@NotNull PsiParameterList delegate, @NotNull PsiSubstitutor substitutor) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/psi/impl/light/LightParameterListWrapper", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/light/LightParameterListWrapper", "<init>"));
        }
        super(delegate.getManager(), delegate.getLanguage());
        this.myDelegate = delegate;
        this.mySubstitutor = substitutor;
    }

    @NotNull
    public PsiParameterList getPrototype() {
        PsiParameterList psiParameterList = this.myDelegate;
        if (psiParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightParameterListWrapper", "getPrototype"));
        }
        return psiParameterList;
    }

    @NotNull
    public PsiParameter[] getParameters() {
        PsiParameter[] psiParameterArray = this.mySubstitutor == PsiSubstitutor.EMPTY ? this.myDelegate.getParameters() : (PsiParameter[])ContainerUtil.map2Array((Object[])this.myDelegate.getParameters(), PsiParameter.class, (Function)new Function<PsiParameter, PsiParameter>(){

            public PsiParameter fun(PsiParameter parameter) {
                return new LightParameterWrapper(parameter, LightParameterListWrapper.this.mySubstitutor);
            }
        });
        if (psiParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightParameterListWrapper", "getParameters"));
        }
        return psiParameterArray;
    }

    public int getParameterIndex(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/psi/impl/light/LightParameterListWrapper", "getParameterIndex"));
        }
        if (parameter instanceof LightParameterWrapper) {
            parameter = ((LightParameterWrapper)parameter).getPrototype();
        }
        return this.myDelegate.getParameterIndex(parameter);
    }

    public int getParametersCount() {
        return this.myDelegate.getParametersCount();
    }

    @Override
    public String toString() {
        return "List PSI parameter list wrapper: " + this.myDelegate;
    }
}

