/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private final Project myProject;
    private final Key<SmartPointerTracker> POINTERS_KEY;
    private final PsiDocumentManagerBase myPsiDocManager;
    private static final Key<Reference<SmartPsiElementPointerImpl>> CACHED_SMART_POINTER_KEY = Key.create((String)"CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(Project project2) {
        this.myProject = project2;
        this.myPsiDocManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject);
        this.POINTERS_KEY = Key.create((String)("SMART_POINTERS for " + project2));
    }

    public void fastenBelts(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "fastenBelts"));
        }
        SmartPointerTracker pointers = this.getTracker(file2);
        if (pointers != null) {
            pointers.fastenBelts();
        }
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile, false);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile, boolean forInjected) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        if (containingFile != null && !containingFile.isValid() || containingFile == null && !element.isValid()) {
            PsiUtilCore.ensureValid(element);
            LOG.error("Invalid element:" + element);
        }
        SmartPointerTracker.processQueue();
        SmartPsiElementPointerImpl<E> pointer = SmartPointerManagerImpl.getCachedPointer(element);
        if (pointer != null && pointer.incrementAndGetReferenceCount(1) > 0) {
            SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
            if (smartPsiElementPointerImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
            }
            return smartPsiElementPointerImpl;
        }
        pointer = new SmartPsiElementPointerImpl<E>(this.myProject, element, containingFile, forInjected);
        if (containingFile != null) {
            this.trackPointer(pointer, containingFile.getViewProvider().getVirtualFile());
        }
        element.putUserData(CACHED_SMART_POINTER_KEY, (Object)new SoftReference(pointer));
        SmartPsiElementPointerImpl<E> smartPsiElementPointerImpl = pointer;
        if (smartPsiElementPointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointerImpl;
    }

    private static <E extends PsiElement> SmartPsiElementPointerImpl<E> getCachedPointer(@NotNull E element) {
        Object cachedElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getCachedPointer"));
        }
        Reference data = (Reference)element.getUserData(CACHED_SMART_POINTER_KEY);
        SmartPsiElementPointerImpl cachedPointer = (SmartPsiElementPointerImpl)SoftReference.dereference((Reference)data);
        if (cachedPointer != null && ((cachedElement = cachedPointer.getElement()) == null || cachedElement != element)) {
            return null;
        }
        return cachedPointer;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        SmartPsiFileRange smartPsiFileRange = this.createSmartPsiFileRangePointer(file2, range, false);
        if (smartPsiFileRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRange;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range, boolean forInjected) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (!file2.isValid()) {
            LOG.error("Invalid element:" + file2);
        }
        SmartPointerTracker.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(file2, ProperTextRange.create((Segment)range), forInjected);
        this.trackPointer(pointer, file2.getViewProvider().getVirtualFile());
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRangePointerImpl;
    }

    private <E extends PsiElement> void trackPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        SmartPointerTracker pointers;
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "trackPointer"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "trackPointer"));
        }
        SmartPointerElementInfo info = pointer.getElementInfo();
        if (!(info instanceof SelfElementInfo)) {
            return;
        }
        SmartPointerTracker.PointerReference reference = new SmartPointerTracker.PointerReference(pointer, containingFile, this.POINTERS_KEY);
        do {
            if ((pointers = this.getTracker(containingFile)) != null) continue;
            pointers = (SmartPointerTracker)containingFile.putUserDataIfAbsent(this.POINTERS_KEY, (Object)new SmartPointerTracker());
        } while (!pointers.addReference(reference, pointer));
    }

    public void removePointer(@NotNull SmartPsiElementPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "removePointer"));
        }
        if (!(pointer instanceof SmartPsiElementPointerImpl) || this.myProject.isDisposed()) {
            return;
        }
        PsiFile containingFile = pointer.getContainingFile();
        int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
        if (refCount == 0) {
            PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
            if (element != null) {
                element.putUserData(CACHED_SMART_POINTER_KEY, null);
            }
            SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
            info.cleanup();
            if (containingFile == null) {
                return;
            }
            VirtualFile vFile = containingFile.getViewProvider().getVirtualFile();
            SmartPointerTracker pointers = this.getTracker(vFile);
            SmartPointerTracker.PointerReference reference = ((SmartPsiElementPointerImpl)pointer).pointerReference;
            if (pointers != null && reference != null) {
                pointers.removeReference(reference);
            }
        }
    }

    @Nullable
    SmartPointerTracker getTracker(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getTracker"));
        }
        return (SmartPointerTracker)containingFile.getUserData(this.POINTERS_KEY);
    }

    public int getPointersNumber(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointersNumber"));
        }
        VirtualFile file2 = containingFile.getViewProvider().getVirtualFile();
        SmartPointerTracker pointers = this.getTracker(file2);
        return pointers == null ? 0 : pointers.getSize();
    }

    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer1", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        if (pointer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer2", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(Document document, FrozenDocument frozen, List<DocumentEvent> events) {
        SmartPointerTracker list;
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        SmartPointerTracker smartPointerTracker = list = file2 == null ? null : this.getTracker(file2);
        if (list != null) {
            list.updateMarkers(frozen, events);
        }
    }

    public void updatePointerTargetsAfterReparse(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "updatePointerTargetsAfterReparse"));
        }
        SmartPointerTracker list = this.getTracker(file2);
        if (list != null) {
            list.updatePointerTargetsAfterReparse();
        }
    }

    Project getProject() {
        return this.myProject;
    }

    PsiDocumentManagerBase getPsiDocumentManager() {
        return this.myPsiDocManager;
    }
}

