/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiClassReferenceType
extends PsiClassType.Stub {
    private final Computable<PsiJavaCodeReferenceElement> myReference;

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        this(reference, level, PsiClassReferenceType.collectAnnotations(reference));
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull PsiAnnotation[] annotations) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        super(level, annotations);
        this.myReference = new Computable.PredefinedValueComputable((Object)reference);
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        this((Computable<PsiJavaCodeReferenceElement>)new Computable.PredefinedValueComputable((Object)reference), level, provider);
    }

    public PsiClassReferenceType(@NotNull Computable<PsiJavaCodeReferenceElement> reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        super(level, provider);
        this.myReference = reference;
    }

    private static PsiAnnotation[] collectAnnotations(PsiJavaCodeReferenceElement reference) {
        List result2 = null;
        for (PsiElement child = reference.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiAnnotation)) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add((PsiAnnotation)child);
        }
        return result2 == null ? PsiAnnotation.EMPTY_ARRAY : result2.toArray(new PsiAnnotation[result2.size()]);
    }

    public boolean isValid() {
        PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)this.myReference.compute();
        return reference != null && reference.isValid();
    }

    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/PsiClassReferenceType", "equalsToText"));
        }
        return Comparing.equal((String)text, (String)this.getCanonicalText());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.getReference().getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        if (this.myLanguageLevel != null) {
            LanguageLevel languageLevel = this.myLanguageLevel;
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getLanguageLevel"));
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)this.getReference());
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/source/PsiClassReferenceType", "setLanguageLevel"));
        }
        if (languageLevel.equals((Object)this.myLanguageLevel)) {
            PsiClassReferenceType psiClassReferenceType = this;
            if (psiClassReferenceType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "setLanguageLevel"));
            }
            return psiClassReferenceType;
        }
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(this.getReference(), languageLevel, this.getAnnotationProvider());
        if (psiClassReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "setLanguageLevel"));
        }
        return psiClassReferenceType;
    }

    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        PsiUtilCore.ensureValid((PsiElement)reference);
        JavaResolveResult result2 = reference.advancedResolve(false);
        Object object = result2.getElement() == null ? PsiClassType.ClassResolveResult.EMPTY : new DelegatingClassResolveResult(result2);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "resolveGenerics"));
        }
        return object;
    }

    @NotNull
    public PsiClassType rawType() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PsiClass) {
            PsiClass aClass = (PsiClass)resolved;
            if (!PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass).iterator().hasNext()) {
                PsiClassReferenceType psiClassReferenceType = this;
                if (psiClassReferenceType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "rawType"));
                }
                return psiClassReferenceType;
            }
            PsiManager manager = reference.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiSubstitutor rawSubstitutor = factory.createRawSubstitutor((PsiTypeParameterListOwner)aClass);
            PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(aClass, rawSubstitutor, this.getLanguageLevel(), this.getAnnotationProvider());
            if (psiImmediateClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "rawType"));
            }
            return psiImmediateClassType;
        }
        String qualifiedName = reference.getQualifiedName();
        String name = reference.getReferenceName();
        if (name == null) {
            name = "";
        }
        LightClassReference lightReference = new LightClassReference(reference.getManager(), name, qualifiedName, reference.getResolveScope());
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType((PsiJavaCodeReferenceElement)lightReference, null, this.getAnnotationProvider());
        if (psiClassReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "rawType"));
        }
        return psiClassReferenceType;
    }

    public String getClassName() {
        return this.getReference().getReferenceName();
    }

    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray = this.getReference().getTypeParameters();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getParameters"));
        }
        return psiTypeArray;
    }

    @NotNull
    public PsiClassType createImmediateCopy() {
        PsiClassType.ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass element = resolveResult.getElement();
        PsiClassType.Stub stub = element == null ? this : new PsiImmediateClassType(element, resolveResult.getSubstitutor());
        if (stub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "createImmediateCopy"));
        }
        return stub;
    }

    @NotNull
    public String getPresentableText(boolean annotated) {
        PsiAnnotation[] annotations;
        String presentableText = PsiNameHelper.getPresentableText((PsiJavaCodeReferenceElement)this.getReference());
        PsiAnnotation[] psiAnnotationArray = annotations = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
        if (annotations.length == 0) {
            String string = presentableText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getPresentableText"));
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations((StringBuilder)sb, (PsiAnnotation[])annotations, (boolean)false);
        sb.append(presentableText);
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getPresentableText"));
        }
        return string;
    }

    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(annotated);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getCanonicalText"));
        }
        return string;
    }

    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText(true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getInternalCanonicalText"));
        }
        return string;
    }

    private String getText(boolean annotated) {
        PsiJavaCodeReferenceElement reference = this.getReference();
        if (reference instanceof PsiAnnotatedJavaCodeReferenceElement) {
            PsiAnnotatedJavaCodeReferenceElement ref = (PsiAnnotatedJavaCodeReferenceElement)reference;
            PsiAnnotation[] annotations = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
            return ref.getCanonicalText(annotated, annotations.length == 0 ? null : annotations);
        }
        return reference.getCanonicalText();
    }

    @NotNull
    public PsiJavaCodeReferenceElement getReference() {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)ObjectUtils.assertNotNull((Object)this.myReference.compute());
        if (psiJavaCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getReference"));
        }
        return psiJavaCodeReferenceElement;
    }

    private static class DelegatingClassResolveResult
    implements PsiClassType.ClassResolveResult {
        private final JavaResolveResult myDelegate;

        private DelegatingClassResolveResult(@NotNull JavaResolveResult delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/psi/impl/source/PsiClassReferenceType$DelegatingClassResolveResult", "<init>"));
            }
            this.myDelegate = delegate;
        }

        @NotNull
        public PsiSubstitutor getSubstitutor() {
            PsiSubstitutor psiSubstitutor = this.myDelegate.getSubstitutor();
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType$DelegatingClassResolveResult", "getSubstitutor"));
            }
            return psiSubstitutor;
        }

        public boolean isValidResult() {
            return this.myDelegate.isValidResult();
        }

        public boolean isAccessible() {
            return this.myDelegate.isAccessible();
        }

        public boolean isStaticsScopeCorrect() {
            return this.myDelegate.isStaticsScopeCorrect();
        }

        public PsiElement getCurrentFileResolveScope() {
            return this.myDelegate.getCurrentFileResolveScope();
        }

        public boolean isPackagePrefixPackageReference() {
            return this.myDelegate.isPackagePrefixPackageReference();
        }

        public PsiClass getElement() {
            PsiElement element = this.myDelegate.getElement();
            return element instanceof PsiClass ? (PsiClass)element : null;
        }
    }
}

