/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemeImpl
extends ExternalizableSchemeAdapter
implements CodeStyleScheme,
SerializableScheme {
    private static final Logger LOG = Logger.getInstance(CodeStyleSchemeImpl.class);
    static final String DEFAULT_SCHEME_NAME = "Default";
    private SchemeDataHolder<? super CodeStyleSchemeImpl> myDataHolder;
    private String myParentSchemeName;
    private final boolean myIsDefault;
    private volatile CodeStyleSettings myCodeStyleSettings;

    CodeStyleSchemeImpl(@NotNull String name, String parentSchemeName, @NotNull SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "<init>"));
        }
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "<init>"));
        }
        this.setName(name);
        this.myDataHolder = dataHolder;
        this.myIsDefault = DEFAULT_SCHEME_NAME.equals(name);
        this.myParentSchemeName = parentSchemeName;
    }

    public CodeStyleSchemeImpl(@NotNull String name, boolean isDefault, CodeStyleScheme parentScheme) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "<init>"));
        }
        this.setName(name);
        this.myIsDefault = isDefault;
        this.init(parentScheme, null);
    }

    private void init(@Nullable CodeStyleScheme parentScheme, @Nullable Element root) {
        if (parentScheme == null) {
            this.myCodeStyleSettings = new CodeStyleSettings();
        } else {
            CodeStyleSettings parentSettings = parentScheme.getCodeStyleSettings();
            this.myCodeStyleSettings = parentSettings.clone();
            while (parentSettings.getParentSettings() != null) {
                parentSettings = parentSettings.getParentSettings();
            }
            this.myCodeStyleSettings.setParentSettings(parentSettings);
        }
        if (root != null) {
            try {
                this.myCodeStyleSettings.readExternal(root);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    public CodeStyleSettings getCodeStyleSettings() {
        SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder = this.myDataHolder;
        if (dataHolder != null) {
            this.myDataHolder = null;
            this.init(this.myParentSchemeName == null ? null : CodeStyleSchemesImpl.getSchemeManager().findSchemeByName(this.myParentSchemeName), dataHolder.read());
            dataHolder.updateDigest(this);
            this.myParentSchemeName = null;
        }
        CodeStyleSettings codeStyleSettings = this.myCodeStyleSettings;
        if (codeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "getCodeStyleSettings"));
        }
        return codeStyleSettings;
    }

    boolean isInitialized() {
        return this.myDataHolder == null;
    }

    public void setCodeStyleSettings(@NotNull CodeStyleSettings codeStyleSettings) {
        if (codeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleSettings", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "setCodeStyleSettings"));
        }
        this.myCodeStyleSettings = codeStyleSettings;
        this.myParentSchemeName = null;
        this.myDataHolder = null;
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    public void resetToDefaults() {
        this.myCodeStyleSettings = new CodeStyleSettings();
    }

    @Override
    @Nullable
    public SchemeState getSchemeState() {
        return this.isInitialized() ? SchemeState.POSSIBLY_CHANGED : SchemeState.UNCHANGED;
    }

    @Override
    @NotNull
    public Element writeScheme() {
        if (this.myDataHolder == null) {
            Element newElement = new Element("code_scheme");
            newElement.setAttribute("name", this.getName());
            this.myCodeStyleSettings.writeExternal(newElement);
            Element element = newElement;
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "writeScheme"));
            }
            return element;
        }
        Element element = this.myDataHolder.read();
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "writeScheme"));
        }
        return element;
    }
}

