/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SemanticEditorPosition {
    private final EditorEx myEditor;
    private final HighlighterIterator myIterator;
    private final CharSequence myChars;

    public SemanticEditorPosition(@NotNull EditorEx editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "<init>"));
        }
        this.myEditor = editor;
        this.myChars = editor.getDocument().getCharsSequence();
        this.myIterator = editor.getHighlighter().createIterator(offset);
    }

    public SemanticEditorPosition beforeOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntaxElement", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "beforeOptional"));
        }
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.retreat();
        }
        return this;
    }

    public SemanticEditorPosition beforeOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "beforeOptionalMix"));
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.retreat();
        }
        return this;
    }

    public SemanticEditorPosition afterOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "afterOptionalMix"));
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.advance();
        }
        return this;
    }

    public boolean isAtMultiline() {
        if (!this.myIterator.atEnd()) {
            return CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)this.myIterator.getStart(), (int)this.myIterator.getEnd());
        }
        return false;
    }

    public SemanticEditorPosition before() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.retreat();
        }
        return this;
    }

    public SemanticEditorPosition afterOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntaxElement", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "afterOptional"));
        }
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.advance();
        }
        return this;
    }

    public SemanticEditorPosition after() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.advance();
        }
        return this;
    }

    public SemanticEditorPosition beforeParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftParenthesis", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "beforeParentheses"));
        }
        if (rightParenthesis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightParenthesis", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "beforeParentheses"));
        }
        int parenLevel = 0;
        while (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            this.myIterator.retreat();
            if (rightParenthesis.equals(currElement)) {
                ++parenLevel;
                continue;
            }
            if (!leftParenthesis.equals(currElement) || --parenLevel >= 1) continue;
            break;
        }
        return this;
    }

    public SemanticEditorPosition findLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftParenthesis", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "findLeftParenthesisBackwardsSkippingNested"));
        }
        if (rightParenthesis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightParenthesis", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "findLeftParenthesisBackwardsSkippingNested"));
        }
        while (!this.myIterator.atEnd()) {
            if (rightParenthesis.equals(this.map(this.myIterator.getTokenType()))) {
                this.beforeParentheses(leftParenthesis, rightParenthesis);
            } else if (leftParenthesis.equals(this.map(this.myIterator.getTokenType()))) break;
            this.myIterator.retreat();
        }
        return this;
    }

    public boolean isAfterOnSameLine(SyntaxElement ... syntaxElements) {
        if (syntaxElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntaxElements", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "isAfterOnSameLine"));
        }
        this.myIterator.retreat();
        while (!this.myIterator.atEnd() && !this.isAtMultiline()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element : syntaxElements) {
                if (!element.equals(currElement)) continue;
                return true;
            }
            this.myIterator.retreat();
        }
        return false;
    }

    public boolean isAt(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntaxElement", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "isAt"));
        }
        return !this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()));
    }

    public boolean isAt(@NotNull IElementType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "isAt"));
        }
        return !this.myIterator.atEnd() && this.myIterator.getTokenType() == elementType;
    }

    public boolean isAtEnd() {
        return this.myIterator.atEnd();
    }

    public int getStartOffset() {
        return this.myIterator.getStart();
    }

    public boolean isAtAnyOf(SyntaxElement ... syntaxElements) {
        if (syntaxElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntaxElements", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "isAtAnyOf"));
        }
        if (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element : syntaxElements) {
                if (!element.equals(currElement)) continue;
                return true;
            }
        }
        return false;
    }

    public CharSequence getChars() {
        return this.myChars;
    }

    public int findStartOf(@NotNull SyntaxElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "findStartOf"));
        }
        while (!this.myIterator.atEnd()) {
            if (element.equals(this.map(this.myIterator.getTokenType()))) {
                return this.myIterator.getStart();
            }
            this.myIterator.retreat();
        }
        return -1;
    }

    public boolean hasEmptyLineAfter(int offset) {
        for (int i2 = offset; i2 < this.myIterator.getEnd(); ++i2) {
            if (this.myChars.charAt(i2) != '\n') continue;
            return true;
        }
        return false;
    }

    public EditorEx getEditor() {
        return this.myEditor;
    }

    @Nullable
    public Language getLanguage() {
        return !this.myIterator.atEnd() ? this.myIterator.getTokenType().getLanguage() : null;
    }

    public boolean isAtLanguage(@Nullable Language language) {
        if (language != null && !this.myIterator.atEnd()) {
            return language == Language.ANY || this.myIterator.getTokenType().getLanguage().is(language);
        }
        return false;
    }

    @Nullable
    public SyntaxElement getCurrElement() {
        return !this.myIterator.atEnd() ? this.map(this.myIterator.getTokenType()) : null;
    }

    public boolean matchesRule(@NotNull Rule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition", "matchesRule"));
        }
        return rule.check(this);
    }

    public abstract SyntaxElement map(@NotNull IElementType var1);

    public String toString() {
        return this.myIterator.getTokenType().toString();
    }

    public static interface Rule {
        public boolean check(SemanticEditorPosition var1);
    }

    public static interface SyntaxElement {
    }
}

