/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLangClassMemberReference
extends PsiReferenceBase<PsiLiteralExpression>
implements InsertHandler<LookupElement> {
    private static final String FIELD = "getField";
    private static final String DECLARED_FIELD = "getDeclaredField";
    private static final String METHOD = "getMethod";
    private static final String DECLARED_METHOD = "getDeclaredMethod";
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"JavaLangClassMemberReference");
    private final PsiExpression myContext;

    public JavaLangClassMemberReference(@NotNull PsiLiteralExpression literal, @NotNull PsiExpression context) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "<init>"));
        }
        super((PsiElement)literal);
        this.myContext = context;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "bindToElement"));
        }
        return element;
    }

    public PsiElement resolve() {
        Object value = ((PsiLiteralExpression)this.myElement).getValue();
        if (value instanceof String) {
            PsiClass psiClass;
            String name = (String)value;
            String type = this.getMemberType();
            if (type != null && (psiClass = this.getPsiClass()) != null) {
                switch (type) {
                    case "getField": {
                        return psiClass.findFieldByName(name, true);
                    }
                    case "getDeclaredField": {
                        PsiField field = psiClass.findFieldByName(name, false);
                        return JavaLangClassMemberReference.isReachable((PsiMember)field, psiClass) ? field : null;
                    }
                    case "getMethod": {
                        Object[] methods = psiClass.findMethodsByName(name, true);
                        PsiMethod publicMethod = (PsiMethod)ContainerUtil.find((Object[])methods, method2 -> JavaLangClassMemberReference.isRegularMethod(method2) && JavaLangClassMemberReference.isPublic((PsiMember)method2));
                        if (publicMethod != null) {
                            return publicMethod;
                        }
                        return (PsiElement)ContainerUtil.find((Object[])methods, method2 -> JavaLangClassMemberReference.isRegularMethod(method2));
                    }
                    case "getDeclaredMethod": {
                        Object[] methods = psiClass.findMethodsByName(name, false);
                        return (PsiElement)ContainerUtil.find((Object[])methods, method2 -> JavaLangClassMemberReference.isRegularMethod(method2) && JavaLangClassMemberReference.isReachable((PsiMember)method2, psiClass));
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private PsiClass getPsiClass() {
        return JavaLangClassMemberReference.getPsiClass(this.myContext);
    }

    @Nullable
    private static PsiClass getPsiClass(PsiExpression context) {
        PsiExpression definition;
        PsiElement resolved;
        PsiType type;
        if ((context = ParenthesesUtils.stripParentheses(context)) instanceof PsiClassObjectAccessExpression) {
            PsiTypeElement operand = ((PsiClassObjectAccessExpression)context).getOperand();
            return PsiTypesUtil.getPsiClass((PsiType)operand.getType());
        }
        if (context instanceof PsiMethodCallExpression) {
            PsiMethod method2;
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)context;
            String methodReferenceName = methodCall.getMethodExpression().getReferenceName();
            if ("forName".equals(methodReferenceName)) {
                PsiExpression[] expressions;
                method2 = methodCall.resolveMethod();
                if (method2 != null && JavaLangClassMemberReference.isJavaLangClass(method2.getContainingClass()) && (expressions = methodCall.getArgumentList().getExpressions()).length == 1) {
                    Object value;
                    PsiExpression argument = ParenthesesUtils.stripParentheses(expressions[0]);
                    if (argument instanceof PsiReferenceExpression) {
                        argument = JavaLangClassMemberReference.findVariableDefinition((PsiReferenceExpression)argument);
                    }
                    if ((value = JavaConstantExpressionEvaluator.computeConstantExpression(argument, false)) instanceof String) {
                        Project project2 = context.getProject();
                        return JavaPsiFacade.getInstance((Project)project2).findClass((String)value, GlobalSearchScope.allScope((Project)project2));
                    }
                }
            } else if ("getClass".equals(methodReferenceName) && methodCall.getArgumentList().getExpressions().length == 0 && (method2 = methodCall.resolveMethod()) != null && JavaLangClassMemberReference.isJavaLangObject(method2.getContainingClass())) {
                PsiClass actualClass;
                PsiExpression definition2;
                PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodCall.getMethodExpression().getQualifierExpression());
                if (qualifier instanceof PsiReferenceExpression && (definition2 = JavaLangClassMemberReference.findVariableDefinition((PsiReferenceExpression)qualifier)) != null && (actualClass = PsiTypesUtil.getPsiClass((PsiType)definition2.getType())) != null) {
                    return actualClass;
                }
                if (qualifier != null) {
                    return PsiTypesUtil.getPsiClass((PsiType)qualifier.getType());
                }
            }
        }
        if ((type = context.getType()) instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type).resolveGenerics();
            if (!JavaLangClassMemberReference.isJavaLangClass(resolveResult.getElement())) {
                return null;
            }
            PsiTypeParameter[] parameters = resolveResult.getElement().getTypeParameters();
            if (parameters.length == 1) {
                PsiClass argumentClass;
                PsiType typeArgument = resolveResult.getSubstitutor().substitute(parameters[0]);
                if (typeArgument instanceof PsiCapturedWildcardType) {
                    typeArgument = ((PsiCapturedWildcardType)typeArgument).getUpperBound();
                }
                if ((argumentClass = PsiTypesUtil.getPsiClass((PsiType)typeArgument)) != null && !JavaLangClassMemberReference.isJavaLangObject(argumentClass)) {
                    return argumentClass;
                }
            }
        }
        if (context instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)context).resolve()) instanceof PsiVariable && (definition = JavaLangClassMemberReference.findVariableDefinition((PsiReferenceExpression)context, (PsiVariable)resolved)) != null) {
            return (PsiClass)ourGuard.doPreventingRecursion((Object)resolved, false, () -> JavaLangClassMemberReference.getPsiClass(definition));
        }
        return null;
    }

    private static PsiExpression findVariableDefinition(@NotNull PsiReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "findVariableDefinition"));
        }
        PsiElement resolved = referenceExpression.resolve();
        return resolved instanceof PsiVariable ? JavaLangClassMemberReference.findVariableDefinition(referenceExpression, (PsiVariable)resolved) : null;
    }

    private static PsiExpression findVariableDefinition(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable variable) {
        PsiExpression initializer;
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "findVariableDefinition"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "findVariableDefinition"));
        }
        if (variable.hasModifierProperty("final") && (initializer = variable.getInitializer()) != null) {
            return initializer;
        }
        return DeclarationSearchUtils.findDefinition(referenceExpression, variable);
    }

    private static boolean isJavaLangClass(PsiClass aClass) {
        return aClass != null && "java.lang.Class".equals(aClass.getQualifiedName());
    }

    private static boolean isJavaLangObject(PsiClass aClass) {
        return aClass != null && "java.lang.Object".equals(aClass.getQualifiedName());
    }

    @Nullable
    private String getMemberType() {
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiMethodCallExpression.class);
        return methodCall != null ? methodCall.getMethodExpression().getReferenceName() : null;
    }

    @NotNull
    public Object[] getVariants() {
        PsiClass psiClass;
        String type = this.getMemberType();
        if (type != null && (psiClass = this.getPsiClass()) != null) {
            switch (type) {
                case "getDeclaredField": {
                    Object[] objectArray = psiClass.getFields();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "getField": {
                    Object[] objectArray = ContainerUtil.filter((Object[])psiClass.getAllFields(), field -> JavaLangClassMemberReference.isReachable((PsiMember)field, psiClass)).toArray();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "getDeclaredMethod": {
                    Object[] objectArray = Arrays.stream(psiClass.getMethods()).filter(method2 -> JavaLangClassMemberReference.isRegularMethod(method2)).map(this::lookupMethod).toArray();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "getMethod": {
                    Object[] objectArray = Arrays.stream(psiClass.getAllMethods()).filter(method2 -> JavaLangClassMemberReference.isRegularMethod(method2) && JavaLangClassMemberReference.isReachable((PsiMember)method2, psiClass) && !JavaLangClassMemberReference.isJavaLangObject(method2.getContainingClass())).map(this::lookupMethod).toArray();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                    }
                    return objectArray;
                }
            }
        }
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    private LookupElementBuilder lookupMethod(PsiMethod method2) {
        LookupElementBuilder lookupElementBuilder = JavaLookupElementBuilder.forMethod(method2, PsiSubstitutor.EMPTY).withInsertHandler((InsertHandler)this);
        if (lookupElementBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "lookupMethod"));
        }
        return lookupElementBuilder;
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        Object object = item.getObject();
        if (object instanceof PsiMethod) {
            PsiElement newElement = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset());
            int start = newElement.getTextRange().getEndOffset();
            PsiElement params = newElement.getParent().getParent();
            int end = params.getTextRange().getEndOffset() - 1;
            String types = JavaLangClassMemberReference.getMethodTypes((PsiMethod)object);
            context.getDocument().replaceString(start, end, (CharSequence)types);
            context.commitDocument();
            PsiElement firstParam = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset());
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)firstParam, PsiMethodCallExpression.class);
            if (methodCall != null) {
                JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)methodCall);
            }
        }
    }

    @Contract(value="null -> false")
    private static boolean isRegularMethod(PsiMethod method2) {
        return method2 != null && !method2.isConstructor();
    }

    @Contract(value="null, _ -> false")
    private static boolean isReachable(PsiMember member, PsiClass psiClass) {
        return member != null && (member.getContainingClass() == psiClass || JavaLangClassMemberReference.isPublic(member));
    }

    private static boolean isPublic(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "isPublic"));
        }
        return member.hasModifierProperty("public");
    }

    private static String getMethodTypes(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getMethodTypes"));
        }
        StringBuilder buf = new StringBuilder();
        for (PsiParameter parameter : method2.getParameterList().getParameters()) {
            PsiType type = TypeConversionUtil.erasure((PsiType)parameter.getType());
            if (type instanceof PsiEllipsisType) {
                type = new PsiArrayType(((PsiEllipsisType)type).getComponentType());
            }
            buf.append(", ").append(type.getPresentableText()).append(".class");
        }
        return buf.toString();
    }
}

