/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

class CreateXmlElementIntentionAction
implements IntentionAction {
    private final String myMessageKey;
    protected final TypeOrElementOrAttributeReference myRef;
    private boolean myIsAvailableEvaluated;
    private XmlFile myTargetFile;
    private final String myDeclarationTagName;

    CreateXmlElementIntentionAction(@PropertyKey(resourceBundle="messages.XmlBundle") String messageKey, @NonNls @NotNull String declarationTagName, TypeOrElementOrAttributeReference ref) {
        if (declarationTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationTagName", "com/intellij/psi/impl/source/resolve/reference/impl/providers/CreateXmlElementIntentionAction", "<init>"));
        }
        this.myMessageKey = messageKey;
        this.myRef = ref;
        this.myDeclarationTagName = declarationTagName;
    }

    @NotNull
    public String getText() {
        String string = XmlBundle.message((String)this.myMessageKey, (Object[])new Object[]{XmlUtil.findLocalNameByQualifiedName(this.myRef.getCanonicalText())});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/CreateXmlElementIntentionAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)"xml.create.xml.declaration.intention.type", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/CreateXmlElementIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/resolve/reference/impl/providers/CreateXmlElementIntentionAction", "isAvailable"));
        }
        if (!this.myIsAvailableEvaluated) {
            XmlNSDescriptorImpl descriptor;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myRef.getElement(), XmlTag.class);
            if (tag != null && (descriptor = this.myRef.getDescriptor(tag, this.myRef.getCanonicalText())) != null && descriptor.getDescriptorFile() != null && descriptor.getDescriptorFile().isWritable()) {
                this.myTargetFile = descriptor.getDescriptorFile();
            }
            this.myIsAvailableEvaluated = true;
        }
        return this.myTargetFile != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/resolve/reference/impl/providers/CreateXmlElementIntentionAction", "invoke"));
        }
        XmlTag rootTag = this.myTargetFile.getDocument().getRootTag();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project2, this.myTargetFile.getVirtualFile(), rootTag.getValue().getTextRange().getEndOffset());
        Editor targetEditor = FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor, true);
        TemplateManager manager = TemplateManager.getInstance(project2);
        Template template = manager.createTemplate("", "");
        this.addTextTo(template, rootTag);
        manager.startTemplate(targetEditor, template);
    }

    protected void addTextTo(Template template, XmlTag rootTag) {
        String schemaPrefix = rootTag.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema");
        if (!schemaPrefix.isEmpty()) {
            schemaPrefix = schemaPrefix + ":";
        }
        template.addTextSegment("<" + schemaPrefix + this.myDeclarationTagName + " name=\"" + XmlUtil.findLocalNameByQualifiedName(this.myRef.getCanonicalText()) + "\">");
        template.addEndVariable();
        template.addTextSegment("</" + schemaPrefix + this.myDeclarationTagName + ">\n");
        template.setToReformat(true);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

