/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LeafElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.impl.source.tree.LeafElement");
    private static final Key<SoftReference<String>> CACHED_TEXT = Key.create((String)"CACHED_TEXT");
    private static final int TEXT_MATCHES_THRESHOLD = 5;
    private final CharSequence myText;

    protected LeafElement(@NotNull IElementType type, CharSequence text) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/LeafElement", "<init>"));
        }
        super(type);
        this.myText = text;
    }

    @Override
    @NotNull
    public LeafElement clone() {
        LeafElement clone = (LeafElement)super.clone();
        clone.clearCaches();
        LeafElement leafElement = clone;
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafElement", "clone"));
        }
        return leafElement;
    }

    public int getTextLength() {
        return this.myText.length();
    }

    @NotNull
    public CharSequence getChars() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafElement", "getChars"));
        }
        return charSequence;
    }

    @NotNull
    public String getText() {
        CharSequence text = this.myText;
        if (text.length() > 1000 && !(text instanceof String)) {
            String cachedText = (String)SoftReference.dereference((Reference)((Reference)this.getUserData(CACHED_TEXT)));
            if (cachedText == null) {
                cachedText = text.toString();
                this.putUserData(CACHED_TEXT, new SoftReference((Object)cachedText));
            }
            String string = cachedText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafElement", "getText"));
            }
            return string;
        }
        String string = text.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafElement", "getText"));
        }
        return string;
    }

    public char charAt(int position) {
        return this.myText.charAt(position);
    }

    public int copyTo(@Nullable char[] buffer, int start) {
        int length = this.myText.length();
        if (buffer != null) {
            CharArrayUtil.getChars((CharSequence)this.myText, (char[])buffer, (int)start, (int)length);
        }
        return start + length;
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] buffer = new char[this.myText.length()];
        CharArrayUtil.getChars((CharSequence)this.myText, (char[])buffer, (int)0);
        if (buffer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafElement", "textToCharArray"));
        }
        return buffer;
    }

    public boolean textContains(char c) {
        char[] chars;
        CharSequence text = this.myText;
        int len = text.length();
        if (len > 5 && (chars = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)text)) != null) {
            for (char aChar : chars) {
                if (aChar != c) continue;
                return true;
            }
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (c != text.charAt(i2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/tree/LeafElement", "textMatches"));
        }
        assert (start >= 0) : start;
        return LeafElement.leafTextMatches(this.myText, buffer, start);
    }

    static int leafTextMatches(@NotNull CharSequence text, @NotNull CharSequence buffer, int start) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/tree/LeafElement", "leafTextMatches"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/tree/LeafElement", "leafTextMatches"));
        }
        assert (start >= 0) : start;
        int length = text.length();
        if (buffer.length() - start < length) {
            return start == 0 ? Integer.MIN_VALUE : -start;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            int k = i2 + start;
            if (text.charAt(i2) == buffer.charAt(k)) continue;
            return k == 0 ? Integer.MIN_VALUE : -k;
        }
        return start + length;
    }

    @NotNull
    public LeafElement rawReplaceWithText(@NotNull String newText) {
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/psi/impl/source/tree/LeafElement", "rawReplaceWithText"));
        }
        LeafElement newLeaf = ASTFactory.leaf(this.getElementType(), newText);
        this.copyUserDataTo((UserDataHolderBase)newLeaf);
        this.rawReplaceWithList(newLeaf);
        newLeaf.clearCaches();
        LeafElement leafElement = newLeaf;
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafElement", "rawReplaceWithText"));
        }
        return leafElement;
    }

    @NotNull
    public LeafElement replaceWithText(@NotNull String newText) {
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/psi/impl/source/tree/LeafElement", "replaceWithText"));
        }
        LeafElement newLeaf = ChangeUtil.copyLeafWithText(this, newText);
        this.getTreeParent().replaceChild(this, newLeaf);
        LeafElement leafElement = newLeaf;
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafElement", "replaceWithText"));
        }
        return leafElement;
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        return this;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence buf, int start, int end) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/psi/impl/source/tree/LeafElement", "textMatches"));
        }
        CharSequence text = this.getChars();
        int len = text.length();
        if (end - start != len) {
            return false;
        }
        if (buf == text) {
            return true;
        }
        if (len > 5 && text instanceof String && buf instanceof String) {
            return ((String)text).regionMatches(0, (String)buf, start, len);
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (text.charAt(i2) == buf.charAt(start + i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void acceptTree(TreeElementVisitor visitor) {
        visitor.visitLeaf(this);
    }

    public ASTNode findChildByType(IElementType type) {
        return null;
    }

    public ASTNode findChildByType(IElementType type, @Nullable ASTNode anchor) {
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet) {
        if (typesSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesSet", "com/intellij/psi/impl/source/tree/LeafElement", "findChildByType"));
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, @Nullable ASTNode anchor) {
        if (typesSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesSet", "com/intellij/psi/impl/source/tree/LeafElement", "findChildByType"));
        }
        return null;
    }

    @Override
    public int hc() {
        return LeafElement.leafHC(this.getChars());
    }

    static int leafHC(CharSequence text) {
        int len = text.length();
        int hc = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            hc += text.charAt(i2);
        }
        return hc;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return null;
    }

    @Override
    public TreeElement getLastChildNode() {
        return null;
    }

    @Override
    public int getNotCachedLength() {
        return this.myText.length();
    }

    @Override
    public int getCachedLength() {
        return this.getNotCachedLength();
    }

    @NotNull
    public ASTNode[] getChildren(TokenSet filter) {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafElement", "getChildren"));
        }
        return EMPTY_ARRAY;
    }

    public void addChild(@NotNull ASTNode child, ASTNode anchorBefore) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/LeafElement", "addChild"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leafType", "com/intellij/psi/impl/source/tree/LeafElement", "addLeaf"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/LeafElement", "addChild"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/LeafElement", "removeChild"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldChild", "com/intellij/psi/impl/source/tree/LeafElement", "replaceChild"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/intellij/psi/impl/source/tree/LeafElement", "replaceChild"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void replaceAllChildrenToChildrenOf(ASTNode anotherParent) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/tree/LeafElement", "removeRange"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void addChildren(ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public PsiElement getPsi() {
        return null;
    }

    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/psi/impl/source/tree/LeafElement", "getPsi"));
        }
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    static <T extends PsiElement> T getPsi(@NotNull Class<T> clazz, PsiElement element, Logger log) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/psi/impl/source/tree/LeafElement", "getPsi"));
        }
        log.assertTrue(clazz.isInstance(element), (Object)("unexpected psi class. expected: " + clazz + " got: " + (element == null ? null : element.getClass())));
        return (T)element;
    }
}

