/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightTreeUtil {
    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull IElementType type) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        if (node == null) {
            return null;
        }
        List children2 = tree.getChildren(node);
        for (int i2 = 0; i2 < children2.size(); ++i2) {
            LighterASTNode child = (LighterASTNode)children2.get(i2);
            if (child.getTokenType() != type) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull TokenSet types) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        if (node == null) {
            return null;
        }
        List children2 = tree.getChildren(node);
        for (int i2 = 0; i2 < children2.size(); ++i2) {
            LighterASTNode child = (LighterASTNode)children2.get(i2);
            if (!types.contains(child.getTokenType())) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, type);
        assert (child != null) : "Required child " + type + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        LighterASTNode lighterASTNode = child;
        if (lighterASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        return lighterASTNode;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, types);
        assert (child != null) : "Required child " + types + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        LighterASTNode lighterASTNode = child;
        if (lighterASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        return lighterASTNode;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        SmartList result2 = null;
        List children2 = tree.getChildren(node);
        int size = children2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            LighterASTNode child = (LighterASTNode)children2.get(i2);
            if (child.getTokenType() != type) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add((LighterASTNode)child);
        }
        SmartList smartList = result2 != null ? result2 : Collections.emptyList();
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        return smartList;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        List children2 = tree.getChildren(node);
        SmartList result2 = null;
        int size = children2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            LighterASTNode child = (LighterASTNode)children2.get(i2);
            if (!types.contains(child.getTokenType())) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add((LighterASTNode)child);
        }
        SmartList smartList = result2 != null ? result2 : Collections.emptyList();
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        return smartList;
    }

    @NotNull
    public static String toFilteredString(@NotNull LighterAST tree, @NotNull LighterASTNode node, @Nullable TokenSet skipTypes) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "toFilteredString"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "toFilteredString"));
        }
        int length = node.getEndOffset() - node.getStartOffset();
        if (length < 0) {
            length = 0;
            Logger.getInstance(LightTreeUtil.class).error("tree=" + tree + " node=" + node);
        }
        StringBuilder buffer = new StringBuilder(length);
        LightTreeUtil.toBuffer(tree, node, buffer, skipTypes);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LightTreeUtil", "toFilteredString"));
        }
        return string;
    }

    public static void toBuffer(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StringBuilder buffer, @Nullable TokenSet skipTypes) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "toBuffer"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "toBuffer"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/tree/LightTreeUtil", "toBuffer"));
        }
        if (skipTypes != null && skipTypes.contains(node.getTokenType())) {
            return;
        }
        if (node instanceof LighterASTTokenNode) {
            buffer.append(((LighterASTTokenNode)node).getText());
            return;
        }
        if (node instanceof LighterLazyParseableNode) {
            buffer.append(((LighterLazyParseableNode)node).getText());
            return;
        }
        List children2 = tree.getChildren(node);
        int size = children2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            LightTreeUtil.toBuffer(tree, (LighterASTNode)children2.get(i2), buffer, skipTypes);
        }
    }

    @Nullable
    public static LighterASTNode getParentOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull TokenSet types, @NotNull TokenSet stopAt) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getParentOfType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getParentOfType"));
        }
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getParentOfType"));
        }
        if (node == null) {
            return null;
        }
        node = tree.getParent(node);
        while (node != null) {
            IElementType type = node.getTokenType();
            if (types.contains(type)) {
                return node;
            }
            if (stopAt.contains(type)) {
                return null;
            }
            node = tree.getParent(node);
        }
        return null;
    }

    @Nullable
    public static LighterASTNode findLeafElementAt(@NotNull LighterAST tree, int offset) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "findLeafElementAt"));
        }
        LighterASTNode eachNode = tree.getRoot();
        if (!LightTreeUtil.containsOffset(eachNode, offset)) {
            return null;
        }
        while (eachNode != null) {
            List children2 = tree.getChildren(eachNode);
            if (children2.isEmpty()) {
                return eachNode;
            }
            eachNode = LightTreeUtil.findChildAtOffset(offset, children2);
        }
        return null;
    }

    private static LighterASTNode findChildAtOffset(final int offset, List<LighterASTNode> children2) {
        return (LighterASTNode)ContainerUtil.find(children2, (Condition)new Condition<LighterASTNode>(){

            public boolean value(LighterASTNode node) {
                return LightTreeUtil.containsOffset(node, offset);
            }
        });
    }

    private static boolean containsOffset(LighterASTNode node, int offset) {
        return node.getStartOffset() <= offset && node.getEndOffset() > offset;
    }
}

