/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiNewExpressionImpl
extends ExpressionPsiElement
implements PsiNewExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiNewExpressionImpl");
    private static final TokenSet CLASS_REF = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.JAVA_CODE_REFERENCE, JavaElementType.ANONYMOUS_CLASS});

    public PsiNewExpressionImpl() {
        super(JavaElementType.NEW_EXPRESSION);
    }

    public PsiType getType() {
        return this.doGetType(null);
    }

    public PsiType getOwner(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "getOwner"));
        }
        assert (annotation.getParent() == this) : annotation.getParent() + " != " + this;
        return this.doGetType(annotation);
    }

    @Nullable
    private PsiType doGetType(@Nullable PsiAnnotation stopAt) {
        PsiClassReferenceType type = null;
        SmartList annotations = new SmartList();
        boolean stop2 = false;
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PsiElementFactory factory;
            IElementType elementType = child.getElementType();
            if (elementType == JavaElementType.ANNOTATION) {
                PsiAnnotation annotation = (PsiAnnotation)child.getPsi();
                annotations.add((Object)annotation);
                if (annotation != stopAt) continue;
                stop2 = true;
                continue;
            }
            if (elementType == JavaElementType.JAVA_CODE_REFERENCE) {
                assert (type == null) : this;
                type = new PsiClassReferenceType((PsiJavaCodeReferenceElement)child.getPsi(), null);
                if (!stop2) continue;
                return type;
            }
            if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(elementType)) {
                assert (type == null) : this;
                factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
                PsiAnnotation[] copy = (PsiAnnotation[])ContainerUtil.copyAndClear((Collection)annotations, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY, (boolean)true);
                type = factory.createPrimitiveTypeFromText(child.getText()).annotate(TypeAnnotationProvider.Static.create((PsiAnnotation[])copy));
                if (!stop2) continue;
                return type;
            }
            if (elementType == JavaTokenType.LBRACKET) {
                assert (type != null) : this;
                PsiAnnotation[] copy = (PsiAnnotation[])ContainerUtil.copyAndClear((Collection)annotations, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY, (boolean)true);
                type = type.createArrayType().annotate(TypeAnnotationProvider.Static.create((PsiAnnotation[])copy));
                if (!stop2) continue;
                return type;
            }
            if (elementType != JavaElementType.ANONYMOUS_CLASS) continue;
            factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            PsiClass aClass = (PsiClass)child.getPsi();
            PsiSubstitutor substitutor = aClass instanceof PsiTypeParameter ? PsiSubstitutor.EMPTY : factory.createRawSubstitutor((PsiTypeParameterListOwner)aClass);
            PsiAnnotation[] copy = (PsiAnnotation[])ContainerUtil.copyAndClear((Collection)annotations, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY, (boolean)true);
            type = factory.createType(aClass, substitutor, PsiUtil.getLanguageLevel((PsiElement)aClass)).annotate(TypeAnnotationProvider.Static.create((PsiAnnotation[])copy));
            if (!stop2) continue;
            return type;
        }
        return stop2 ? null : type;
    }

    public PsiExpressionList getArgumentList() {
        PsiExpressionList list = (PsiExpressionList)this.findChildByRoleAsPsiElement(73);
        if (list != null) {
            return list;
        }
        CompositeElement anonymousClass = (CompositeElement)SourceTreeToPsiMap.psiElementToTree(this.findChildByRoleAsPsiElement(70));
        if (anonymousClass != null) {
            return (PsiExpressionList)anonymousClass.findChildByRoleAsPsiElement(73);
        }
        return null;
    }

    @NotNull
    public PsiExpression[] getArrayDimensions() {
        PsiExpression[] expressions = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.ARRAY_DIMENSION_BIT_SET, PsiExpression.ARRAY_FACTORY);
        PsiExpression qualifier = this.getQualifier();
        if (qualifier == null) {
            if (expressions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "getArrayDimensions"));
            }
            return expressions;
        }
        LOG.assertTrue(expressions[0] == qualifier);
        PsiExpression[] expressions1 = new PsiExpression[expressions.length - 1];
        System.arraycopy(expressions, 1, expressions1, 0, expressions1.length);
        if (expressions1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "getArrayDimensions"));
        }
        return expressions1;
    }

    public PsiArrayInitializerExpression getArrayInitializer() {
        return (PsiArrayInitializerExpression)this.findChildByRoleAsPsiElement(77);
    }

    public PsiMethod resolveMethod() {
        return this.resolveConstructor();
    }

    public PsiPolyVariantCachingReference getConstructorFakeReference() {
        return new PsiPolyVariantCachingReference(){

            @NotNull
            public JavaResolveResult[] resolveInner(boolean incompleteCode, @NotNull PsiFile containingFile) {
                if (containingFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1", "resolveInner"));
                }
                ASTNode classRef = PsiNewExpressionImpl.this.findChildByRole(71);
                if (classRef != null) {
                    ASTNode argumentList = PsiImplUtil.skipWhitespaceAndComments(classRef.getTreeNext());
                    if (argumentList != null && argumentList.getElementType() == JavaElementType.EXPRESSION_LIST) {
                        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)containingFile.getProject());
                        PsiClassType aClass = facade.getElementFactory().createType((PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(classRef));
                        JavaResolveResult[] javaResolveResultArray = facade.getResolveHelper().multiResolveConstructor(aClass, (PsiExpressionList)SourceTreeToPsiMap.treeElementToPsi(argumentList), (PsiElement)PsiNewExpressionImpl.this);
                        if (javaResolveResultArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1", "resolveInner"));
                        }
                        return javaResolveResultArray;
                    }
                } else {
                    ASTNode anonymousClassElement = PsiNewExpressionImpl.this.findChildByType(JavaElementType.ANONYMOUS_CLASS);
                    if (anonymousClassElement != null) {
                        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)containingFile.getProject());
                        PsiAnonymousClass anonymousClass = (PsiAnonymousClass)SourceTreeToPsiMap.treeElementToPsi(anonymousClassElement);
                        PsiClassType aClass = anonymousClass.getBaseClassType();
                        ASTNode argumentList = anonymousClassElement.findChildByType(JavaElementType.EXPRESSION_LIST);
                        JavaResolveResult[] javaResolveResultArray = facade.getResolveHelper().multiResolveConstructor(aClass, (PsiExpressionList)SourceTreeToPsiMap.treeElementToPsi(argumentList), (PsiElement)anonymousClass);
                        if (javaResolveResultArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1", "resolveInner"));
                        }
                        return javaResolveResultArray;
                    }
                }
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1", "resolveInner"));
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }

            public PsiElement getElement() {
                return PsiNewExpressionImpl.this;
            }

            public TextRange getRangeInElement() {
                return null;
            }

            @NotNull
            public String getCanonicalText() {
                throw new UnsupportedOperationException();
            }

            public PsiElement handleElementRename(String newElementName) {
                return null;
            }

            public PsiElement bindToElement(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1", "bindToElement"));
                }
                return null;
            }

            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            public int hashCode() {
                return this.getElement().hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof PsiPolyVariantCachingReference && this.getElement() == ((PsiReference)obj).getElement();
            }
        };
    }

    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        ResolveResult[] results = this.getConstructorFakeReference().multiResolve(false);
        JavaResolveResult javaResolveResult = results.length == 1 ? (JavaResolveResult)results[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "resolveMethodGenerics"));
        }
        return javaResolveResult;
    }

    public PsiExpression getQualifier() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(54);
    }

    @NotNull
    public PsiReferenceParameterList getTypeArgumentList() {
        PsiReferenceParameterList psiReferenceParameterList = (PsiReferenceParameterList)this.findChildByRoleAsPsiElement(246);
        if (psiReferenceParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "getTypeArgumentList"));
        }
        return psiReferenceParameterList;
    }

    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] psiTypeArray = this.getTypeArgumentList().getTypeArguments();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "getTypeArguments"));
        }
        return psiTypeArray;
    }

    public PsiMethod resolveConstructor() {
        return (PsiMethod)this.resolveMethodGenerics().getElement();
    }

    public PsiJavaCodeReferenceElement getClassReference() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(71);
    }

    public PsiAnonymousClass getAnonymousClass() {
        ASTNode anonymousClass = this.findChildByType(JavaElementType.ANONYMOUS_CLASS);
        if (anonymousClass == null) {
            return null;
        }
        return (PsiAnonymousClass)SourceTreeToPsiMap.treeElementToPsi(anonymousClass);
    }

    @Nullable
    public PsiJavaCodeReferenceElement getClassOrAnonymousClassReference() {
        ASTNode ref = this.findChildByType(CLASS_REF);
        if (ref == null) {
            return null;
        }
        if (ref instanceof PsiJavaCodeReferenceElement) {
            return (PsiJavaCodeReferenceElement)ref;
        }
        PsiAnonymousClass anonymousClass = (PsiAnonymousClass)ref.getPsi();
        return anonymousClass.getBaseClassReference();
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "deleteChildInternal"));
        }
        if (this.getChildRole(child) == 54) {
            ASTNode dot = this.findChildByRole(55);
            super.deleteChildInternal(child);
            this.deleteChildInternal(dot);
        } else {
            super.deleteChildInternal(child);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 246: {
                return this.findChildByType(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            case 54: {
                TreeElement firstChild = this.getFirstChildNode();
                if (firstChild != null && firstChild.getElementType() != JavaTokenType.NEW_KEYWORD) {
                    return firstChild;
                }
                return null;
            }
            case 55: {
                return this.findChildByType(JavaTokenType.DOT);
            }
            case 69: {
                return this.findChildByType(JavaTokenType.NEW_KEYWORD);
            }
            case 70: {
                return this.findChildByType(JavaElementType.ANONYMOUS_CLASS);
            }
            case 71: {
                return this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
            }
            case 72: {
                return this.findChildByType(ElementType.PRIMITIVE_TYPE_BIT_SET);
            }
            case 73: {
                return this.findChildByType(JavaElementType.EXPRESSION_LIST);
            }
            case 74: {
                return this.findChildByType(JavaTokenType.LBRACKET);
            }
            case 75: {
                return this.findChildByType(JavaTokenType.RBRACKET);
            }
            case 77: 
        }
        if (this.getLastChildNode().getElementType() == JavaElementType.ARRAY_INITIALIZER_EXPRESSION) {
            return this.getLastChildNode();
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i2 == JavaTokenType.NEW_KEYWORD) {
            return 69;
        }
        if (i2 == JavaTokenType.DOT) {
            return 55;
        }
        if (i2 == JavaElementType.JAVA_CODE_REFERENCE) {
            return 71;
        }
        if (i2 == JavaElementType.EXPRESSION_LIST) {
            return 73;
        }
        if (i2 == JavaTokenType.LBRACKET) {
            return 74;
        }
        if (i2 == JavaTokenType.RBRACKET) {
            return 75;
        }
        if (i2 == JavaElementType.ARRAY_INITIALIZER_EXPRESSION) {
            if (child == this.getLastChildNode()) {
                return 77;
            }
            if (child == this.getFirstChildNode()) {
                return 54;
            }
            return 76;
        }
        if (i2 == JavaElementType.ANONYMOUS_CLASS) {
            return 70;
        }
        if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(child.getElementType())) {
            return 72;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return child == this.getFirstChildNode() ? 54 : 76;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitNewExpression((PsiNewExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiNewExpression:" + this.getText();
    }
}

