/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.BooleanStack;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.DefaultStubBuilder");

    public StubElement buildStubTree(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTree"));
        }
        return this.buildStubTreeFor((ASTNode)file2.getNode(), this.createStubForFile(file2));
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file2) {
        PsiFileStubImpl<PsiFile> stub;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/DefaultStubBuilder", "createStubForFile"));
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = stub = new PsiFileStubImpl<PsiFile>(file2);
        if (psiFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/DefaultStubBuilder", "createStubForFile"));
        }
        return psiFileStubImpl;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull PsiElement parent, @NotNull PsiElement element) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }

    @NotNull
    protected final StubElement buildStubTreeFor(@NotNull ASTNode root, @NotNull StubElement parentStub) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        if (parentStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentStub", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        new StubBuildingWalkingVisitor(root, parentStub).buildStubTree();
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        return stubElement;
    }

    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }

    protected class StubBuildingWalkingVisitor {
        private final Stack<StubElement> parentStubs = new Stack();
        private final Stack<ASTNode> parentNodes = new Stack();
        private final BooleanStack parentNodesStubbed = new BooleanStack();

        protected StubBuildingWalkingVisitor(ASTNode root, StubElement parentStub) {
            this.parentNodes.push((Object)root);
            this.parentStubs.push((Object)parentStub);
            this.parentNodesStubbed.push(true);
        }

        public final void buildStubTree() {
            while (!this.parentStubs.isEmpty()) {
                this.visitNode((StubElement)this.parentStubs.pop(), (ASTNode)this.parentNodes.pop(), this.parentNodesStubbed.pop());
            }
        }

        protected void visitNode(StubElement parentStub, ASTNode node, boolean immediateParentStubbed) {
            StubElement stub = this.createStub(parentStub, node);
            if (stub != null && !immediateParentStubbed) {
                ((ObjectStubBase)stub).markDangling();
            }
            this.pushChildren(node, node instanceof FileElement || stub != null, stub != null ? stub : parentStub);
        }

        @Nullable
        protected final ASTNode peekNextElement() {
            return this.parentNodes.isEmpty() ? null : (ASTNode)this.parentNodes.peek();
        }

        @Nullable
        private StubElement createStub(StubElement parentStub, ASTNode node) {
            IStubElementType type;
            IElementType nodeType = node.getElementType();
            if (nodeType instanceof IStubElementType && (type = (IStubElementType)nodeType).shouldCreateStub(node)) {
                PsiElement element = node.getPsi();
                if (!(element instanceof StubBasedPsiElement)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + element);
                }
                StubElement stub = type.createStub(element, parentStub);
                LOG.assertTrue(stub != null, (Object)element);
                return stub;
            }
            return null;
        }

        private void pushChildren(ASTNode node, boolean hasStub, StubElement stub) {
            for (ASTNode childNode = node.getLastChildNode(); childNode != null; childNode = childNode.getTreePrev()) {
                if (DefaultStubBuilder.this.skipChildProcessingWhenBuildingStubs(node, childNode)) continue;
                this.parentNodes.push((Object)childNode);
                this.parentStubs.push((Object)stub);
                this.parentNodesStubbed.push(hasStub);
            }
        }
    }
}

