/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.DetectedJavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetector;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaChangeSignatureDetector
implements LanguageChangeSignatureDetector<DetectedJavaChangeInfo> {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaChangeSignatureDetector.class.getName()));

    @Override
    @NotNull
    public DetectedJavaChangeInfo createInitialChangeInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector", "createInitialChangeInfo"));
        }
        DetectedJavaChangeInfo detectedJavaChangeInfo = DetectedJavaChangeInfo.createFromMethod((PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class), false);
        if (detectedJavaChangeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector", "createInitialChangeInfo"));
        }
        return detectedJavaChangeInfo;
    }

    @Override
    public void performChange(DetectedJavaChangeInfo changeInfo, Editor editor, @NotNull String oldText) {
        if (oldText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldText", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector", "performChange"));
        }
        changeInfo.perform(oldText, editor, true);
    }

    @Override
    public boolean isChangeSignatureAvailableOnElement(@NotNull PsiElement element, DetectedJavaChangeInfo currentInfo) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector", "isChangeSignatureAvailableOnElement"));
        }
        PsiMethod method2 = currentInfo.getMethod();
        TextRange range = method2.getTextRange();
        PsiCodeBlock body = method2.getBody();
        if (body != null) {
            range = new TextRange(range.getStartOffset(), body.getTextOffset());
        }
        return element.getContainingFile() == method2.getContainingFile() && range.contains(element.getTextRange());
    }

    @Override
    public boolean ignoreChanges(PsiElement element) {
        if (element instanceof PsiMethod) {
            return true;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportList.class) != null;
    }

    @Override
    public TextRange getHighlightingRange(@NotNull DetectedJavaChangeInfo changeInfo) {
        if (changeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeInfo", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector", "getHighlightingRange"));
        }
        PsiMethod method2 = changeInfo.getMethod();
        return method2 != null ? JavaChangeSignatureDetector.getSignatureRange(method2) : null;
    }

    @Override
    public String getMethodSignaturePreview(DetectedJavaChangeInfo initialChangeInfo, List<TextRange> deleteRanges, List<TextRange> newRanges) {
        CanonicalTypes.Type returnType;
        StringBuilder buf = new StringBuilder();
        String visibility = VisibilityUtil.getVisibilityString((String)initialChangeInfo.getNewVisibility());
        buf.append(visibility);
        if (!StringUtil.isEmptyOrSpaces((String)visibility)) {
            buf.append(" ");
        }
        if ((returnType = initialChangeInfo.getNewReturnType()) != null) {
            buf.append(returnType.getTypeText()).append(" ");
        }
        buf.append(initialChangeInfo.getNewName()).append("(");
        JavaParameterInfo[] newParameters = initialChangeInfo.getNewParameters();
        boolean first = true;
        boolean[] toRemove = initialChangeInfo.toRemoveParm();
        block0: for (int i2 = 0; i2 < toRemove.length; ++i2) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            String oldParamName = initialChangeInfo.getOldParameterNames()[i2];
            String oldParamType = initialChangeInfo.getOldParameterTypes()[i2];
            if (toRemove[i2]) {
                String deletedParam = oldParamType + " " + oldParamName;
                deleteRanges.add(new TextRange(buf.length(), buf.length() + deletedParam.length()));
                buf.append(deletedParam);
                continue;
            }
            for (JavaParameterInfo parameter : newParameters) {
                if (parameter.getOldIndex() != i2) continue;
                buf.append(parameter.getTypeText());
                buf.append(" ");
                if (!oldParamName.equals(parameter.getName())) {
                    deleteRanges.add(new TextRange(buf.length(), buf.length() + oldParamName.length()));
                    buf.append(oldParamName);
                }
                buf.append(parameter.getName());
                continue block0;
            }
        }
        for (JavaParameterInfo param : newParameters) {
            if (param.getOldIndex() != -1) continue;
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            String paramPresentation = param.getTypeText() + " " + (String)ObjectUtils.notNull((Object)param.getName(), (Object)"");
            newRanges.add(new TextRange(buf.length(), buf.length() + paramPresentation.length()));
            buf.append(paramPresentation);
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public FileType getFileType() {
        return JavaFileType.INSTANCE;
    }

    @Override
    public DetectedJavaChangeInfo createNextChangeInfo(String signature, @NotNull DetectedJavaChangeInfo currentInfo, boolean delegate) {
        if (currentInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentInfo", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector", "createNextChangeInfo"));
        }
        PsiMethod currentInfoMethod = currentInfo.getMethod();
        if (currentInfoMethod == null) {
            return null;
        }
        Project project2 = currentInfoMethod.getProject();
        PsiMethod oldMethod = currentInfo.getMethod();
        String visibility = "";
        PsiClass containingClass = oldMethod.getContainingClass();
        if (containingClass != null && containingClass.isInterface()) {
            visibility = "public ";
        }
        PsiMethod method2 = JavaPsiFacade.getElementFactory((Project)project2).createMethodFromText((visibility + signature).trim(), (PsiElement)oldMethod);
        return currentInfo.createNextInfo(method2, delegate);
    }

    public static TextRange getSignatureRange(PsiMethod method2) {
        int endOffset = method2.getThrowsList().getTextRange().getEndOffset();
        int startOffset = method2.getTextRange().getStartOffset();
        return new TextRange(startOffset, endOffset);
    }
}

