/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inheritanceToDelegation;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;

public class InheritanceToDelegationUtil {
    private InheritanceToDelegationUtil() {
    }

    public static boolean isInnerClassNeeded(PsiClass aClass, PsiClass baseClass) {
        PsiMethod[] methods;
        if (baseClass.isInterface()) {
            return true;
        }
        if (baseClass.hasModifierProperty("abstract")) {
            return true;
        }
        for (PsiMethod method2 : methods = aClass.getMethods()) {
            PsiClass containingClass;
            String qName;
            PsiMethod baseMethod;
            if (method2.isConstructor() || method2.hasModifierProperty("private") || (baseMethod = baseClass.findMethodBySignature(method2, true)) == null || (qName = (containingClass = baseMethod.getContainingClass()).getQualifiedName()) != null && "java.lang.Object".equals(qName)) continue;
            return true;
        }
        return false;
    }
}

