/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.ui;

import com.intellij.find.FindSettings;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.ui.EditorComboBox;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeMigrationDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance(TypeMigrationDialog.class);
    public static final String REFACTORING_NAME = "Type Migration";
    protected final PsiElement[] myRoots;
    private TypeMigrationRules myRules;
    private final ScopeChooserCombo myScopeChooserCombo;

    public TypeMigrationDialog(@NotNull Project project2, PsiElement[] roots, TypeMigrationRules rules) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/ui/TypeMigrationDialog", "<init>"));
        }
        super(project2, false);
        this.myRoots = roots;
        this.myRules = rules;
        this.myScopeChooserCombo = new ScopeChooserCombo(project2, false, true, FindSettings.getInstance().getDefaultScopeName());
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeChooserCombo);
        ((JComboBox)this.myScopeChooserCombo.getChildComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeMigrationDialog.this.validateButtons();
            }
        });
        this.setTitle(REFACTORING_NAME);
    }

    @Override
    protected void canRun() throws ConfigurationException {
        if (this.myScopeChooserCombo.getSelectedScope() == null) {
            throw new ConfigurationException("Scope is not chosen");
        }
    }

    @Override
    protected void doAction() {
        FindSettings.getInstance().setDefaultScopeName(this.myScopeChooserCombo.getSelectedScopeName());
        if (this.myRules == null) {
            this.myRules = new TypeMigrationRules();
            this.myRules.setBoundScope(this.myScopeChooserCombo.getSelectedScope());
        }
        this.invokeRefactoring(new TypeMigrationProcessor(this.myProject, this.myRoots, this.getMigrationTypeFunction(), this.myRules));
    }

    @NotNull
    protected abstract Function<PsiElement, PsiType> getMigrationTypeFunction();

    protected void appendMigrationTypeEditor(JPanel panel2, GridBagConstraints cs) {
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0);
        this.appendMigrationTypeEditor(panel2, gc);
        LabeledComponent scopeChooserComponent = new LabeledComponent();
        scopeChooserComponent.setComponent((JComponent)((Object)this.myScopeChooserCombo));
        scopeChooserComponent.setText("Choose scope where change signature may occur");
        panel2.add((Component)scopeChooserComponent, gc);
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myScopeChooserCombo;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.typeMigrationDialog");
    }

    public static class SingleElement
    extends TypeMigrationDialog {
        private final PsiTypeCodeFragment myTypeCodeFragment;
        private final EditorComboBox myToTypeEditor;

        public SingleElement(@NotNull Project project2, PsiElement[] roots, PsiType migrationType, TypeMigrationRules rules) {
            String[] stringArray;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/ui/TypeMigrationDialog$SingleElement", "<init>"));
            }
            super(project2, roots, rules);
            LOG.assertTrue(roots.length > 0);
            PsiType rootType = this.getRootType();
            String text = migrationType != null ? migrationType.getCanonicalText(true) : (rootType != null ? rootType.getCanonicalText(true) : "");
            int flags = 0;
            PsiElement root = roots[0];
            if (root instanceof PsiParameter) {
                PsiElement scope = ((PsiParameter)root).getDeclarationScope();
                if (scope instanceof PsiMethod) {
                    flags |= 2;
                } else if (scope instanceof PsiCatchSection && PsiUtil.getLanguageLevel((PsiElement)root).isAtLeast(LanguageLevel.JDK_1_7)) {
                    flags |= 4;
                }
            }
            this.myTypeCodeFragment = JavaCodeFragmentFactory.getInstance((Project)project2).createTypeCodeFragment(text, root, true, flags |= 1);
            final PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            final Document document = documentManager.getDocument((PsiFile)this.myTypeCodeFragment);
            assert (document != null);
            this.myToTypeEditor = new EditorComboBox(document, project2, (FileType)StdFileTypes.JAVA);
            String[] types = this.getValidTypes(project2, root);
            if (types != null) {
                stringArray = types;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = document.getText();
            }
            this.myToTypeEditor.setHistory(stringArray);
            document.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void documentChanged(DocumentEvent e) {
                    documentManager.commitDocument(document);
                    this.validateButtons();
                }
            });
            this.init();
        }

        @Override
        protected void canRun() throws ConfigurationException {
            super.canRun();
            if (!SingleElement.checkType(this.getMigrationType())) {
                throw new ConfigurationException("'" + this.myTypeCodeFragment.getText() + "' is invalid type");
            }
            if (this.isVoidVariableMigration()) {
                throw new ConfigurationException("'void' is not applicable");
            }
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            return this.myToTypeEditor;
        }

        @Override
        protected void appendMigrationTypeEditor(JPanel panel2, GridBagConstraints gc) {
            PsiType type = this.getRootType();
            String typeText = type != null ? type.getPresentableText() : "<unknown>";
            panel2.add((Component)new JLabel("Migrate " + SingleElement.getElementPresentation(this.myRoots[0]) + " \"" + typeText + "\" to"), gc);
            panel2.add((Component)this.myToTypeEditor, gc);
        }

        @Nullable
        private String[] getValidTypes(Project project2, PsiElement root) {
            PsiModifierList modifierList;
            if ((root instanceof PsiField || root instanceof PsiMethod) && VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)(modifierList = ((PsiModifierListOwner)root).getModifierList())), (String)"private") < 0) {
                return null;
            }
            ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)root, (SearchScope)GlobalSearchScope.fileScope((PsiFile)root.getContainingFile()))) {
                PsiElement element = reference.getElement();
                PsiExpression expr = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class, (boolean)false);
                if (expr == null) continue;
                expressions.add(expr);
            }
            try {
                PsiExpression[] occurrences = expressions.toArray(new PsiExpression[expressions.size()]);
                PsiType[] psiTypes = new TypeSelectorManagerImpl(project2, this.myTypeCodeFragment.getType(), occurrences).getTypesForAll();
                if (psiTypes.length > 0) {
                    String[] history = new String[psiTypes.length];
                    for (int i2 = 0; i2 < psiTypes.length; ++i2) {
                        PsiType psiType = psiTypes[i2];
                        history[i2] = psiType.getCanonicalText(true);
                    }
                    return history;
                }
            }
            catch (PsiTypeCodeFragment.NoTypeException | PsiTypeCodeFragment.TypeSyntaxException e) {
                LOG.info(e);
                return null;
            }
            return null;
        }

        @Override
        protected void doAction() {
            PsiType rootType = this.getRootType();
            PsiType migrationType = this.getMigrationType();
            if (migrationType == null || ChangeSignatureUtil.deepTypeEqual(rootType, migrationType)) {
                this.close(0);
                return;
            }
            super.doAction();
        }

        @Override
        @NotNull
        protected Function<PsiElement, PsiType> getMigrationTypeFunction() {
            Function function = Functions.constant((Object)this.getMigrationType());
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/ui/TypeMigrationDialog$SingleElement", "getMigrationTypeFunction"));
            }
            return function;
        }

        @Nullable
        public PsiType getMigrationType() {
            try {
                return this.myTypeCodeFragment.getType();
            }
            catch (PsiTypeCodeFragment.NoTypeException | PsiTypeCodeFragment.TypeSyntaxException e) {
                LOG.info(e);
                return null;
            }
        }

        @Nullable
        private PsiType getRootType() {
            return TypeMigrationLabeler.getElementType(this.myRoots[0]);
        }

        private static String getElementPresentation(PsiElement element) {
            if (element instanceof PsiMethod) {
                return "return type of method " + ((PsiMethod)element).getName();
            }
            if (element instanceof PsiField) {
                return "type of field " + ((PsiField)element).getName();
            }
            if (element instanceof PsiLocalVariable) {
                return "type of variable " + ((PsiLocalVariable)element).getName();
            }
            if (element instanceof PsiReferenceParameterList) {
                return "class type arguments ";
            }
            if (element instanceof PsiParameter) {
                PsiParameter param = (PsiParameter)element;
                String result2 = "type of parameter " + param.getName();
                if (param.getParent() instanceof PsiParameterList) {
                    PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)param, PsiMethod.class);
                    assert (method2 != null);
                    result2 = result2 + " of method " + method2.getName();
                }
                return result2;
            }
            return element.toString();
        }

        private boolean isVoidVariableMigration() {
            if (!PsiType.VOID.equals((Object)this.getMigrationType())) {
                return false;
            }
            for (PsiElement root : this.myRoots) {
                if (!(root instanceof PsiVariable)) continue;
                return true;
            }
            return false;
        }

        private static boolean checkType(PsiType type) {
            if (type == null) {
                return false;
            }
            if (!type.isValid()) {
                return false;
            }
            if (type instanceof PsiClassType) {
                PsiType[] types;
                PsiClassType psiClassType = (PsiClassType)type;
                if (psiClassType.resolve() == null) {
                    return false;
                }
                for (PsiType paramType : types = psiClassType.getParameters()) {
                    if (paramType instanceof PsiPrimitiveType || paramType instanceof PsiWildcardType && ((PsiWildcardType)paramType).getBound() instanceof PsiPrimitiveType) {
                        return false;
                    }
                    if (SingleElement.checkType(paramType)) continue;
                    return false;
                }
            }
            if (type instanceof PsiArrayType) {
                return SingleElement.checkType(type.getDeepComponentType());
            }
            return true;
        }
    }

    public static class MultipleElements
    extends TypeMigrationDialog {
        private final Function<PsiElement, PsiType> myMigrationTypeFunction;

        public MultipleElements(@NotNull Project project2, PsiElement[] roots, Function<PsiElement, PsiType> migrationTypeFunction, TypeMigrationRules rules) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/ui/TypeMigrationDialog$MultipleElements", "<init>"));
            }
            super(project2, roots, rules);
            this.myMigrationTypeFunction = migrationTypeFunction;
            this.init();
        }

        @Override
        @NotNull
        protected Function<PsiElement, PsiType> getMigrationTypeFunction() {
            Function<PsiElement, PsiType> function = this.myMigrationTypeFunction;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/ui/TypeMigrationDialog$MultipleElements", "getMigrationTypeFunction"));
            }
            return function;
        }
    }
}

