/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInspection.RedundantLambdaCodeBlockInspection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.util.Function;
import com.intellij.util.text.UniqueNameGenerator;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaRefactoringUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + LambdaRefactoringUtil.class.getName()));

    @Nullable
    public static PsiExpression convertToMethodCallInLambdaBody(PsiMethodReferenceExpression element) {
        PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda(element, false, true);
        return lambdaExpression != null ? LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambdaExpression.getBody()) : null;
    }

    @Nullable
    public static PsiLambdaExpression convertMethodReferenceToLambda(PsiMethodReferenceExpression referenceExpression, boolean ignoreCast, boolean simplifyToExpressionLambda) {
        PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertToLambda(referenceExpression, ignoreCast);
        if (lambdaExpression == null) {
            return null;
        }
        lambdaExpression = (PsiLambdaExpression)referenceExpression.replace((PsiElement)lambdaExpression);
        if (simplifyToExpressionLambda) {
            LambdaRefactoringUtil.simplifyToExpressionLambda(lambdaExpression);
        }
        return lambdaExpression;
    }

    public static boolean canConvertToLambda(PsiMethodReferenceExpression referenceExpression) {
        return LambdaRefactoringUtil.convertToLambda(referenceExpression, false) != null;
    }

    private static PsiLambdaExpression convertToLambda(PsiMethodReferenceExpression referenceExpression, boolean ignoreCast) {
        PsiParameterList typedParamList;
        boolean needToSpecifyFormalTypes;
        String lambda2 = LambdaRefactoringUtil.createLambdaWithoutFormalParameters(referenceExpression);
        if (lambda2 == null) {
            return null;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)referenceExpression.getProject());
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)elementFactory.createExpressionFromText(lambda2, (PsiElement)referenceExpression);
        PsiType functionalInterfaceType = referenceExpression.getFunctionalInterfaceType();
        boolean bl = needToSpecifyFormalTypes = !ignoreCast && !LambdaRefactoringUtil.isInferredSameTypeAfterConversion(lambdaExpression, referenceExpression, functionalInterfaceType);
        if (needToSpecifyFormalTypes && (typedParamList = LambdaRefactoringUtil.specifyLambdaParameterTypes(functionalInterfaceType, lambdaExpression)) == null) {
            return null;
        }
        return lambdaExpression;
    }

    private static String createLambdaWithoutFormalParameters(PsiMethodReferenceExpression referenceExpression) {
        boolean isReceiver;
        PsiType functionalInterfaceType = referenceExpression.getFunctionalInterfaceType();
        PsiElement resolve = referenceExpression.resolve();
        if (resolve == null) {
            return null;
        }
        PsiClassType.ClassResolveResult functionalInterfaceResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        if (interfaceMethod == null) {
            return null;
        }
        PsiSubstitutor psiSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)functionalInterfaceResolveResult);
        MethodSignature signature = interfaceMethod.getSignature(psiSubstitutor);
        if (resolve instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)resolve;
            isReceiver = PsiMethodReferenceUtil.isResolvedBySecondSearch((PsiMethodReferenceExpression)referenceExpression, (MethodSignature)signature, (boolean)method2.isVarArgs(), (boolean)method2.hasModifierProperty("static"), (int)method2.getParameterList().getParametersCount());
        } else {
            isReceiver = false;
        }
        PsiParameter[] psiParameters = resolve instanceof PsiMethod ? ((PsiMethod)resolve).getParameterList().getParameters() : null;
        PsiParameterList parameterList = interfaceMethod.getParameterList();
        Object[] parameters = parameterList.getParameters();
        HashMap map = new HashMap();
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)referenceExpression.getProject());
        Function paramPresentationFunction = parameter -> {
            String baseName;
            int parameterIndex = parameterList.getParameterIndex(parameter);
            if (isReceiver && parameterIndex == 0) {
                SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, psiSubstitutor.substitute(parameter.getType()));
                baseName = nameInfo.names.length > 0 ? nameInfo.names[0] : parameter.getName();
            } else {
                String initialName;
                if (psiParameters != null) {
                    int idx = parameterIndex - (isReceiver ? 1 : 0);
                    initialName = psiParameters.length > 0 ? psiParameters[idx < psiParameters.length ? idx : psiParameters.length - 1].getName() : parameter.getName();
                } else {
                    initialName = parameter.getName();
                }
                LOG.assertTrue(initialName != null);
                if ("_".equals(initialName)) {
                    SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, psiSubstitutor.substitute(parameter.getType()));
                    if (nameInfo.names.length > 0) {
                        initialName = nameInfo.names[0];
                    }
                }
                baseName = codeStyleManager.variableNameToPropertyName(initialName, VariableKind.PARAMETER);
            }
            if (baseName != null) {
                String parameterName = nameGenerator.generateUniqueName(codeStyleManager.suggestUniqueVariableName(baseName, (PsiElement)referenceExpression, true));
                map.put(parameter, parameterName);
                return parameterName;
            }
            return "";
        };
        StringBuilder buf = new StringBuilder();
        if (parameters.length == 1) {
            buf.append((String)paramPresentationFunction.fun((Object)parameters[0]));
        } else {
            buf.append("(").append(StringUtil.join((Object[])parameters, (Function)paramPresentationFunction, (String)", ")).append(")");
        }
        buf.append(" -> ");
        JavaResolveResult resolveResult = referenceExpression.advancedResolve(false);
        PsiElement resolveElement = resolveResult.getElement();
        if (resolveElement instanceof PsiMember) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)referenceExpression.getProject());
            buf.append("{");
            if (!PsiType.VOID.equals((Object)interfaceMethod.getReturnType())) {
                buf.append("return ");
            }
            PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)referenceExpression);
            PsiElement qualifier = referenceExpression.getQualifier();
            PsiClass containingClass = qualifierResolveResult.getContainingClass();
            boolean onArrayRef = elementFactory.getArrayClass(PsiUtil.getLanguageLevel((PsiElement)referenceExpression)) == containingClass;
            PsiElement referenceNameElement = referenceExpression.getReferenceNameElement();
            if (isReceiver) {
                buf.append((String)map.get(parameters[0])).append(".");
            } else if (!(referenceNameElement instanceof PsiKeyword)) {
                if (qualifier instanceof PsiTypeElement) {
                    PsiJavaCodeReferenceElement referenceElement = ((PsiTypeElement)qualifier).getInnermostComponentReferenceElement();
                    LOG.assertTrue(referenceElement != null);
                    if (!PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)referenceExpression, (boolean)false)) {
                        buf.append(referenceElement.getReferenceName()).append(".");
                    }
                } else if (qualifier != null && !LambdaRefactoringUtil.isQualifierUnnecessary(qualifier, containingClass)) {
                    buf.append(qualifier.getText()).append(".");
                }
            }
            buf.append(referenceExpression.getReferenceName());
            if (referenceNameElement instanceof PsiKeyword) {
                buf.append(" ");
                if (onArrayRef) {
                    if (qualifier instanceof PsiTypeElement) {
                        PsiType type = ((PsiTypeElement)qualifier).getType();
                        int dim = type.getArrayDimensions();
                        buf.append(type.getDeepComponentType().getCanonicalText());
                        buf.append("[");
                        buf.append((String)map.get(parameters[0]));
                        buf.append("]");
                        while (--dim > 0) {
                            buf.append("[]");
                        }
                    }
                } else {
                    buf.append(((PsiMember)resolveElement).getName());
                    PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                    LOG.assertTrue(containingClass != null);
                    if (containingClass.hasTypeParameters() && !PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)substitutor)) {
                        buf.append("<").append(StringUtil.join((Object[])containingClass.getTypeParameters(), parameter -> {
                            PsiType psiType = substitutor.substitute(parameter);
                            LOG.assertTrue(psiType != null);
                            return psiType.getCanonicalText();
                        }, (String)", ")).append(">");
                    }
                }
            }
            if (!onArrayRef || isReceiver) {
                int i2;
                buf.append("(");
                boolean first = true;
                int n = i2 = isReceiver ? 1 : 0;
                while (i2 < parameters.length) {
                    Object parameter2 = parameters[i2];
                    if (!first) {
                        buf.append(", ");
                    } else {
                        first = false;
                    }
                    buf.append((String)map.get(parameter2));
                    ++i2;
                }
                buf.append(")");
            }
            buf.append(";}");
        }
        return buf.toString();
    }

    private static boolean isQualifierUnnecessary(PsiElement qualifier, PsiClass containingClass) {
        PsiReferenceExpression reference;
        if (qualifier instanceof PsiReferenceExpression && (reference = (PsiReferenceExpression)qualifier).resolve() instanceof PsiClass && reference.getQualifier() == null && PsiTreeUtil.isContextAncestor((PsiElement)containingClass, (PsiElement)qualifier, (boolean)false)) {
            return true;
        }
        return qualifier instanceof PsiThisExpression && ((PsiThisExpression)qualifier).getQualifier() == null;
    }

    private static boolean isInferredSameTypeAfterConversion(PsiLambdaExpression lambdaExpression, PsiMethodReferenceExpression methodReferenceExpression, PsiType functionalInterfaceType) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodReferenceExpression.getParent());
        if (!(parent instanceof PsiExpressionList)) {
            return true;
        }
        PsiElement gParent = parent.getParent();
        if (gParent instanceof PsiCall) {
            if (gParent instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArguments().length > 0) {
                return true;
            }
            JavaResolveResult result2 = ((PsiCall)gParent).resolveMethodGenerics();
            if (result2 instanceof MethodCandidateInfo) {
                PsiMethod method2 = ((MethodCandidateInfo)result2).getElement();
                if (!method2.hasTypeParameters()) {
                    return true;
                }
                PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
                int lambdaIdx = LambdaUtil.getLambdaIdx((PsiExpressionList)((PsiExpressionList)parent), (PsiElement)methodReferenceExpression);
                args[lambdaIdx] = lambdaExpression;
                PsiParameter[] methodParams = method2.getParameterList().getParameters();
                PsiSubstitutor substitutor = ((MethodCandidateInfo)result2).inferTypeArguments((ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE, args, true);
                PsiType formalTargetType = substitutor.substitute(PsiTypesUtil.getParameterType((PsiParameter[])methodParams, (int)lambdaIdx, (boolean)((MethodCandidateInfo)result2).isVarargs()));
                return functionalInterfaceType.equals(FunctionalInterfaceParameterizationUtil.getGroundTargetType(formalTargetType));
            }
        }
        return false;
    }

    @Nullable
    public static String createLambdaParameterListWithFormalTypes(PsiType functionalInterfaceType, PsiLambdaExpression lambdaExpression, boolean checkApplicability) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        LOG.assertTrue(interfaceMethod != null);
        PsiParameter[] parameters = interfaceMethod.getParameterList().getParameters();
        PsiParameter[] lambdaParameters = lambdaExpression.getParameterList().getParameters();
        if (parameters.length != lambdaParameters.length) {
            return null;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult);
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            PsiType psiType = substitutor.substitute(parameters[i2].getType());
            if (psiType == null) {
                return null;
            }
            if (!PsiTypesUtil.isDenotableType((PsiType)psiType)) {
                return null;
            }
            buf.append(checkApplicability ? psiType.getPresentableText() : psiType.getCanonicalText()).append(" ").append(lambdaParameters[i2].getName());
            if (i2 >= parameters.length - 1) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    @Nullable
    public static PsiParameterList specifyLambdaParameterTypes(PsiLambdaExpression lambdaExpression) {
        return LambdaRefactoringUtil.specifyLambdaParameterTypes(lambdaExpression.getFunctionalInterfaceType(), lambdaExpression);
    }

    @Nullable
    public static PsiParameterList specifyLambdaParameterTypes(PsiType functionalInterfaceType, PsiLambdaExpression lambdaExpression) {
        String typedParamList = LambdaRefactoringUtil.createLambdaParameterListWithFormalTypes(functionalInterfaceType, lambdaExpression, false);
        if (typedParamList != null) {
            PsiParameterList paramListWithFormalTypes = JavaPsiFacade.getElementFactory((Project)lambdaExpression.getProject()).createMethodFromText("void foo" + typedParamList, (PsiElement)lambdaExpression).getParameterList();
            return (PsiParameterList)JavaCodeStyleManager.getInstance((Project)lambdaExpression.getProject()).shortenClassReferences(lambdaExpression.getParameterList().replace((PsiElement)paramListWithFormalTypes));
        }
        return null;
    }

    public static void simplifyToExpressionLambda(@NotNull PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "com/intellij/refactoring/util/LambdaRefactoringUtil", "simplifyToExpressionLambda"));
        }
        PsiElement body = lambdaExpression.getBody();
        PsiExpression singleExpression = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant(body);
        if (singleExpression != null) {
            body.replace((PsiElement)singleExpression);
        }
    }

    public static void removeSideEffectsFromLambdaBody(Editor editor, PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression != null && lambdaExpression.isValid()) {
            PsiElement body = lambdaExpression.getBody();
            PsiExpression methodCall = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body);
            PsiExpression qualifierExpression = null;
            if (methodCall instanceof PsiMethodCallExpression) {
                qualifierExpression = ((PsiMethodCallExpression)methodCall).getMethodExpression().getQualifierExpression();
            } else if (methodCall instanceof PsiNewExpression) {
                qualifierExpression = ((PsiNewExpression)methodCall).getQualifier();
            }
            if (qualifierExpression != null) {
                ArrayList<PsiElement> sideEffects = new ArrayList<PsiElement>();
                SideEffectChecker.checkSideEffects(qualifierExpression, sideEffects);
                if (!sideEffects.isEmpty() && (ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((Project)lambdaExpression.getProject(), (String)"There are possible side effects found in method reference qualifier.\nIntroduce local variable?", (String)"Side Effects Detected", (Icon)Messages.getQuestionIcon()) == 0)) {
                    qualifierExpression.putUserData(ElementToWorkOn.PARENT, (Object)lambdaExpression);
                    new IntroduceVariableHandler().invoke(qualifierExpression.getProject(), editor, qualifierExpression);
                }
            }
        }
    }

    public static boolean canConvertToLambdaWithoutSideEffects(PsiMethodReferenceExpression methodReferenceExpression) {
        PsiExpression qualifierExpression = methodReferenceExpression.getQualifierExpression();
        return qualifierExpression != null && !SideEffectChecker.mayHaveSideEffects(qualifierExpression);
    }
}

