/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.classMembers.DependentMembersCollectorBase;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;

public class DependentMembersCollector
extends DependentMembersCollectorBase<PsiMember, PsiClass> {
    public DependentMembersCollector(PsiClass clazz, PsiClass superClass) {
        super((Object)clazz, (Object)superClass);
    }

    public void collect(PsiMember member) {
        member.accept(this.getVisitor());
    }

    private PsiElementVisitor getVisitor() {
        return new ClassMemberReferencesVisitor((PsiClass)this.getClazz()){

            @Override
            protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
                if (!DependentMembersCollector.this.existsInSuperClass(classMember)) {
                    DependentMembersCollector.this.myCollection.add(classMember);
                }
            }
        };
    }

    private boolean existsInSuperClass(PsiMember classMember) {
        if (this.getSuperClass() == null) {
            return false;
        }
        if (!(classMember instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)classMember;
        PsiMethod methodBySignature = ((PsiClass)this.getSuperClass()).findMethodBySignature(method2, true);
        return methodBySignature != null;
    }
}

