/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeElement;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeReturnType
extends FixableUsageInfo {
    private final PsiMethod myMethod;
    private final String myType;

    public ChangeReturnType(@NotNull PsiMethod method2, @NotNull String type) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/wrapreturnvalue/usageInfo/ChangeReturnType", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/refactoring/wrapreturnvalue/usageInfo/ChangeReturnType", "<init>"));
        }
        super((PsiElement)method2);
        this.myMethod = method2;
        this.myType = type;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        PsiTypeElement returnType = this.myMethod.getReturnTypeElement();
        assert (returnType != null) : this.myMethod;
        MutationUtils.replaceType(this.myType, returnType);
    }
}

