/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.semantic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemContributorEP;
import com.intellij.semantic.SemElement;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SemServiceImpl
extends SemService {
    private final ConcurrentMap<PsiElement, SemCacheChunk> myCache = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private volatile MultiMap<SemKey, NullableFunction<PsiElement, ? extends SemElement>> myProducers;
    private final Project myProject;
    private boolean myBulkChange = false;
    private final AtomicInteger myCreatingSem = new AtomicInteger(0);

    public SemServiceImpl(Project project2, PsiManager psiManager) {
        this.myProject = project2;
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                if (!SemServiceImpl.this.isInsideAtomicChange()) {
                    SemServiceImpl.this.clearCache();
                }
            }
        });
        ((PsiManagerEx)psiManager).registerRunnableToRunOnChange(() -> {
            if (!this.isInsideAtomicChange()) {
                this.clearCache();
            }
        });
        LowMemoryWatcher.register(() -> {
            if (this.myCreatingSem.get() == 0) {
                this.clearCache();
            }
        }, (Disposable)project2);
    }

    private MultiMap<SemKey, NullableFunction<PsiElement, ? extends SemElement>> collectProducers() {
        final MultiMap map = MultiMap.createSmart();
        SemRegistrar registrar = new SemRegistrar(){

            public <T extends SemElement, V extends PsiElement> void registerSemElementProvider(SemKey<T> key2, ElementPattern<? extends V> place, NullableFunction<V, T> provider) {
                map.putValue(key2, element -> {
                    if (place.accepts(element)) {
                        return (SemElement)provider.fun(element);
                    }
                    return null;
                });
            }
        };
        for (SemContributorEP contributor : (SemContributorEP[])this.myProject.getExtensions(SemContributor.EP_NAME)) {
            contributor.registerSemProviders(this.myProject.getPicoContainer(), registrar);
        }
        return map;
    }

    public void clearCache() {
        this.myCache.clear();
    }

    public void performAtomicChange(@NotNull Runnable change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/semantic/SemServiceImpl", "performAtomicChange"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean oldValue = this.myBulkChange;
        this.myBulkChange = true;
        try {
            change.run();
        }
        finally {
            this.myBulkChange = oldValue;
            if (!oldValue) {
                this.clearCache();
            }
        }
    }

    public boolean isInsideAtomicChange() {
        return this.myBulkChange;
    }

    @Nullable
    public <T extends SemElement> List<T> getSemElements(SemKey<T> key2, @NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/semantic/SemServiceImpl", "getSemElements"));
        }
        List<T> cached = this._getCachedSemElements(key2, true, psi);
        if (cached != null) {
            return cached;
        }
        this.ensureInitialized();
        RecursionGuard.StackStamp stamp = RecursionManager.createGuard((String)"semService").markStack();
        LinkedHashSet<SemElement> result2 = new LinkedHashSet<SemElement>();
        THashMap map = new THashMap();
        for (SemKey each : key2.getInheritors()) {
            List<SemElement> list = this.createSemElements(each, psi);
            map.put(each, list);
            result2.addAll(list);
        }
        if (stamp.mayCacheNow()) {
            SemCacheChunk persistent = this.getOrCreateChunk(psi);
            for (SemKey semKey : map.keySet()) {
                persistent.putSemElements(semKey, (List)map.get(semKey));
            }
        }
        return new ArrayList(result2);
    }

    private void ensureInitialized() {
        if (this.myProducers == null) {
            this.myProducers = this.collectProducers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<SemElement> createSemElements(SemKey key2, PsiElement psi) {
        List result2 = null;
        Collection producers = this.myProducers.get((Object)key2);
        if (!producers.isEmpty()) {
            for (NullableFunction producer : producers) {
                this.myCreatingSem.incrementAndGet();
                try {
                    SemElement element = (SemElement)producer.fun((Object)psi);
                    if (element == null) continue;
                    if (result2 == null) {
                        result2 = new SmartList();
                    }
                    result2.add(element);
                }
                finally {
                    this.myCreatingSem.decrementAndGet();
                }
            }
        }
        List<Object> list = result2 == null ? Collections.emptyList() : Collections.unmodifiableList(result2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/semantic/SemServiceImpl", "createSemElements"));
        }
        return list;
    }

    @Nullable
    public <T extends SemElement> List<T> getCachedSemElements(SemKey<T> key2, @NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/semantic/SemServiceImpl", "getCachedSemElements"));
        }
        return this._getCachedSemElements(key2, false, psi);
    }

    @Nullable
    private <T extends SemElement> List<T> _getCachedSemElements(SemKey<T> key2, boolean paranoid, PsiElement element) {
        SemCacheChunk chunk = this.obtainChunk(element);
        if (chunk == null) {
            return null;
        }
        List<SemElement> singleList = null;
        LinkedHashSet<SemElement> result2 = null;
        List inheritors = key2.getInheritors();
        for (int i2 = 0; i2 < inheritors.size(); ++i2) {
            List<SemElement> cached = chunk.getSemElements((SemKey)inheritors.get(i2));
            if (cached == null && paranoid) {
                return null;
            }
            if (cached == null || cached == Collections.emptyList()) continue;
            if (singleList == null) {
                singleList = cached;
                continue;
            }
            if (result2 == null) {
                result2 = new LinkedHashSet<SemElement>(singleList);
            }
            result2.addAll(cached);
        }
        if (result2 == null) {
            if (singleList != null) {
                return singleList;
            }
            return Collections.emptyList();
        }
        return new ArrayList(result2);
    }

    @Nullable
    private SemCacheChunk obtainChunk(@Nullable PsiElement root) {
        return (SemCacheChunk)this.myCache.get(root);
    }

    public <T extends SemElement> void setCachedSemElement(SemKey<T> key2, @NotNull PsiElement psi, @Nullable T semElement) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/semantic/SemServiceImpl", "setCachedSemElement"));
        }
        this.getOrCreateChunk(psi).putSemElements(key2, ContainerUtil.createMaybeSingletonList(semElement));
    }

    public void clearCachedSemElements(@NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/semantic/SemServiceImpl", "clearCachedSemElements"));
        }
        this.myCache.remove(psi);
    }

    private SemCacheChunk getOrCreateChunk(PsiElement element) {
        SemCacheChunk chunk = this.obtainChunk(element);
        if (chunk == null) {
            chunk = (SemCacheChunk)ConcurrencyUtil.cacheOrGet(this.myCache, (Object)element, (Object)new SemCacheChunk());
        }
        return chunk;
    }

    private static class SemCacheChunk {
        private final ConcurrentIntObjectMap<List<SemElement>> map = ContainerUtil.createConcurrentIntObjectMap();

        private SemCacheChunk() {
        }

        public List<SemElement> getSemElements(SemKey<?> key2) {
            return (List)this.map.get(key2.getUniqueId());
        }

        public void putSemElements(SemKey<?> key2, List<SemElement> elements) {
            this.map.put(key2.getUniqueId(), elements);
        }

        public int hashCode() {
            return 0;
        }
    }
}

