/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.util.SPFileUtil;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.spellchecker.util.Strings;
import com.intellij.ui.AddDeleteListPanel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OptionalChooserComponent;
import com.intellij.ui.PathsChooserComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellCheckerSettingsPane
implements Disposable {
    private JPanel root;
    private JPanel linkContainer;
    private JPanel panelForDictionaryChooser;
    private JPanel panelForAcceptedWords;
    private JPanel panelForFolderChooser;
    private OptionalChooserComponent<String> optionalChooserComponent;
    private PathsChooserComponent pathsChooserComponent;
    private final List<Pair<String, Boolean>> allDictionaries;
    private final List<String> dictionariesFolders;
    private final List<String> removedDictionaries;
    private final WordsPanel wordsPanel;
    private final SpellCheckerManager manager;
    private final SpellCheckerSettings settings;

    public SpellCheckerSettingsPane(SpellCheckerSettings settings, Project project2) {
        this.$$$setupUI$$$();
        this.allDictionaries = new ArrayList<Pair<String, Boolean>>();
        this.dictionariesFolders = new ArrayList<String>();
        this.removedDictionaries = new ArrayList<String>();
        this.settings = settings;
        this.manager = SpellCheckerManager.getInstance(project2);
        HyperlinkLabel link = new HyperlinkLabel(SpellCheckerBundle.message("link.to.inspection.settings", new Object[0]));
        link.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                ErrorsConfigurable errorsConfigurable;
                Settings allSettings;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext())) != null && (errorsConfigurable = allSettings.find(ErrorsConfigurable.class)) != null) {
                    allSettings.select(errorsConfigurable).doWhenDone(() -> errorsConfigurable.selectInspectionTool("SpellCheckingInspection"));
                }
            }
        });
        this.linkContainer.setLayout(new BorderLayout());
        this.linkContainer.add((Component)link);
        this.fillAllDictionaries();
        this.pathsChooserComponent = new PathsChooserComponent(this.dictionariesFolders, new PathsChooserComponent.PathProcessor(){

            public boolean addPath(List<String> paths, String path) {
                if (paths.contains(path)) {
                    String title = SpellCheckerBundle.message("add.directory.title", new Object[0]);
                    String msg = SpellCheckerBundle.message("directory.is.already.included", new Object[0]);
                    Messages.showErrorDialog((Component)SpellCheckerSettingsPane.this.root, (String)msg, (String)title);
                    return false;
                }
                paths.add(path);
                ArrayList currentDictionaries = SpellCheckerSettingsPane.this.optionalChooserComponent.getCurrentModel();
                SPFileUtil.processFilesRecursively(path, (Consumer<String>)((Consumer)s -> currentDictionaries.add(Pair.create((Object)s, (Object)true))));
                SpellCheckerSettingsPane.this.optionalChooserComponent.refresh();
                return true;
            }

            public boolean removePath(List<String> paths, String path) {
                if (paths.remove(path)) {
                    ArrayList<Pair> result2 = new ArrayList<Pair>();
                    ArrayList currentDictionaries = SpellCheckerSettingsPane.this.optionalChooserComponent.getCurrentModel();
                    for (Pair pair : currentDictionaries) {
                        if (!((String)pair.first).startsWith(FileUtil.toSystemDependentName((String)path))) {
                            result2.add(pair);
                            continue;
                        }
                        SpellCheckerSettingsPane.this.removedDictionaries.add(pair.first);
                    }
                    currentDictionaries.clear();
                    currentDictionaries.addAll(result2);
                    SpellCheckerSettingsPane.this.optionalChooserComponent.refresh();
                    return true;
                }
                return false;
            }
        }, project2);
        this.panelForFolderChooser.setLayout(new BorderLayout());
        this.panelForFolderChooser.add((Component)this.pathsChooserComponent.getContentPane(), "Center");
        this.pathsChooserComponent.getEmptyText().setText(SpellCheckerBundle.message("no.custom.folders", new Object[0]));
        this.optionalChooserComponent = new OptionalChooserComponent<String>(this.allDictionaries){

            public JCheckBox createCheckBox(String path, boolean checked) {
                int i2;
                if (SpellCheckerSettingsPane.this.isUserDictionary(path) && (i2 = (path = FileUtil.toSystemIndependentName((String)path)).lastIndexOf(47)) != -1) {
                    String name = path.substring(i2 + 1);
                    return new JCheckBox("[user] " + name, checked);
                }
                return new JCheckBox("[bundled] " + FileUtil.toSystemDependentName((String)path), checked);
            }
        };
        this.panelForDictionaryChooser.setLayout(new BorderLayout());
        this.panelForDictionaryChooser.add((Component)this.optionalChooserComponent.getContentPane(), "Center");
        this.optionalChooserComponent.getEmptyText().setText(SpellCheckerBundle.message("no.dictionaries", new Object[0]));
        this.wordsPanel = new WordsPanel(this.manager);
        this.panelForAcceptedWords.setLayout(new BorderLayout());
        this.panelForAcceptedWords.add((Component)((Object)this.wordsPanel), "Center");
    }

    public JComponent getPane() {
        return this.root;
    }

    public boolean isModified() {
        return this.wordsPanel.isModified() || this.optionalChooserComponent.isModified() || this.pathsChooserComponent.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.wordsPanel.isModified()) {
            this.manager.updateUserDictionary(this.wordsPanel.getWords());
        }
        if (!this.optionalChooserComponent.isModified() && !this.pathsChooserComponent.isModified()) {
            return;
        }
        this.optionalChooserComponent.apply();
        this.pathsChooserComponent.apply();
        this.settings.setDictionaryFoldersPaths(this.pathsChooserComponent.getValues());
        HashSet<String> disabledDictionaries = new HashSet<String>();
        HashSet<String> bundledDisabledDictionaries = new HashSet<String>();
        for (Pair<String, Boolean> pair : this.allDictionaries) {
            if (((Boolean)pair.second).booleanValue()) continue;
            String scriptPath = (String)pair.first;
            if (this.isUserDictionary(scriptPath)) {
                disabledDictionaries.add(scriptPath);
                continue;
            }
            bundledDisabledDictionaries.add(scriptPath);
        }
        this.settings.setDisabledDictionariesPaths(disabledDictionaries);
        this.settings.setBundledDisabledDictionariesPaths(bundledDisabledDictionaries);
        this.manager.updateBundledDictionaries(this.removedDictionaries);
    }

    private boolean isUserDictionary(String dictionary) {
        boolean isUserDictionary = false;
        for (String dictionaryFolder : this.pathsChooserComponent.getValues()) {
            if (!FileUtil.toSystemIndependentName((String)dictionary).startsWith(dictionaryFolder)) continue;
            isUserDictionary = true;
            break;
        }
        return isUserDictionary;
    }

    public void reset() {
        this.pathsChooserComponent.reset();
        this.fillAllDictionaries();
        this.optionalChooserComponent.reset();
        this.removedDictionaries.clear();
    }

    private void fillAllDictionaries() {
        this.dictionariesFolders.clear();
        this.dictionariesFolders.addAll(this.settings.getDictionaryFoldersPaths());
        this.allDictionaries.clear();
        for (String dictionary : SpellCheckerManager.getBundledDictionaries()) {
            this.allDictionaries.add((Pair<String, Boolean>)Pair.create((Object)dictionary, (Object)(!this.settings.getBundledDisabledDictionariesPaths().contains(dictionary) ? 1 : 0)));
        }
        Set<String> disabledDictionaries = this.settings.getDisabledDictionariesPaths();
        for (String folder : this.dictionariesFolders) {
            SPFileUtil.processFilesRecursively(folder, (Consumer<String>)((Consumer)s -> this.allDictionaries.add((Pair<String, Boolean>)Pair.create((Object)s, (Object)(!disabledDictionaries.contains(s) ? 1 : 0)))));
        }
    }

    public void dispose() {
        if (this.wordsPanel != null) {
            this.wordsPanel.dispose();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.root = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        this.linkContainer = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(24, 38), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jPanel7.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(200, 200), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Accepted Words", null, jPanel8, null);
        this.panelForAcceptedWords = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Dictionaries", null, jPanel9, null);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel9.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel10.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("dictionaries.panel.title"), (int)0, (int)0, null, null));
        this.panelForDictionaryChooser = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("dictionaries.panel.description"));
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jPanel10.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel9.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel11.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("add.directory.title"), (int)0, (int)0, null, null));
        this.panelForFolderChooser = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("com/intellij/spellchecker/util/SpellCheckerBundle").getString("add.directory.description"));
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jPanel11.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class WordsPanel
    extends AddDeleteListPanel
    implements Disposable {
        private final SpellCheckerManager manager;

        private WordsPanel(SpellCheckerManager manager) {
            super(null, new WordDescriber(manager.getUserDictionary()).process());
            this.manager = manager;
            this.getEmptyText().setText(SpellCheckerBundle.message("no.words", new Object[0]));
        }

        protected Object findItemToAdd() {
            String word = Messages.showInputDialog((String)SpellCheckerBundle.message("enter.simple.word", new Object[0]), (String)SpellCheckerBundle.message("add.new.word", new Object[0]), null);
            if (word == null) {
                return null;
            }
            if (Strings.isMixedCase(word = word.trim())) {
                Messages.showWarningDialog((String)SpellCheckerBundle.message("entered.word.0.is.mixed.cased.you.must.enter.simple.word", word), (String)SpellCheckerBundle.message("add.new.word", new Object[0]));
                return null;
            }
            if (!this.manager.hasProblem(word)) {
                Messages.showWarningDialog((String)SpellCheckerBundle.message("entered.word.0.is.correct.you.no.need.to.add.this.in.list", word), (String)SpellCheckerBundle.message("add.new.word", new Object[0]));
                return null;
            }
            return word;
        }

        public void dispose() {
            this.myListModel.removeAllElements();
        }

        @Nullable
        public List<String> getWords() {
            Object[] pairs = this.getListItems();
            if (pairs == null) {
                return null;
            }
            ArrayList<String> words = new ArrayList<String>();
            for (Object pair : pairs) {
                words.add(pair.toString());
            }
            return words;
        }

        public boolean isModified() {
            List<String> newWords = this.getWords();
            Set<String> words = this.manager.getUserDictionary().getEditableWords();
            if (words == null && newWords == null) {
                return false;
            }
            if (words == null || newWords == null || newWords.size() != words.size()) {
                return true;
            }
            return !words.containsAll(newWords) || !newWords.containsAll(words);
        }
    }

    public static final class WordDescriber {
        private final EditableDictionary dictionary;

        public WordDescriber(EditableDictionary dictionary) {
            this.dictionary = dictionary;
        }

        @NotNull
        public List<String> process() {
            if (this.dictionary == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/settings/SpellCheckerSettingsPane$WordDescriber", "process"));
                }
                return arrayList;
            }
            Set<String> words = this.dictionary.getEditableWords();
            if (words == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/settings/SpellCheckerSettingsPane$WordDescriber", "process"));
                }
                return arrayList;
            }
            ArrayList<String> result2 = new ArrayList<String>();
            for (String word : words) {
                result2.add(word);
            }
            Collections.sort(result2);
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/settings/SpellCheckerSettingsPane$WordDescriber", "process"));
            }
            return arrayList;
        }
    }
}

