/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.util.DebugReflectionUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.Queue;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntHashSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeakHunter {
    private static final Key<Boolean> IS_NOT_A_LEAK = Key.create((String)"IS_NOT_A_LEAK");
    private static final Key<Boolean> REPORTED_LEAKED = Key.create((String)"REPORTED_LEAKED");

    private static void walkObjects(@NotNull Class<?> lookFor, @NotNull Collection<Object> startRoots, @NotNull Processor<DebugReflectionUtil.BackLink> leakProcessor) {
        if (lookFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookFor", "com/intellij/testFramework/LeakHunter", "walkObjects"));
        }
        if (startRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startRoots", "com/intellij/testFramework/LeakHunter", "walkObjects"));
        }
        if (leakProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leakProcessor", "com/intellij/testFramework/LeakHunter", "walkObjects"));
        }
        TIntHashSet visited = new TIntHashSet();
        Queue toVisit = new Queue(1000000);
        for (Object startRoot : startRoots) {
            toVisit.addLast((Object)new DebugReflectionUtil.BackLink(startRoot, null, null));
        }
        while (!toVisit.isEmpty()) {
            DebugReflectionUtil.BackLink backLink = (DebugReflectionUtil.BackLink)toVisit.pullFirst();
            Object root = backLink.value;
            if (!visited.add(System.identityHashCode(root))) continue;
            DebugReflectionUtil.processStronglyReferencedValues(root, (PairProcessor<Object, Field>)((PairProcessor)(value, field) -> {
                if (lookFor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookFor", "com/intellij/testFramework/LeakHunter", "lambda$walkObjects$0"));
                }
                if (leakProcessor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leakProcessor", "com/intellij/testFramework/LeakHunter", "lambda$walkObjects$0"));
                }
                Class<?> valueClass = value.getClass();
                if (lookFor.isAssignableFrom(valueClass) && LeakHunter.isReallyLeak(value)) {
                    leakProcessor.process((Object)new DebugReflectionUtil.BackLink(value, (Field)field, backLink));
                } else {
                    toVisit.addLast((Object)new DebugReflectionUtil.BackLink(value, (Field)field, backLink));
                }
                return true;
            }));
        }
        return;
    }

    public static void markAsNotALeak(@NotNull UserDataHolder object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/testFramework/LeakHunter", "markAsNotALeak"));
        }
        object.putUserData(IS_NOT_A_LEAK, (Object)Boolean.TRUE);
    }

    private static boolean isReallyLeak(Object value) {
        return !(value instanceof UserDataHolder) || ((UserDataHolder)value).getUserData(IS_NOT_A_LEAK) == null;
    }

    public static void checkProjectLeak() throws Exception {
        Processor isReallyLeak = project2 -> !project2.isDefault() && !((ProjectImpl)project2).isLight();
        ArrayList<Object> roots = new ArrayList<Object>(LeakHunter.allRoots());
        ClassLoader classLoader = LeakHunter.class.getClassLoader();
        Vector allLoadedClasses = (Vector)ReflectionUtil.getField(classLoader.getClass(), (Object)classLoader, Vector.class, (String)"classes");
        roots.addAll(allLoadedClasses);
        LeakHunter.checkLeak(roots, ProjectImpl.class, isReallyLeak);
    }

    public static void checkLeak(@NotNull Object root, @NotNull Class suspectClass) throws AssertionError {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        if (suspectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspectClass", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        LeakHunter.checkLeak(root, suspectClass, null);
    }

    public static <T> void checkLeak(@NotNull Collection<Object> roots, @NotNull Class<T> suspectClass, final @Nullable Processor<? super T> isReallyLeak) throws AssertionError {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        if (suspectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspectClass", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        if (SwingUtilities.isEventDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
        PersistentEnumeratorBase.clearCacheForTests();
        LeakHunter.walkObjects(suspectClass, roots, new Processor<DebugReflectionUtil.BackLink>(){

            public boolean process(DebugReflectionUtil.BackLink backLink) {
                Object leaked = backLink.value;
                if (this.markLeaked(leaked) && (isReallyLeak == null || isReallyLeak.process(leaked))) {
                    String place = leaked instanceof Project ? PlatformTestCase.getCreationPlace((Project)leaked) : "";
                    System.out.println("Leaked object found:" + leaked + "; hash: " + System.identityHashCode(leaked) + "; place: " + place);
                    System.out.println(backLink);
                    System.out.println(";-----");
                    throw new AssertionError();
                }
                return true;
            }

            private boolean markLeaked(T leaked) {
                return !(leaked instanceof UserDataHolderEx) || ((UserDataHolderEx)leaked).replace(REPORTED_LEAKED, null, (Object)Boolean.TRUE);
            }
        });
    }

    public static <T> void checkLeak(@NotNull Object root, @NotNull Class<T> suspectClass, @Nullable Processor<? super T> isReallyLeak) throws AssertionError {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        if (suspectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspectClass", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        LeakHunter.checkLeak(Collections.singletonList(root), suspectClass, isReallyLeak);
    }

    @NotNull
    public static List<Object> allRoots() {
        List<Object> list = Arrays.asList(ApplicationManager.getApplication(), Disposer.getTree(), IdeEventQueue.getInstance(), LaterInvocator.getLaterInvocatorQueue());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LeakHunter", "allRoots"));
        }
        return list;
    }
}

