/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.GCUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    @NonNls
    private static final String LIGHT_PROJECT_MARK = "Light project: ";
    private static IdeaTestApplication ourApplication;
    protected static Project ourProject;
    private static Module ourModule;
    private static PsiManager ourPsiManager;
    private static boolean ourAssertionsInTestDetected;
    private static VirtualFile ourSourceRoot;
    private static TestCase ourTestCase;
    public static Thread ourTestThread;
    private static LightProjectDescriptor ourProjectDescriptor;
    private ThreadTracker myThreadTracker;
    private static int ourTestCount;

    public static Project getProject() {
        return ourProject;
    }

    public static Module getModule() {
        return ourModule;
    }

    @NotNull
    public static PsiManager getPsiManager() {
        if (ourPsiManager == null) {
            ourPsiManager = PsiManager.getInstance((Project)ourProject);
        }
        PsiManager psiManager = ourPsiManager;
        if (psiManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "getPsiManager"));
        }
        return psiManager;
    }

    @NotNull
    public static IdeaTestApplication initApplication() {
        IdeaTestApplication ideaTestApplication = ourApplication = IdeaTestApplication.getInstance();
        if (ideaTestApplication == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "initApplication"));
        }
        return ideaTestApplication;
    }

    public static void disposeApplication() {
        if (ourApplication != null) {
            ApplicationManager.getApplication().runWriteAction(() -> Disposer.dispose((Disposable)ourApplication));
            ourApplication = null;
        }
    }

    public static IdeaTestApplication getApplication() {
        return ourApplication;
    }

    public static void reportTestExecutionStatistics() {
        System.out.println("----- TEST STATISTICS -----");
        UsefulTestCase.logSetupTeardownCosts();
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.appInstancesCreated' value='%d']", MockApplication.INSTANCES_CREATED));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.projectInstancesCreated' value='%d']", ProjectManagerImpl.TEST_PROJECTS_CREATED));
        long totalGcTime = 0L;
        for (GarbageCollectorMXBean mxBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            totalGcTime += mxBean.getCollectionTime();
        }
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.gcTimeMs' value='%d']", totalGcTime));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.classesLoaded' value='%d']", ManagementFactory.getClassLoadingMXBean().getTotalLoadedClassCount()));
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/testFramework/LightPlatformTestCase", "resetClassFields"));
        }
        try {
            UsefulTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass == LightPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    private static void initProject(@NotNull LightProjectDescriptor descriptor) throws Exception {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/testFramework/LightPlatformTestCase", "initProject"));
        }
        ourProjectDescriptor = descriptor;
        if (ourProject != null) {
            LightPlatformTestCase.closeAndDeleteProject();
        }
        ApplicationManager.getApplication().runWriteAction(LightPlatformTestCase::cleanPersistedVFSContent);
        File projectFile = FileUtil.createTempFile((String)"light_temp", (String)".ipr");
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectFile);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        new Throwable(projectFile.getPath()).printStackTrace(new PrintStream(buffer));
        ourProject = PlatformTestCase.createProject(projectFile, LIGHT_PROJECT_MARK + buffer);
        ourPathToKeep = projectFile.getPath();
        ourPsiManager = null;
        ourProjectDescriptor.setUpProject(ourProject, new LightProjectDescriptor.SetupHandler(){

            @Override
            public void moduleCreated(@NotNull Module module2) {
                if (module2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/LightPlatformTestCase$1", "moduleCreated"));
                }
                ourModule = module2;
            }

            @Override
            public void sourceRootCreated(@NotNull VirtualFile sourceRoot) {
                if (sourceRoot == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoot", "com/intellij/testFramework/LightPlatformTestCase$1", "sourceRootCreated"));
                }
                ourSourceRoot = sourceRoot;
            }
        });
        ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).storePointers();
    }

    public static VirtualFile getSourceRoot() {
        return ourSourceRoot;
    }

    @Override
    protected void setUp() throws Exception {
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            super.setUp();
            LightPlatformTestCase.initApplication();
            ApplicationInfoImpl.setInStressTest(this.isStressTest());
            ourApplication.setDataProvider(this);
            LightProjectDescriptor descriptor = this.getProjectDescriptor();
            LightPlatformTestCase.doSetup(descriptor, this.configureLocalInspectionTools(), this.getTestRootDisposable());
            InjectedLanguageManagerImpl.pushInjectors(LightPlatformTestCase.getProject());
            this.storeSettings();
            this.myThreadTracker = new ThreadTracker();
            ModuleRootManager.getInstance((Module)ourModule).orderEntries().getAllLibrariesAndSdkClassesRoots();
            VirtualFilePointerManagerImpl filePointerManager = (VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance();
            filePointerManager.storePointers();
        }));
    }

    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        SimpleLightProjectDescriptor simpleLightProjectDescriptor = new SimpleLightProjectDescriptor(this.getModuleType(), this.getProjectJDK());
        if (simpleLightProjectDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "getProjectDescriptor"));
        }
        return simpleLightProjectDescriptor;
    }

    public static void doSetup(@NotNull LightProjectDescriptor descriptor, @NotNull LocalInspectionTool[] localInspectionTools, @NotNull Disposable parentDisposable) throws Exception {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/testFramework/LightPlatformTestCase", "doSetup"));
        }
        if (localInspectionTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localInspectionTools", "com/intellij/testFramework/LightPlatformTestCase", "doSetup"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/testFramework/LightPlatformTestCase", "doSetup"));
        }
        LightPlatformTestCase.assertNull((String)("Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call."), (Object)ourTestCase);
        IdeaLogger.ourErrorsOccurred = null;
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean reusedProject = true;
        if (ourProject == null || ourProjectDescriptor == null || !ourProjectDescriptor.equals(descriptor)) {
            LightPlatformTestCase.initProject(descriptor);
            reusedProject = false;
        }
        ProjectManagerEx projectManagerEx = ProjectManagerEx.getInstanceEx();
        projectManagerEx.openTestProject(ourProject);
        if (reusedProject) {
            DumbService.getInstance((Project)ourProject).queueTask((DumbModeTask)new UnindexedFilesUpdater(ourProject));
        }
        MessageBusConnection connection = ourProject.getMessageBus().connect(parentDisposable);
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase$2", "moduleAdded"));
                }
                if (module2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/LightPlatformTestCase$2", "moduleAdded"));
                }
                TestCase.fail((String)"Adding modules is not permitted in LightIdeaTestCase.");
            }
        });
        LightPlatformTestCase.clearUncommittedDocuments(LightPlatformTestCase.getProject());
        InspectionsKt.configureInspections((InspectionProfileEntry[])localInspectionTools, LightPlatformTestCase.getProject(), parentDisposable);
        LightPlatformTestCase.assertFalse((boolean)LightPlatformTestCase.getPsiManager().isDisposed());
        Boolean passed = null;
        try {
            passed = StartupManagerEx.getInstanceEx(LightPlatformTestCase.getProject()).startupActivityPassed();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LightPlatformTestCase.assertTrue((String)("open: " + LightPlatformTestCase.getProject().isOpen() + "; disposed:" + LightPlatformTestCase.getProject().isDisposed() + "; startup passed:" + passed + "; all open projects: " + Arrays.asList(ProjectManager.getInstance().getOpenProjects())), (boolean)LightPlatformTestCase.getProject().isInitialized());
        CodeStyleSettingsManager.getInstance((Project)LightPlatformTestCase.getProject()).setTemporarySettings(new CodeStyleSettings());
        FileDocumentManager manager = FileDocumentManager.getInstance();
        if (manager instanceof FileDocumentManagerImpl) {
            Document[] unsavedDocuments = manager.getUnsavedDocuments();
            manager.saveAllDocuments();
            ApplicationManager.getApplication().runWriteAction(((FileDocumentManagerImpl)manager)::dropAllUnsavedDocuments);
            LightPlatformTestCase.assertEmpty("There are unsaved documents", Arrays.asList(unsavedDocuments));
        }
        UIUtil.dispatchAllInvocationEvents();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    protected void enableInspectionTools(InspectionProfileEntry ... tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTools"));
        }
        InspectionsKt.enableInspectionTools(LightPlatformTestCase.getProject(), this.getTestRootDisposable(), tools);
    }

    protected void enableInspectionTool(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTool"));
        }
        InspectionsKt.enableInspectionTool(LightPlatformTestCase.getProject(), toolWrapper, this.getTestRootDisposable());
    }

    protected void enableInspectionTool(@NotNull InspectionProfileEntry tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/testFramework/LightPlatformTestCase", "enableInspectionTool"));
        }
        InspectionsKt.enableInspectionTool(LightPlatformTestCase.getProject(), tool, this.getTestRootDisposable());
    }

    @NotNull
    protected LocalInspectionTool[] configureLocalInspectionTools() {
        if (LocalInspectionTool.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "configureLocalInspectionTools"));
        }
        return LocalInspectionTool.EMPTY_ARRAY;
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = LightPlatformTestCase.getProject();
        new RunAll(() -> CodeStyleSettingsManager.getInstance((Project)project2).dropTemporarySettings(), this::checkForSettingsDamage, () -> LightPlatformTestCase.doTearDown(project2, ourApplication, true), () -> super.tearDown(), () -> this.myThreadTracker.checkLeak(), () -> InjectedLanguageManagerImpl.checkInjectorsAreDisposed(project2), () -> ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).assertPointersAreDisposed()).run();
    }

    public static void doTearDown(@NotNull Project project2, @NotNull IdeaTestApplication application, boolean checkForEditors) throws Exception {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "doTearDown"));
        }
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/intellij/testFramework/LightPlatformTestCase", "doTearDown"));
        }
        new RunAll(new ThrowableRunnable[0]).append(() -> ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue()).append(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "lambda$doTearDown$9"));
            }
            CodeStyleSettingsManager.getInstance((Project)project2).dropTemporarySettings();
        }).append(LightPlatformTestCase::checkJavaSwingTimersAreDisposed).append(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "lambda$doTearDown$10"));
            }
            UsefulTestCase.doPostponedFormatting(project2);
        }).append(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "lambda$doTearDown$11"));
            }
            LookupManager.getInstance(project2).hideActiveLookup();
        }).append(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "lambda$doTearDown$12"));
            }
            ((StartupManagerImpl)StartupManager.getInstance((Project)project2)).prepareForNextTest();
        }).append(() -> {
            if (ProjectManager.getInstance() == null) {
                throw new AssertionError((Object)"Application components damaged");
            }
        }).append(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "lambda$doTearDown$15"));
            }
            WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
                FileDocumentManager manager;
                EncodingManager encodingManager;
                if (ourSourceRoot != null) {
                    try {
                        for (VirtualFile child : ourSourceRoot.getChildren()) {
                            child.delete(LightPlatformTestCase.class);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if ((encodingManager = EncodingManager.getInstance()) instanceof EncodingManagerImpl) {
                    ((EncodingManagerImpl)encodingManager).clearDocumentQueue();
                }
                if ((manager = FileDocumentManager.getInstance()) instanceof FileDocumentManagerImpl) {
                    ((FileDocumentManagerImpl)manager).dropAllUnsavedDocuments();
                }
            });
        }).append(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "lambda$doTearDown$16"));
            }
            LightPlatformTestCase.assertFalse((boolean)PsiManager.getInstance((Project)project2).isDisposed());
        }).append(() -> {
            if (!ourAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }).append(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "lambda$doTearDown$18"));
            }
            LightPlatformTestCase.clearUncommittedDocuments(project2);
        }).append(() -> ((HintManagerImpl)HintManager.getInstance()).cleanup()).append(() -> DocumentCommitThread.getInstance().clearQueue()).append(() -> ((UndoManagerImpl)UndoManager.getGlobalInstance()).dropHistoryInTests()).append(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "lambda$doTearDown$22"));
            }
            ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests();
        }).append(() -> ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest()).append(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "lambda$doTearDown$24"));
            }
            TemplateDataLanguageMappings.getInstance(project2).cleanupForNextTest();
        }).append(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "lambda$doTearDown$25"));
            }
            ProjectManagerEx.getInstanceEx().closeTestProject(project2);
        }).append(() -> {
            if (application == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/intellij/testFramework/LightPlatformTestCase", "lambda$doTearDown$26"));
            }
            application.setDataProvider(null);
        }).append(() -> {
            ourTestCase = null;
        }).append(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "lambda$doTearDown$28"));
            }
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest();
        }).append(() -> CompletionProgressIndicator.cleanupForNextTest()).append(() -> UIUtil.dispatchAllInvocationEvents()).append(() -> {
            if (checkForEditors) {
                LightPlatformTestCase.checkEditorsReleased();
            }
        }).append(() -> {
            if (ourTestCount++ % 100 == 0) {
                GCUtil.clearBeanInfoCache();
            }
        }).run();
    }

    private static void checkJavaSwingTimersAreDisposed() throws Exception {
        Method sharedInstance;
        Object timerQueue;
        Class<?> TimerQueueClass = Class.forName("javax.swing.TimerQueue");
        DelayQueue delayQueue = (DelayQueue)ReflectionUtil.getField(TimerQueueClass, (Object)(timerQueue = (sharedInstance = ReflectionUtil.getMethod(TimerQueueClass, (String)"sharedInstance", (Class[])new Class[0])).invoke(null, new Object[0])), DelayQueue.class, (String)"queue");
        Object timer = delayQueue.peek();
        if (timer != null) {
            long delay = timer.getDelay(TimeUnit.MILLISECONDS);
            String text = "(delayed for " + delay + "ms)";
            Method getTimer = ReflectionUtil.getDeclaredMethod(timer.getClass(), (String)"getTimer", (Class[])new Class[0]);
            Timer swingTimer = (Timer)getTimer.invoke(timer, new Object[0]);
            text = "Timer (listeners: " + Arrays.asList(swingTimer.getActionListeners()) + ") " + text;
            throw new AssertionFailedError("Not disposed java.swing.Timer: " + text + "; queue:" + timerQueue);
        }
    }

    public static void clearUncommittedDocuments(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightPlatformTestCase", "clearUncommittedDocuments"));
        }
        PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project2);
        documentManager.clearUncommittedDocuments();
        ProjectManagerImpl projectManager = (ProjectManagerImpl)ProjectManager.getInstance();
        if (projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)defaultProject)).clearUncommittedDocuments();
        }
    }

    public static void checkEditorsReleased() {
        Editor[] allEditors = EditorFactory.getInstance().getAllEditors();
        if (allEditors.length == 0) {
            return;
        }
        RunAll runAll = new RunAll(new ThrowableRunnable[0]);
        for (Editor editor : allEditors) {
            runAll = runAll.append(() -> EditorFactoryImpl.throwNotReleasedError(editor)).append(() -> EditorFactory.getInstance().releaseEditor(editor));
        }
        runAll.append(() -> ((EditorImpl)allEditors[0]).throwDisposalError("Unreleased editors: " + allEditors.length)).run();
    }

    @Override
    public final void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            try {
                ourTestThread = Thread.currentThread();
                this.startRunAndTear();
            }
            finally {
                ourTestThread = null;
                try {
                    Application application = ApplicationManager.getApplication();
                    if (application instanceof ApplicationEx) {
                        PlatformTestCase.cleanupApplicationCaches(ourProject);
                    }
                    this.resetAllFields();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }));
        SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private void startRunAndTear() throws Throwable {
        this.setUp();
        try {
            ourAssertionsInTestDetected = true;
            this.runTest();
            ourAssertionsInTestDetected = false;
        }
        finally {
            this.tearDown();
        }
    }

    public Object getData(String dataId) {
        return ourProject == null || ourProject.isDisposed() ? null : new TestDataProvider(ourProject).getData(dataId);
    }

    protected Sdk getProjectJDK() {
        return null;
    }

    @NotNull
    protected ModuleType getModuleType() {
        EmptyModuleType emptyModuleType = EmptyModuleType.getInstance();
        if (emptyModuleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "getModuleType"));
        }
        return emptyModuleType;
    }

    @NotNull
    protected static PsiFile createFile(@NonNls @NotNull String fileName, @NonNls @NotNull String text) throws IncorrectOperationException {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/testFramework/LightPlatformTestCase", "createFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/LightPlatformTestCase", "createFile"));
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true, false);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "createFile"));
        }
        return psiFile;
    }

    @NotNull
    protected static PsiFile createLightFile(@NonNls @NotNull String fileName, @NotNull String text) throws IncorrectOperationException {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/testFramework/LightPlatformTestCase", "createLightFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/LightPlatformTestCase", "createLightFile"));
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), false, false);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "createLightFile"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        String name = this.getName();
        LightPlatformTestCase.assertTrue((String)("Test name should start with 'test': " + name), (boolean)name.startsWith("test"));
        name = name.substring("test".length());
        if (!name.isEmpty() && lowercaseFirstLetter && !PlatformTestUtil.isAllUppercaseName(name)) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "getTestName"));
        }
        return string;
    }

    protected static void commitDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/testFramework/LightPlatformTestCase", "commitDocument"));
        }
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitDocument(document);
    }

    protected static void commitAllDocuments() {
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitAllDocuments();
    }

    @Override
    @NotNull
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            CodeStyleSettings codeStyleSettings = new CodeStyleSettings();
            if (codeStyleSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "getCurrentCodeStyleSettings"));
            }
            return codeStyleSettings;
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)LightPlatformTestCase.getProject());
        if (codeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase", "getCurrentCodeStyleSettings"));
        }
        return codeStyleSettings;
    }

    protected static Document getDocument(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightPlatformTestCase", "getDocument"));
        }
        return PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).getDocument(file2);
    }

    public static synchronized void closeAndDeleteProject() {
        File parent;
        if (ourProject == null) {
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call closeAndDeleteProject from under write action");
        }
        if (!ourProject.isDisposed()) {
            LightPlatformTestCase.assertEquals((Object)ourProject, (Object)ourModule.getProject());
            File ioFile = new File(ourProject.getProjectFilePath());
            if (ioFile.exists()) {
                File dir = ioFile.getParentFile();
                if (dir.getName().startsWith("unitTest_")) {
                    FileUtil.delete((File)dir);
                } else {
                    FileUtil.delete((File)ioFile);
                }
            }
        }
        LightPlatformTestCase.assertTrue((boolean)ProjectManagerEx.getInstanceEx().closeAndDispose(ourProject));
        LightPlatformTestCase.assertTrue((boolean)ourProject.isDisposed());
        if (ourPathToKeep != null && (parent = new File(ourPathToKeep).getParentFile()).getName().startsWith("unitTest_")) {
            parent.delete();
        }
        ourProject = null;
        LightPlatformTestCase.assertTrue((boolean)ourModule.isDisposed());
        ourModule = null;
        LightPlatformTestCase.assertTrue((boolean)ourPsiManager.isDisposed());
        ourPsiManager = null;
        ourPathToKeep = null;
    }

    static {
        PlatformTestUtil.registerProjectCleanup(LightPlatformTestCase::closeAndDeleteProject);
    }

    private static class SimpleLightProjectDescriptor
    extends LightProjectDescriptor {
        @NotNull
        private final ModuleType myModuleType;
        @Nullable
        private final Sdk mySdk;

        SimpleLightProjectDescriptor(@NotNull ModuleType moduleType, @Nullable Sdk sdk) {
            if (moduleType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/testFramework/LightPlatformTestCase$SimpleLightProjectDescriptor", "<init>"));
            }
            this.myModuleType = moduleType;
            this.mySdk = sdk;
        }

        @Override
        @NotNull
        public ModuleType getModuleType() {
            ModuleType moduleType = this.myModuleType;
            if (moduleType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformTestCase$SimpleLightProjectDescriptor", "getModuleType"));
            }
            return moduleType;
        }

        @Override
        @Nullable
        public Sdk getSdk() {
            return this.mySdk;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleLightProjectDescriptor that = (SimpleLightProjectDescriptor)o;
            if (!this.myModuleType.equals((Object)that.myModuleType)) {
                return false;
            }
            return this.areJdksEqual(that.getSdk());
        }

        public int hashCode() {
            return this.myModuleType.hashCode();
        }

        private boolean areJdksEqual(Sdk newSdk) {
            if (this.mySdk == null || newSdk == null) {
                return this.mySdk == newSdk;
            }
            Object[] myUrls = this.mySdk.getRootProvider().getUrls(OrderRootType.CLASSES);
            Object[] newUrls = newSdk.getRootProvider().getUrls(OrderRootType.CLASSES);
            return ContainerUtil.newHashSet((Object[])myUrls).equals(ContainerUtil.newHashSet((Object[])newUrls));
        }
    }
}

