/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays;

import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.ComparisonFailure;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J \u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker;", "", "myFixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "isParamHintsEnabledBefore", "", "checkInlays", "", "extractInlays", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "getActualInlays", "removeText", "realStartOffset", "", "matchedLength", "setUp", "tearDown", "Companion", "testFramework"})
public final class InlayHintsChecker {
    private boolean isParamHintsEnabledBefore;
    private final CodeInsightTestFixture myFixture;
    @NotNull
    private static final Pattern pattern;
    private static final ParameterNameHintsSettings default;
    public static final Companion Companion;

    public final void setUp() {
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        this.isParamHintsEnabledBefore = settings.isShowParameterNameHints();
        settings.setShowParameterNameHints(true);
    }

    public final void tearDown() {
        EditorSettingsExternalizable.getInstance().setShowParameterNameHints(this.isParamHintsEnabledBefore);
        ParameterNameHintsSettings hintSettings = ParameterNameHintsSettings.Companion.getInstance();
        hintSettings.loadState(InlayHintsChecker.Companion.getDefault().getState());
    }

    /*
     * WARNING - void declaration
     */
    public final void checkInlays() {
        block8: {
            void $receiver$iv;
            List<InlayInfo> actualInlays;
            String originalText;
            Document document;
            PsiFile file2;
            block7: {
                boolean bl;
                block6: {
                    void $receiver$iv2;
                    file2 = this.myFixture.getFile();
                    document = this.myFixture.getDocument(file2);
                    originalText = document.getText();
                    Document document2 = document;
                    Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
                    List<InlayInfo> expectedInlays = this.extractInlays(document2);
                    actualInlays = this.getActualInlays();
                    if (expectedInlays.size() != actualInlays.size()) break block7;
                    Iterable iterable = CollectionsKt.zip((Iterable)actualInlays, (Iterable)expectedInlays);
                    for (Iterator<Object> element$iv : $receiver$iv2) {
                        Pair it = (Pair)element$iv;
                        if (!(Intrinsics.areEqual((Object)((InlayInfo)it.getSecond()), (Object)((InlayInfo)it.getFirst())) ^ true)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
                if (!bl) break block8;
            }
            StringBuilder proposedText = new StringBuilder(document.getText());
            Object object = CollectionsKt.asReversed(actualInlays);
            for (Object element$iv : $receiver$iv) {
                InlayInfo it = (InlayInfo)element$iv;
                proposedText.insert(it.getOffset(), "<hint text=" + "\"" + it.getText() + "\"" + " />");
            }
            String string = (String)VfsTestUtil.TEST_DATA_FILE_PATH.get((UserDataHolder)file2.getVirtualFile());
            if (string != null) {
                object = string;
                String originalPath = (String)object;
                throw (Throwable)new FileComparisonFailure("Hints differ", originalText, proposedText.toString(), originalPath);
            }
            throw (Throwable)new ComparisonFailure("Hints differ", originalText, proposedText.toString());
        }
    }

    private final List<InlayInfo> getActualInlays() {
        Collection destination$iv$iv;
        Inlay it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        this.myFixture.doHighlighting();
        Editor editor = this.myFixture.getEditor();
        List allInlays = editor.getInlayModel().getInlineElementsInRange(0, editor.getDocument().getTextLength());
        ParameterHintsPresentationManager hintManager = ParameterHintsPresentationManager.getInstance();
        Iterable iterable = allInlays;
        Iterable iterable2 = $receiver$iv;
        Object object = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Inlay)element$iv$iv;
            if (!hintManager.isParameterHint(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Inlay)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = hintManager.getHintText(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hintManager.getHintText(it)");
            InlayInfo inlayInfo = new InlayInfo(string, it.getOffset());
            collection.add(inlayInfo);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterable2 = $receiver$iv;
        object = new Comparator<InlayInfo>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int compare(Object a, Object b) {
                InlayInfo it = (InlayInfo)a;
                Comparable comparable = Integer.valueOf(it.getOffset());
                it = (InlayInfo)b;
                Comparable comparable2 = comparable;
                Integer n = it.getOffset();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)object);
    }

    @NotNull
    public final List<InlayInfo> extractInlays(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        String text = document.getText();
        Matcher matcher = Companion.getPattern().matcher(text);
        List inlays = CollectionsKt.mutableListOf((Object[])new InlayInfo[0]);
        int extractedLength = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int matchedLength = matcher.end() - start;
            int realStartOffset = start - extractedLength;
            Collection collection = inlays;
            String string = matcher.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group(1)");
            InlayInfo inlayInfo = new InlayInfo(string, realStartOffset);
            collection.add(inlayInfo);
            this.removeText(document, realStartOffset, matchedLength);
            extractedLength += matcher.end() - start;
        }
        return inlays;
    }

    private final void removeText(Document document, int realStartOffset, int matchedLength) {
        WriteCommandAction.runWriteCommandAction((Project)this.myFixture.getProject(), (Runnable)new Runnable(document, realStartOffset, matchedLength){
            final /* synthetic */ Document $document;
            final /* synthetic */ int $realStartOffset;
            final /* synthetic */ int $matchedLength;

            public final void run() {
                this.$document.replaceString(this.$realStartOffset, this.$realStartOffset + this.$matchedLength, (CharSequence)"");
            }
            {
                this.$document = document;
                this.$realStartOffset = n;
                this.$matchedLength = n2;
            }
        });
    }

    public InlayHintsChecker(@NotNull CodeInsightTestFixture myFixture) {
        Intrinsics.checkParameterIsNotNull((Object)myFixture, (String)"myFixture");
        this.myFixture = myFixture;
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("<hint\\s+text=\"([^\"\n\r]+)\"\\s*/>");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"<hint\\\\\u2026=\\\"([^\\\"\\n\\r]+)\\\"\\\\s*/>\")");
        InlayHintsChecker.pattern = pattern;
        default = new ParameterNameHintsSettings();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker$Companion;", "", "()V", "default", "Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "getDefault", "()Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "testFramework"})
    public static final class Companion {
        @NotNull
        public final Pattern getPattern() {
            return pattern;
        }

        private final ParameterNameHintsSettings getDefault() {
            return default;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

