/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorTextFieldCellRenderer
implements TableCellRenderer,
Disposable {
    private static final Key<SimpleRendererComponent> MY_PANEL_PROPERTY = Key.create((String)"EditorTextFieldCellRenderer.MyEditorPanel");
    private final Project myProject;
    private final FileType myFileType;
    private final boolean myInheritFontFromLaF;

    protected EditorTextFieldCellRenderer(@Nullable Project project2, @Nullable FileType fileType, @NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/EditorTextFieldCellRenderer", "<init>"));
        }
        this(project2, fileType, true, parent);
    }

    protected EditorTextFieldCellRenderer(@Nullable Project project2, @Nullable FileType fileType, boolean inheritFontFromLaF, @NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/EditorTextFieldCellRenderer", "<init>"));
        }
        this.myProject = project2;
        this.myFileType = fileType;
        this.myInheritFontFromLaF = inheritFontFromLaF;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    protected abstract String getText(JTable var1, Object var2, int var3, int var4);

    @Nullable
    protected TextAttributes getTextAttributes(JTable table, Object value, int row, int column) {
        return null;
    }

    @NotNull
    protected EditorColorsScheme getColorScheme(JTable table) {
        EditorColorsScheme editorColorsScheme = this.getEditorPanel(table).getEditor().getColorsScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer", "getColorScheme"));
        }
        return editorColorsScheme;
    }

    protected void customizeEditor(@NotNull EditorEx editor, JTable table, Object value, boolean selected, int row, int column) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/EditorTextFieldCellRenderer", "customizeEditor"));
        }
        String text = this.getText(table, value, row, column);
        this.getEditorPanel(table).setText(text, this.getTextAttributes(table, value, row, column), selected);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
        RendererComponent panel2 = this.getEditorPanel(table);
        EditorEx editor = panel2.getEditor();
        editor.getColorsScheme().setEditorFontSize(table.getFont().getSize());
        editor.getColorsScheme().setColor(EditorColors.SELECTION_BACKGROUND_COLOR, table.getSelectionBackground());
        editor.getColorsScheme().setColor(EditorColors.SELECTION_FOREGROUND_COLOR, table.getSelectionForeground());
        editor.setBackgroundColor(selected ? table.getSelectionBackground() : table.getBackground());
        panel2.setSelected(!Comparing.equal((Object)editor.getBackgroundColor(), (Object)table.getBackground()));
        panel2.setBorder(null);
        this.customizeEditor(editor, table, value, selected, row, column);
        return panel2;
    }

    @NotNull
    private RendererComponent getEditorPanel(final JTable table) {
        RendererComponent panel2 = (RendererComponent)UIUtil.getClientProperty((Object)table, MY_PANEL_PROPERTY);
        if (panel2 != null) {
            DelegateColorScheme scheme2 = (DelegateColorScheme)panel2.getEditor().getColorsScheme();
            scheme2.setDelegate(EditorColorsManager.getInstance().getGlobalScheme());
            RendererComponent rendererComponent = panel2;
            if (rendererComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer", "getEditorPanel"));
            }
            return rendererComponent;
        }
        panel2 = this.createRendererComponent(this.myProject, this.myFileType, this.myInheritFontFromLaF);
        Disposer.register((Disposable)this, (Disposable)panel2);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                UIUtil.putClientProperty((JComponent)table, (Key)MY_PANEL_PROPERTY, null);
            }
        });
        table.putClientProperty(MY_PANEL_PROPERTY, panel2);
        RendererComponent rendererComponent = panel2;
        if (rendererComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer", "getEditorPanel"));
        }
        return rendererComponent;
    }

    @NotNull
    protected RendererComponent createRendererComponent(@Nullable Project project2, @Nullable FileType fileType, boolean inheritFontFromLaF) {
        AbbreviatingRendererComponent abbreviatingRendererComponent = new AbbreviatingRendererComponent(project2, fileType, inheritFontFromLaF);
        if (abbreviatingRendererComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer", "createRendererComponent"));
        }
        return abbreviatingRendererComponent;
    }

    public void dispose() {
    }

    private static class MyDocument
    extends UserDataHolderBase
    implements DocumentEx {
        RangeMarkerTree<RangeMarkerEx> myRangeMarkers = new RangeMarkerTree<RangeMarkerEx>((Document)this){};
        char[] myChars = ArrayUtil.EMPTY_CHAR_ARRAY;
        String myString = "";
        LineSet myLineSet = LineSet.createLineSet(this.myString);

        private MyDocument() {
        }

        public void setText(@NotNull CharSequence text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "setText"));
            }
            String s = StringUtil.convertLineSeparators((String)text.toString());
            this.myChars = new char[s.length()];
            s.getChars(0, s.length(), this.myChars, 0);
            this.myString = new String(this.myChars);
            this.myLineSet = LineSet.createLineSet(this.myString);
        }

        @Override
        public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        }

        @Override
        @NotNull
        public LineIterator createLineIterator() {
            LineIterator lineIterator = this.myLineSet.createIterator();
            if (lineIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "createLineIterator"));
            }
            return lineIterator;
        }

        @Override
        public void setModificationStamp(long modificationStamp) {
        }

        @Override
        public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "addEditReadOnlyListener"));
            }
        }

        @Override
        public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "removeEditReadOnlyListener"));
            }
        }

        @Override
        public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
            if (chars == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "replaceText"));
            }
        }

        @Override
        public void moveText(int srcStart, int srcEnd, int dstOffset) {
        }

        @Override
        public void suppressGuardedExceptions() {
        }

        @Override
        public void unSuppressGuardedExceptions() {
        }

        @Override
        public boolean isInEventsHandling() {
            return false;
        }

        @Override
        public void clearLineModificationFlags() {
        }

        @Override
        public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
            if (rangeMarker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "removeRangeMarker"));
            }
            return this.myRangeMarkers.removeInterval(rangeMarker);
        }

        @Override
        public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
            if (rangeMarker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "registerRangeMarker"));
            }
            this.myRangeMarkers.addInterval(rangeMarker, start, end, greedyToLeft, greedyToRight, layer);
        }

        @Override
        public boolean isInBulkUpdate() {
            return false;
        }

        @Override
        public void setInBulkUpdate(boolean value) {
        }

        @Override
        @NotNull
        public List<RangeMarker> getGuardedBlocks() {
            List<RangeMarker> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getGuardedBlocks"));
            }
            return list;
        }

        @Override
        public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor2) {
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "processRangeMarkers"));
            }
            return this.myRangeMarkers.process((Processor)processor2);
        }

        @Override
        public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<? super RangeMarker> processor2) {
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "processRangeMarkersOverlappingWith"));
            }
            return this.myRangeMarkers.processOverlappingWith(start, end, (Processor)processor2);
        }

        @NotNull
        public String getText() {
            String string = this.myString;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getText"));
            }
            return string;
        }

        @NotNull
        public String getText(@NotNull TextRange range) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getText"));
            }
            String string = range.substring(this.getText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getText"));
            }
            return string;
        }

        @NotNull
        public CharSequence getCharsSequence() {
            String string = this.myString;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getCharsSequence"));
            }
            return string;
        }

        @NotNull
        public CharSequence getImmutableCharSequence() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getImmutableCharSequence"));
            }
            return string;
        }

        @NotNull
        public char[] getChars() {
            if (this.myChars == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getChars"));
            }
            return this.myChars;
        }

        public int getTextLength() {
            return this.myChars.length;
        }

        public int getLineCount() {
            return this.myLineSet.findLineIndex(this.myChars.length) + 1;
        }

        public int getLineNumber(int offset) {
            return this.myLineSet.findLineIndex(offset);
        }

        public int getLineStartOffset(int line) {
            return this.myChars.length == 0 ? 0 : this.myLineSet.getLineStart(line);
        }

        public int getLineEndOffset(int line) {
            return this.myChars.length == 0 ? 0 : this.myLineSet.getLineEnd(line);
        }

        public void insertString(int offset, @NotNull CharSequence s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "insertString"));
            }
        }

        public void deleteString(int startOffset, int endOffset) {
        }

        public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "replaceString"));
            }
        }

        public boolean isWritable() {
            return false;
        }

        public long getModificationStamp() {
            return 0L;
        }

        public void fireReadOnlyModificationAttempt() {
        }

        public void addDocumentListener(@NotNull DocumentListener listener2) {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "addDocumentListener"));
            }
        }

        public void addDocumentListener(@NotNull DocumentListener listener2, @NotNull Disposable parentDisposable) {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "addDocumentListener"));
            }
            if (parentDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "addDocumentListener"));
            }
        }

        public void removeDocumentListener(@NotNull DocumentListener listener2) {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "removeDocumentListener"));
            }
        }

        @NotNull
        public RangeMarker createRangeMarker(int startOffset, int endOffset) {
            RangeMarkerImpl rangeMarkerImpl = new RangeMarkerImpl(this, startOffset, endOffset, true){};
            if (rangeMarkerImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "createRangeMarker"));
            }
            return rangeMarkerImpl;
        }

        @NotNull
        public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "createRangeMarker"));
            }
            return null;
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "addPropertyChangeListener"));
            }
        }

        public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "removePropertyChangeListener"));
            }
        }

        public void setReadOnly(boolean isReadOnly) {
        }

        @NotNull
        public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "createGuardedBlock"));
            }
            return null;
        }

        public void removeGuardedBlock(@NotNull RangeMarker block) {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "removeGuardedBlock"));
            }
        }

        @Nullable
        public RangeMarker getOffsetGuard(int offset) {
            return null;
        }

        @Nullable
        public RangeMarker getRangeGuard(int start, int end) {
            return null;
        }

        public void startGuardedBlockChecking() {
        }

        public void stopGuardedBlockChecking() {
        }

        public void setCyclicBufferSize(int bufferSize) {
        }

        @NotNull
        public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
            if (textRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "createRangeMarker"));
            }
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "createRangeMarker"));
            }
            return null;
        }

        public int getLineSeparatorLength(int line) {
            return 0;
        }

        @Override
        public int getModificationSequence() {
            return 0;
        }
    }

    public static class AbbreviatingRendererComponent
    extends RendererComponent {
        private static final char ABBREVIATION_SUFFIX = '\u2026';
        private static final char RETURN_SYMBOL = '\u23ce';
        private final StringBuilder myDocumentTextBuilder = new StringBuilder();
        private Dimension myPreferredSize;
        private String myRawText;

        public AbbreviatingRendererComponent(Project project2, @Nullable FileType fileType, boolean inheritFontFromLaF) {
            super(project2, fileType, inheritFontFromLaF);
        }

        @Override
        public void setText(String text) {
            this.myRawText = text;
            this.myPreferredSize = null;
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.myPreferredSize == null) {
                int maxLineLength = 0;
                int linesCount = 0;
                LineTokenizer lt = new LineTokenizer((CharSequence)this.myRawText);
                while (!lt.atEnd()) {
                    maxLineLength = Math.max(maxLineLength, lt.getLength());
                    ++linesCount;
                    lt.advance();
                }
                FontMetrics fontMetrics = ((EditorImpl)this.getEditor()).getFontMetrics(this.myTextAttributes != null ? this.myTextAttributes.getFontType() : 0);
                int preferredHeight = this.getEditor().getLineHeight() * Math.max(1, linesCount);
                int preferredWidth = fontMetrics.charWidth('m') * maxLineLength;
                Insets insets = this.getInsets();
                if (insets != null) {
                    preferredHeight += insets.top + insets.bottom;
                    preferredWidth += insets.left + insets.right;
                }
                this.myPreferredSize = new Dimension(preferredWidth, preferredHeight);
            }
            return this.myPreferredSize;
        }

        @Override
        protected void paintChildren(Graphics g) {
            this.updateText(g.getClipBounds());
            super.paintChildren(g);
        }

        private void updateText(Rectangle clip) {
            boolean singleLineMode;
            FontMetrics fontMetrics = ((EditorImpl)this.getEditor()).getFontMetrics(this.myTextAttributes != null ? this.myTextAttributes.getFontType() : 0);
            Insets insets = this.getInsets();
            int maxLineWidth = this.getWidth() - (insets != null ? insets.left + insets.right : 0);
            this.myDocumentTextBuilder.setLength(0);
            boolean bl = singleLineMode = (float)this.getHeight() / (float)this.getEditor().getLineHeight() < 1.1f;
            if (singleLineMode) {
                AbbreviatingRendererComponent.appendAbbreviated(this.myDocumentTextBuilder, this.myRawText, 0, this.myRawText.length(), fontMetrics, maxLineWidth, true);
            } else {
                int line;
                int lineHeight = this.getEditor().getLineHeight();
                int firstVisibleLine = clip.y / lineHeight;
                float visibleLinesCountFractional = (float)clip.height / (float)lineHeight;
                int linesToAppend = 1 + (int)visibleLinesCountFractional;
                LineTokenizer lt = new LineTokenizer((CharSequence)this.myRawText);
                for (line = 0; !lt.atEnd() && line < firstVisibleLine; ++line) {
                    this.myDocumentTextBuilder.append('\n');
                    lt.advance();
                }
                for (line = 0; !lt.atEnd() && line < linesToAppend; ++line) {
                    int start = lt.getOffset();
                    int end = start + lt.getLength();
                    AbbreviatingRendererComponent.appendAbbreviated(this.myDocumentTextBuilder, this.myRawText, start, end, fontMetrics, maxLineWidth, false);
                    if (lt.getLineSeparatorLength() > 0) {
                        this.myDocumentTextBuilder.append('\n');
                    }
                    lt.advance();
                }
            }
            this.setTextToEditor(this.myDocumentTextBuilder.toString());
        }

        private static void appendAbbreviated(StringBuilder to, String text, int start, int end, FontMetrics metrics, int maxWidth, boolean replaceLineTerminators) {
            int abbreviationLength = AbbreviatingRendererComponent.abbreviationLength(text, start, end, metrics, maxWidth, replaceLineTerminators);
            if (!replaceLineTerminators) {
                to.append(text, start, start + abbreviationLength);
            } else {
                CharSequenceSubSequence subSeq = new CharSequenceSubSequence((CharSequence)text, start, start + abbreviationLength);
                LineTokenizer lt = new LineTokenizer((CharSequence)subSeq);
                while (!lt.atEnd()) {
                    to.append((CharSequence)subSeq, lt.getOffset(), lt.getOffset() + lt.getLength());
                    if (lt.getLineSeparatorLength() > 0) {
                        to.append('\u23ce');
                    }
                    lt.advance();
                }
            }
            if (abbreviationLength != end - start) {
                to.append('\u2026');
            }
        }

        private static int abbreviationLength(String text, int start, int end, FontMetrics metrics, int maxWidth, boolean replaceSeparators) {
            if (metrics.charWidth('m') * (end - start) <= maxWidth) {
                return end - start;
            }
            int abbrWidth = metrics.charWidth('\u2026');
            int abbrLength = 0;
            CharSequenceSubSequence subSeq = new CharSequenceSubSequence((CharSequence)text, start, end);
            LineTokenizer lt = new LineTokenizer((CharSequence)subSeq);
            while (!lt.atEnd()) {
                int i2 = 0;
                while (i2 < lt.getLength()) {
                    if ((abbrWidth += metrics.charWidth(subSeq.charAt(lt.getOffset() + i2))) >= maxWidth) {
                        return abbrLength;
                    }
                    ++i2;
                    ++abbrLength;
                }
                if (replaceSeparators && lt.getLineSeparatorLength() != 0) {
                    if ((abbrWidth += metrics.charWidth('\u23ce')) >= maxWidth) {
                        return abbrLength;
                    }
                    abbrLength += lt.getLineSeparatorLength();
                }
                lt.advance();
            }
            return abbrLength;
        }
    }

    public static class SimpleRendererComponent
    extends RendererComponent
    implements Disposable {
        public SimpleRendererComponent(Project project2, @Nullable FileType fileType, boolean inheritFontFromLaF) {
            super(project2, fileType, inheritFontFromLaF);
        }

        @Override
        public void setText(String text) {
            this.setTextToEditor(text);
        }
    }

    public static abstract class RendererComponent
    extends CellRendererPanel
    implements Disposable {
        private final EditorEx myEditor;
        private final EditorTextField myTextField;
        protected TextAttributes myTextAttributes;
        private boolean mySelected;

        public RendererComponent(Project project2, @Nullable FileType fileType, boolean inheritFontFromLaF) {
            Pair<EditorTextField, EditorEx> pair = RendererComponent.createEditor(project2, fileType, inheritFontFromLaF);
            this.myTextField = (EditorTextField)pair.first;
            this.myEditor = (EditorEx)pair.second;
            this.add(this.myEditor.getContentComponent());
        }

        public EditorEx getEditor() {
            return this.myEditor;
        }

        @NotNull
        private static Pair<EditorTextField, EditorEx> createEditor(Project project2, @Nullable FileType fileType, boolean inheritFontFromLaF) {
            EditorTextField field = new EditorTextField(new MyDocument(), project2, fileType, false, false);
            field.setSupplementary(true);
            field.setFontInheritedFromLAF(inheritFontFromLaF);
            field.addNotify();
            EditorEx editor = (EditorEx)ObjectUtils.assertNotNull((Object)field.getEditor());
            editor.setRendererMode(true);
            editor.setColorsScheme(editor.createBoundColorSchemeDelegate(null));
            editor.getSettings().setCaretRowShown(false);
            editor.getScrollPane().setBorder(null);
            Pair pair = Pair.create((Object)field, (Object)editor);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$RendererComponent", "createEditor"));
            }
            return pair;
        }

        public void setText(String text, @Nullable TextAttributes textAttributes, boolean selected) {
            this.myTextAttributes = textAttributes;
            this.mySelected = selected;
            this.setText(text);
        }

        public abstract void setText(String var1);

        @Override
        public void setBackground(Color bg) {
            if (this.myEditor != null) {
                this.myEditor.setBackgroundColor(bg);
            }
            super.setBackground(bg);
        }

        public void dispose() {
            this.remove(this.myEditor.getContentComponent());
            this.myTextField.removeNotify();
        }

        protected void setTextToEditor(String text) {
            this.myEditor.getMarkupModel().removeAllHighlighters();
            this.myEditor.getDocument().setText(text);
            ((EditorImpl)this.myEditor).resetSizes();
            this.myEditor.getHighlighter().setText((CharSequence)text);
            if (this.myTextAttributes != null) {
                this.myEditor.getMarkupModel().addRangeHighlighter(0, this.myEditor.getDocument().getTextLength(), 3000, this.myTextAttributes, HighlighterTargetArea.EXACT_RANGE);
            }
            ((EditorImpl)this.myEditor).setPaintSelection(this.mySelected);
            SelectionModel selectionModel = this.myEditor.getSelectionModel();
            selectionModel.setSelection(0, this.mySelected ? this.myEditor.getDocument().getTextLength() : 0);
        }
    }
}

