/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FinderRecursivePanel<T>
extends OnePixelSplitter
implements DataProvider,
Disposable {
    @NotNull
    private final Project myProject;
    @Nullable
    private final String myGroupId;
    @Nullable
    private final FinderRecursivePanel myParent;
    @Nullable
    private JComponent myChild;
    protected JBList<T> myList;
    protected final CollectionListModel<T> myListModel;
    private final MergingUpdateQueue myMergingUpdateQueue;
    private volatile boolean isMergeListItemsRunning;
    private final AtomicBoolean myUpdateSelectedPathModeActive;
    private final CopyProvider myCopyProvider;

    protected FinderRecursivePanel(@NotNull FinderRecursivePanel parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/FinderRecursivePanel", "<init>"));
        }
        this(parent.getProject(), parent, parent.getGroupId());
    }

    protected FinderRecursivePanel(@NotNull Project project2, @Nullable String groupId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/FinderRecursivePanel", "<init>"));
        }
        this(project2, null, groupId);
    }

    protected FinderRecursivePanel(@NotNull Project project2, @Nullable FinderRecursivePanel parent, @Nullable String groupId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/FinderRecursivePanel", "<init>"));
        }
        super(false, 0.0f);
        this.myChild = null;
        this.myListModel = new CollectionListModel(new Object[0]);
        this.myMergingUpdateQueue = new MergingUpdateQueue("FinderRecursivePanel", 100, true, (JComponent)((Object)this), (Disposable)this);
        this.myUpdateSelectedPathModeActive = new AtomicBoolean();
        this.myCopyProvider = new CopyProvider(){

            public void performCopy(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/FinderRecursivePanel$1", "performCopy"));
                }
                Object value = FinderRecursivePanel.this.getSelectedValue();
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(FinderRecursivePanel.this.getItemText(value)));
            }

            public boolean isCopyEnabled(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/FinderRecursivePanel$1", "isCopyEnabled"));
                }
                return FinderRecursivePanel.this.getSelectedValue() != null;
            }

            public boolean isCopyVisible(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/FinderRecursivePanel$1", "isCopyVisible"));
                }
                return false;
            }
        };
        this.myProject = project2;
        this.myParent = parent;
        this.myGroupId = groupId;
        if (this.myParent != null) {
            Disposer.register((Disposable)this.myParent, (Disposable)this);
        }
    }

    public void initPanel() {
        this.initWithoutUpdatePanel();
        this.updatePanel();
    }

    private void initWithoutUpdatePanel() {
        this.setFirstComponent(this.createLeftComponent());
        this.setSecondComponent(this.createDefaultRightComponent());
        if (this.getGroupId() != null) {
            this.setAndLoadSplitterProportionKey(this.getGroupId() + "[" + this.getIndex() + "]");
        }
    }

    @NotNull
    protected abstract List<T> getListItems();

    protected String getListEmptyText() {
        return "No entries";
    }

    @NotNull
    protected abstract String getItemText(T var1);

    @Nullable
    protected Icon getItemIcon(T t) {
        return null;
    }

    protected abstract boolean hasChildren(T var1);

    @Nullable
    protected VirtualFile getContainingFile(T t) {
        return null;
    }

    protected boolean isEditable() {
        return this.getSelectedValue() != null;
    }

    @Nullable
    protected JComponent createRightComponent(T t) {
        return new JPanel();
    }

    @Nullable
    protected JComponent createDefaultRightComponent() {
        return new JBPanelWithEmptyText().withEmptyText("Nothing selected");
    }

    protected JComponent createLeftComponent() {
        this.myList = this.createList();
        JScrollPane pane = ScrollPaneFactory.createScrollPane(this.myList, (int)20, (int)31);
        return ListWithFilter.wrap(this.myList, (JScrollPane)pane, o -> this.getItemText(o));
    }

    protected JBList<T> createList() {
        JBList list = new JBList(this.myListModel);
        list.setSelectionMode(0);
        list.setEmptyText(this.getListEmptyText());
        list.setCellRenderer(this.createListCellRenderer());
        this.installListActions(list);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                if (FinderRecursivePanel.this.isMergeListItemsRunning()) {
                    return;
                }
                if (FinderRecursivePanel.this.myUpdateSelectedPathModeActive.get()) {
                    return;
                }
                FinderRecursivePanel.this.updateRightComponent(true);
            }
        });
        ScrollingUtil.installActions((JList)list);
        this.installEditOnDoubleClick(list);
        return list;
    }

    private void handleGotoPrevious() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myList, true);
    }

    private void handleGotoNext() {
        if (!this.myList.isEmpty() && this.myList.getSelectedValue() == null) {
            this.myList.setSelectedIndex(0);
            this.updateRightComponent(true);
        }
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myList, true);
    }

    private void installListActions(JBList list) {
        AnAction previousPanelAction = new AnAction("Previous", null, AllIcons.Actions.Back){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(!FinderRecursivePanel.this.isRootPanel());
            }

            public void actionPerformed(AnActionEvent e) {
                assert (FinderRecursivePanel.this.myParent != null);
                FinderRecursivePanel.this.myParent.handleGotoPrevious();
            }
        };
        previousPanelAction.registerCustomShortcutSet(37, 0, (JComponent)list);
        AnAction nextPanelAction = new AnAction("Next", null, AllIcons.Actions.Forward){

            public void update(AnActionEvent e) {
                Object value = FinderRecursivePanel.this.getSelectedValue();
                e.getPresentation().setEnabled(value != null && FinderRecursivePanel.this.hasChildren(value) && FinderRecursivePanel.this.getSecondComponent() instanceof FinderRecursivePanel);
            }

            public void actionPerformed(AnActionEvent e) {
                FinderRecursivePanel finderRecursivePanel = (FinderRecursivePanel)((Object)FinderRecursivePanel.this.getSecondComponent());
                finderRecursivePanel.handleGotoNext();
            }
        };
        nextPanelAction.registerCustomShortcutSet(39, 0, (JComponent)list);
        AnAction editAction = new AnAction("Edit", null, AllIcons.Actions.Edit){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(FinderRecursivePanel.this.isEditable());
            }

            public void actionPerformed(AnActionEvent e) {
                FinderRecursivePanel.this.performEditAction();
            }
        };
        editAction.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)list);
        Object[] actions = new AnAction[]{previousPanelAction, nextPanelAction, Separator.getInstance(), editAction};
        Object[] customActions = this.getCustomListActions();
        if (customActions.length > 0) {
            actions = (AnAction[])ArrayUtil.append((Object[])actions, (Object)Separator.getInstance());
            actions = (AnAction[])ArrayUtil.mergeArrays((Object[])actions, (Object[])customActions);
        }
        DefaultActionGroup contextActionGroup = new DefaultActionGroup((AnAction[])actions);
        PopupHandler.installUnknownPopupHandler((JComponent)list, (ActionGroup)contextActionGroup, (ActionManager)ActionManager.getInstance());
    }

    protected AnAction[] getCustomListActions() {
        return AnAction.EMPTY_ARRAY;
    }

    private void installSpeedSearch(JBList list) {
        ListSpeedSearch search = new ListSpeedSearch((JList)list, new Function<Object, String>(){

            public String fun(Object o) {
                return FinderRecursivePanel.this.getItemText(o);
            }
        });
        search.setComparator(new SpeedSearchComparator(false));
    }

    private void installEditOnDoubleClick(JBList list) {
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                FinderRecursivePanel.this.performEditAction();
                return true;
            }
        }.installOn((Component)list);
    }

    protected boolean performEditAction() {
        Navigatable data = (Navigatable)CommonDataKeys.NAVIGATABLE.getData(DataManager.getInstance().getDataContext(this.myList));
        if (data != null && data.canNavigate()) {
            data.navigate(true);
        }
        return false;
    }

    protected ListCellRenderer<T> createListCellRenderer() {
        return new ColoredListCellRenderer<T>(){
            private final FileColorManager myFileColorManager;
            {
                this.myFileColorManager = FileColorManager.getInstance((Project)FinderRecursivePanel.this.getProject());
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Color bg;
                this.mySelected = isSelected;
                this.myForeground = UIUtil.getTreeTextForeground();
                this.mySelectionForeground = cellHasFocus ? list.getSelectionForeground() : UIUtil.getTreeTextForeground();
                this.clear();
                this.setFont(UIUtil.getListFont());
                Object t = value;
                try {
                    this.setIcon(FinderRecursivePanel.this.getItemIcon(t));
                    this.append(FinderRecursivePanel.this.getItemText(t));
                }
                catch (IndexNotReadyException e) {
                    this.append("loading...");
                }
                try {
                    FinderRecursivePanel.this.doCustomizeCellRenderer((SimpleColoredComponent)this, list, t, index, isSelected, cellHasFocus);
                }
                catch (IndexNotReadyException e) {
                    // empty catch block
                }
                Color color = bg = isSelected ? UIUtil.getTreeSelectionBackground((boolean)cellHasFocus) : UIUtil.getTreeTextBackground();
                if (!isSelected && this.myFileColorManager.isEnabled()) {
                    Color fileBgColor = this.myFileColorManager.getRendererBackground(FinderRecursivePanel.this.getContainingFile(t));
                    bg = fileBgColor == null ? bg : fileBgColor;
                }
                this.setBackground(bg);
                if (FinderRecursivePanel.this.hasChildren(t)) {
                    JPanel result2 = new JPanel(new BorderLayout());
                    JLabel childrenLabel = new JLabel();
                    childrenLabel.setOpaque(true);
                    childrenLabel.setVisible(true);
                    childrenLabel.setBackground(bg);
                    boolean isDark = ColorUtil.isDark((Color)UIUtil.getListSelectionBackground());
                    childrenLabel.setIcon(isSelected ? (isDark ? AllIcons.Icons.Ide.NextStepInverted : AllIcons.Icons.Ide.NextStep) : AllIcons.Icons.Ide.NextStepGrayed);
                    result2.add((Component)((Object)this), "Center");
                    result2.add((Component)childrenLabel, "East");
                    return result2;
                }
                return this;
            }

            protected final void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/FinderRecursivePanel$8", "customizeCellRenderer"));
                }
            }
        };
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, T value, int index, boolean selected, boolean hasFocus) {
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        T selectedValue = this.getSelectedValue();
        if (selectedValue == null) {
            return null;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId) && selectedValue instanceof PsiElement) {
            return selectedValue;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && selectedValue instanceof Navigatable) {
            return selectedValue;
        }
        if (LangDataKeys.MODULE.is(dataId) && selectedValue instanceof Module) {
            return selectedValue;
        }
        if (selectedValue instanceof DataProvider) {
            return ((DataProvider)selectedValue).getData(dataId);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyProvider;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.myMergingUpdateQueue.cancelAllUpdates();
    }

    @Nullable
    public T getSelectedValue() {
        return (T)this.myList.getSelectedValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelectedPath(Object ... pathToSelect) {
        if (!this.myUpdateSelectedPathModeActive.compareAndSet(false, true)) {
            return;
        }
        try {
            FinderRecursivePanel panel2 = this;
            for (int i2 = 0; i2 < pathToSelect.length; ++i2) {
                Object selectedValue = pathToSelect[i2];
                panel2.setSelectedValue(selectedValue);
                if (i2 >= pathToSelect.length - 1) continue;
                JComponent component = panel2.getSecondComponent();
                assert (component instanceof FinderRecursivePanel) : Arrays.toString(pathToSelect);
                panel2 = (FinderRecursivePanel)((Object)component);
            }
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(panel2.myList, true);
        }
        finally {
            this.myUpdateSelectedPathModeActive.set(false);
        }
    }

    private void setSelectedValue(Object value) {
        if (value.equals(this.myList.getSelectedValue())) {
            return;
        }
        this.myList.setPaintBusy(true);
        try {
            List listItems = (List)ReadAction.compute(() -> this.getListItems());
            this.mergeListItems(this.myListModel, (JList<T>)this.myList, listItems);
        }
        finally {
            this.myList.setPaintBusy(false);
        }
        this.myList.setSelectedValue(value, true);
        this.createRightComponent(false);
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/FinderRecursivePanel", "getProject"));
        }
        return project2;
    }

    @Nullable
    public FinderRecursivePanel getParentPanel() {
        return this.myParent;
    }

    @Nullable
    protected String getGroupId() {
        return this.myGroupId;
    }

    public void updatePanel() {
        if (this.myUpdateSelectedPathModeActive.get()) {
            return;
        }
        this.myList.setPaintBusy(true);
        this.myMergingUpdateQueue.queue(new Update("update"){

            public void run() {
                Object oldValue = FinderRecursivePanel.this.getSelectedValue();
                int oldIndex = FinderRecursivePanel.this.myList.getSelectedIndex();
                ApplicationManager.getApplication().executeOnPooledThread(() -> DumbService.getInstance((Project)FinderRecursivePanel.this.getProject()).runReadActionInSmartMode(() -> {
                    try {
                        List listItems = FinderRecursivePanel.this.getListItems();
                        SwingUtilities.invokeLater(() -> {
                            FinderRecursivePanel.this.mergeListItems(FinderRecursivePanel.this.myListModel, FinderRecursivePanel.this.myList, listItems);
                            if (FinderRecursivePanel.this.myList.isEmpty()) {
                                FinderRecursivePanel.this.createRightComponent(true);
                            } else if (FinderRecursivePanel.this.myList.getSelectedIndex() < 0) {
                                FinderRecursivePanel.this.myList.setSelectedIndex(FinderRecursivePanel.this.myListModel.getSize() > oldIndex ? oldIndex : 0);
                            } else {
                                Object newValue = FinderRecursivePanel.this.myList.getSelectedValue();
                                FinderRecursivePanel.this.updateRightComponent(oldValue == null || !oldValue.equals(newValue) || FinderRecursivePanel.this.myList.isEmpty());
                            }
                        });
                    }
                    finally {
                        FinderRecursivePanel.this.myList.setPaintBusy(false);
                    }
                }));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeListItems(@NotNull CollectionListModel<T> listModel, @NotNull JList<T> list, @NotNull List<T> newItems) {
        if (listModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listModel", "com/intellij/ui/FinderRecursivePanel", "mergeListItems"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/FinderRecursivePanel", "mergeListItems"));
        }
        if (newItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newItems", "com/intellij/ui/FinderRecursivePanel", "mergeListItems"));
        }
        this.setMergeListItemsRunning(true);
        try {
            if (listModel.getSize() == 0) {
                listModel.add(newItems);
            } else if (newItems.size() == 0) {
                listModel.removeAll();
            } else {
                int newSelectedIndex = -1;
                T selection = list.getSelectedValue();
                if (selection != null) {
                    newSelectedIndex = newItems.indexOf(selection);
                }
                listModel.removeAll();
                listModel.add(newItems);
                list.setSelectedIndex(newSelectedIndex);
            }
        }
        finally {
            this.setMergeListItemsRunning(false);
        }
    }

    public boolean isMergeListItemsRunning() {
        return this.isMergeListItemsRunning;
    }

    protected void setMergeListItemsRunning(boolean isListMergeRunning) {
        this.isMergeListItemsRunning = isListMergeRunning;
    }

    public void updateRightComponent(boolean force) {
        if (force) {
            this.createRightComponent(true);
        } else if (this.myChild instanceof FinderRecursivePanel) {
            ((FinderRecursivePanel)((Object)this.myChild)).updatePanel();
        }
    }

    private void createRightComponent(boolean withUpdatePanel) {
        T value;
        if (this.myChild instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myChild));
        }
        if ((value = this.getSelectedValue()) != null) {
            this.myChild = this.createRightComponent(value);
            if (this.myChild instanceof FinderRecursivePanel) {
                FinderRecursivePanel childPanel = (FinderRecursivePanel)((Object)this.myChild);
                if (withUpdatePanel) {
                    childPanel.initPanel();
                } else {
                    childPanel.initWithoutUpdatePanel();
                }
            }
        } else {
            this.myChild = this.createDefaultRightComponent();
        }
        this.setSecondComponent(this.myChild);
    }

    private int getIndex() {
        int index = 0;
        for (FinderRecursivePanel parent = this.myParent; parent != null; parent = parent.getParentPanel()) {
            ++index;
        }
        return index;
    }

    protected boolean isRootPanel() {
        return this.getParentPanel() == null;
    }

    public void doLayout() {
        if (this.myProportion == 0.0f) {
            int total = this.getOrientation() ? this.getHeight() : this.getWidth();
            float proportion = (float)this.getFirstComponentPreferredSize() / (float)(total - this.getDividerWidth());
            if (proportion > 0.0f && proportion < 1.0f) {
                this.setProportion(proportion);
            }
        }
        super.doLayout();
    }

    protected int getFirstComponentPreferredSize() {
        return 200;
    }
}

