/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.CachedValueBase;
import com.intellij.util.CachedValueLeakChecker;
import com.intellij.util.CachedValuesFactory;
import com.intellij.util.DefaultCachedValuesFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedValuesManagerImpl
extends CachedValuesManager {
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project2, CachedValuesFactory factory) {
        this.myProject = project2;
        this.myFactory = factory == null ? new DefaultCachedValuesFactory(project2) : factory;
    }

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/CachedValuesManagerImpl", "createCachedValue"));
        }
        CachedValue<T> cachedValue = this.myFactory.createCachedValue(provider, trackValue);
        if (cachedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CachedValuesManagerImpl", "createCachedValue"));
        }
        return cachedValue;
    }

    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/CachedValuesManagerImpl", "createParameterizedCachedValue"));
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(provider, trackValue);
        if (parameterizedCachedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CachedValuesManagerImpl", "createParameterizedCachedValue"));
        }
        return parameterizedCachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T, D extends UserDataHolder> T getCachedValue(@NotNull D dataHolder, @NotNull Key<CachedValue<T>> key2, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue value;
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/util/CachedValuesManagerImpl", "getCachedValue"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/CachedValuesManagerImpl", "getCachedValue"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/CachedValuesManagerImpl", "getCachedValue"));
        }
        CachedValueLeakChecker.checkProvider(provider, key2, dataHolder);
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = (CachedValue)dh.getUserData(key2);
            if (this.isOutdated(value)) {
                value = null;
                dh.putUserData(key2, null);
            }
            if (value == null) {
                value = this.createCachedValue(provider, trackValue);
                assert (((CachedValueBase)value).isFromMyProject(this.myProject));
                value = (CachedValue)dh.putUserDataIfAbsent(key2, value);
            }
        } else {
            D d = dataHolder;
            synchronized (d) {
                value = (CachedValue)dataHolder.getUserData(key2);
                if (this.isOutdated(value)) {
                    value = null;
                }
                if (value == null) {
                    value = this.createCachedValue(provider, trackValue);
                    dataHolder.putUserData(key2, value);
                }
            }
        }
        return (T)value.getValue();
    }

    private boolean isOutdated(CachedValue<?> value) {
        return value instanceof CachedValueBase && (!((CachedValueBase)value).isFromMyProject(this.myProject) || !value.hasUpToDateValue());
    }

    public Project getProject() {
        return this.myProject;
    }
}

