/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.VersionUtil;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkBundle {
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.JdkBundle");
    @NotNull
    private static final Pattern[] VERSION_UPDATE_PATTERNS = new Pattern[]{Pattern.compile("^java version \"([\\d]+\\.[\\d]+\\.[\\d]+)_([\\d]+).*\".*", 8), Pattern.compile("^openjdk version \"([\\d]+\\.[\\d]+\\.[\\d]+)_([\\d]+).*\".*", 8), Pattern.compile("^[a-zA-Z() \"\\d]*([\\d]+\\.[\\d]+\\.?[\\d]*).*", 8)};
    @NotNull
    private static final Pattern ARCH_64_BIT_PATTERN = Pattern.compile(".*64-Bit.*", 8);
    @NotNull
    public static final Bitness runtimeBitness = JdkBundle.is64BitJVM(System.getProperty("java.vm.name")) ? Bitness.x64 : Bitness.x32;
    @NotNull
    private File myBundleAsFile;
    @NotNull
    private String myBundleName;
    @Nullable
    private Pair<Version, Integer> myVersionUpdate;
    private boolean myBoot;
    private boolean myBundled;
    private volatile Bitness bitness;

    private static boolean is64BitRuntime() {
        return runtimeBitness == Bitness.x64;
    }

    JdkBundle(@NotNull File bundleAsFile, @NotNull String bundleName, @Nullable Pair<Version, Integer> versionUpdate, boolean boot, boolean bundled) {
        if (bundleAsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleAsFile", "com/intellij/util/JdkBundle", "<init>"));
        }
        if (bundleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleName", "com/intellij/util/JdkBundle", "<init>"));
        }
        this.myBundleAsFile = bundleAsFile;
        this.myBundleName = bundleName;
        this.myVersionUpdate = versionUpdate;
        this.myBoot = boot;
        this.myBundled = bundled;
    }

    @Nullable
    public static JdkBundle createBundle(@NotNull File jvm, boolean boot, boolean bundled) {
        if (jvm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvm", "com/intellij/util/JdkBundle", "createBundle"));
        }
        return JdkBundle.createBundle(jvm, boot, bundled, true);
    }

    @Nullable
    public static JdkBundle createBundle(@NotNull File jvm, boolean boot, boolean bundled, boolean matchArch) {
        if (jvm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvm", "com/intellij/util/JdkBundle", "createBundle"));
        }
        String homeSubPath = SystemInfo.isMac ? "Contents/Home" : "";
        return JdkBundle.createBundle(jvm, homeSubPath, boot, bundled, matchArch);
    }

    @Nullable
    static JdkBundle createBundle(@NotNull File jvm, @NotNull String homeSubPath, boolean boot, boolean bundled, boolean matchArch) {
        File javaHome;
        if (jvm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvm", "com/intellij/util/JdkBundle", "createBundle"));
        }
        if (homeSubPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homeSubPath", "com/intellij/util/JdkBundle", "createBundle"));
        }
        File file2 = javaHome = SystemInfo.isMac ? new File(jvm, homeSubPath) : jvm;
        if (bundled) {
            javaHome = new File(PathManager.getHomePath(), javaHome.getPath());
        }
        boolean isValidBundle = true;
        String jreCheck = System.getProperty("idea.jre.check");
        if (jreCheck != null && "true".equals(jreCheck)) {
            isValidBundle = new File(javaHome, "lib" + File.separator + "tools.jar").exists();
        }
        if (!SystemInfo.isMac && !isValidBundle) {
            return null;
        }
        File absJvmLocation = bundled ? new File(PathManager.getHomePath(), jvm.getPath()) : jvm;
        Pair<Pair<String, Boolean>, Pair<Version, Integer>> nameArchVersionAndUpdate = JdkBundle.getJDKNameArchVersionAndUpdate(absJvmLocation, homeSubPath);
        if (((Pair)nameArchVersionAndUpdate.first).second == null) {
            return null;
        }
        if (matchArch && (Boolean)((Pair)nameArchVersionAndUpdate.first).second != JdkBundle.is64BitRuntime()) {
            return null;
        }
        if (SystemInfo.isMac && nameArchVersionAndUpdate.second != null && ((Version)((Pair)nameArchVersionAndUpdate.second).first).isOrGreaterThan(Integer.valueOf(1), Integer.valueOf(7)) && !isValidBundle) {
            return null;
        }
        JdkBundle bundle = new JdkBundle(absJvmLocation, (String)((Pair)nameArchVersionAndUpdate.first).first, (Pair<Version, Integer>)((Pair)nameArchVersionAndUpdate.second), boot, bundled);
        bundle.bitness = (Boolean)((Pair)nameArchVersionAndUpdate.first).second != false ? Bitness.x64 : Bitness.x32;
        return bundle;
    }

    @Nullable
    public static JdkBundle createBoot() {
        return JdkBundle.createBoot(true);
    }

    @Nullable
    static JdkBundle createBoot(boolean adjustToMacBundle) {
        JdkBundle bundle;
        File bootJDK = new File(System.getProperty("java.home")).getParentFile();
        if (SystemInfo.isMac && adjustToMacBundle) {
            bootJDK = bootJDK.getParentFile().getParentFile();
            bundle = JdkBundle.createBundle(bootJDK, true, false);
        } else {
            bundle = JdkBundle.createBundle(bootJDK, "", true, false, true);
        }
        if (bundle != null && JdkBundle.isBundledJDK(bundle)) {
            bundle.setBundled(true);
        }
        return bundle;
    }

    @NotNull
    public static File getBundledJDKAbsoluteLocation() {
        File file2 = new File(PathManager.getHomePath(), SystemInfo.isMac ? "jdk" : "jre");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/JdkBundle", "getBundledJDKAbsoluteLocation"));
        }
        return file2;
    }

    public static boolean isBundledJDK(@NotNull JdkBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "com/intellij/util/JdkBundle", "isBundledJDK"));
        }
        return FileUtil.filesEqual((File)bundle.getLocation(), (File)JdkBundle.getBundledJDKAbsoluteLocation());
    }

    @NotNull
    public File getLocation() {
        File file2 = this.myBundleAsFile;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/JdkBundle", "getLocation"));
        }
        return file2;
    }

    public String getVisualRepresentation() {
        StringBuilder representation = new StringBuilder(this.myBundleName);
        if (this.myVersionUpdate != null) {
            representation.append(((Version)this.myVersionUpdate.first).toString()).append((Integer)this.myVersionUpdate.second > 0 ? "_" + this.myVersionUpdate.second : "");
        }
        if (this.myBoot || this.myBundled) {
            representation.append(" [");
            if (this.myBoot) {
                representation.append(this.myBundled ? "boot, " : "boot");
            }
            if (this.myBundled) {
                representation.append("bundled");
            }
            representation.append("]");
        }
        return representation.toString();
    }

    public void setBundled(boolean bundled) {
        this.myBundled = bundled;
    }

    public boolean isBoot() {
        return this.myBoot;
    }

    public Bitness getBitness() {
        if (this.bitness == null) {
            String homeSubPath = SystemInfo.isMac ? "Contents/Home" : "";
            Pair<Pair<String, Boolean>, Pair<Version, Integer>> nameArchVersionAndUpdate = JdkBundle.getJDKNameArchVersionAndUpdate(this.getLocation(), homeSubPath);
            assert (((Pair)nameArchVersionAndUpdate.first).second != null);
            this.bitness = (Boolean)((Pair)nameArchVersionAndUpdate.first).second != false ? Bitness.x64 : Bitness.x32;
        }
        return this.bitness;
    }

    @NotNull
    public String getBundleName() {
        String string = this.myBundleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/JdkBundle", "getBundleName"));
        }
        return string;
    }

    @Nullable
    Pair<Version, Integer> getVersionUpdate() {
        return this.myVersionUpdate;
    }

    @Nullable
    public Version getVersion() {
        return this.myVersionUpdate != null ? (Version)this.myVersionUpdate.first : null;
    }

    @Nullable
    public Integer getUpdateNumber() {
        return this.myVersionUpdate != null ? (Integer)this.myVersionUpdate.second : null;
    }

    @NotNull
    String getNameVersion() {
        String string = this.myBundleName + (this.myVersionUpdate != null ? ((Version)this.myVersionUpdate.first).toString() : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/JdkBundle", "getNameVersion"));
        }
        return string;
    }

    private static Pair<Pair<String, Boolean>, Pair<Version, Integer>> getJDKNameArchVersionAndUpdate(File jvm, String homeSubPath) {
        String displayVersion;
        GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.NONE);
        commandLine.setExePath(new File(jvm, homeSubPath + File.separator + "jre" + File.separator + "bin" + File.separator + "java").getAbsolutePath());
        commandLine.addParameter("-version");
        Boolean is64Bit = null;
        Pair versionAndUpdate = null;
        List outputLines = null;
        try {
            outputLines = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine).getStderrLines();
        }
        catch (ExecutionException e) {
            if (SystemInfo.isMac) {
                commandLine.setExePath(new File(jvm, homeSubPath + File.separator + "bin" + File.separator + "java").getAbsolutePath());
                try {
                    outputLines = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine).getStderrLines();
                }
                catch (ExecutionException e1) {
                    LOG.debug((Throwable)e);
                }
            }
            LOG.debug((Throwable)e);
        }
        if (outputLines != null && outputLines.size() >= 1) {
            String versionLine = (String)outputLines.get(0);
            versionAndUpdate = VersionUtil.parseVersionAndUpdate((String)versionLine, (Pattern[])VERSION_UPDATE_PATTERNS);
            displayVersion = versionLine.replaceFirst("\".*\"", "");
            if (outputLines.size() >= 3) {
                is64Bit = JdkBundle.is64BitJVM((String)outputLines.get(2));
            }
        } else {
            displayVersion = jvm.getName();
        }
        return Pair.create((Object)Pair.create((Object)displayVersion, is64Bit), versionAndUpdate);
    }

    private static boolean is64BitJVM(String archLine) {
        return ARCH_64_BIT_PATTERN.matcher(archLine).find();
    }

    public boolean isBundled() {
        return this.myBundled;
    }

    public void setBoot(boolean boot) {
        this.myBoot = boot;
    }
}

