/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NonNls;

public class PendingEventDispatcher<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.PendingEventDispatcher");
    private final T myMulticaster;
    private final List<T> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Map<T, Boolean> myListenersState = new HashMap<T, Boolean>();
    private final Stack<T> myDispatchingListeners = new Stack();
    private Method myCurrentDispatchMethod = null;
    private Object[] myCurrentDispatchArgs = null;
    private static int ourDispatchingEventsCounter = 0;
    private final boolean myAssertDispatchThread;

    public static <T extends EventListener> PendingEventDispatcher<T> create(Class<T> listenerClass) {
        return PendingEventDispatcher.create(listenerClass, true);
    }

    public static <T extends EventListener> PendingEventDispatcher<T> create(Class<T> listenerClass, boolean assertDispatchThread) {
        return new PendingEventDispatcher<T>(listenerClass, assertDispatchThread);
    }

    public static boolean isDispatchingAnyEvent() {
        return ourDispatchingEventsCounter > 0;
    }

    public boolean isDispatching() {
        return this.myCurrentDispatchMethod != null;
    }

    private PendingEventDispatcher(Class<T> listenerClass, boolean assertDispatchThread) {
        this.myAssertDispatchThread = assertDispatchThread;
        InvocationHandler handler2 = new InvocationHandler(){

            @Override
            @NonNls
            public Object invoke(Object proxy, Method method2, Object[] args) throws Throwable {
                if (method2.getDeclaringClass().getName().equals("java.lang.Object")) {
                    String methodName = method2.getName();
                    if (methodName.equals("toString")) {
                        return "Multicaster";
                    }
                    if (methodName.equals("hashCode")) {
                        return System.identityHashCode(proxy);
                    }
                    if (methodName.equals("equals")) {
                        return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                    }
                    LOG.error("Incorrect Object's method invoked for proxy:" + methodName);
                    return null;
                }
                PendingEventDispatcher.this.dispatch(method2, args);
                return null;
            }
        };
        this.myMulticaster = (EventListener)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler2);
    }

    public boolean hasListeners() {
        return !this.myListeners.isEmpty();
    }

    public T getMulticaster() {
        return this.myMulticaster;
    }

    public synchronized void addListener(T listener2) {
        this.myListeners.add(listener2);
        this.myListenersState.put(listener2, Boolean.TRUE);
    }

    public synchronized void addListener(T listener2, Disposable parentDisposable) {
        this.addListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable((EventListener)listener2){
            final /* synthetic */ EventListener val$listener;
            {
                this.val$listener = eventListener;
            }

            public void dispose() {
                PendingEventDispatcher.this.removeListener(this.val$listener);
            }
        });
    }

    public synchronized void removeListener(T listener2) {
        this.myListeners.remove(listener2);
        this.myListenersState.remove(listener2);
    }

    public void dispatchPendingEvent(T listener2) {
        Boolean dispatched = this.myListenersState.get(listener2);
        if (dispatched == null) {
            return;
        }
        if (!dispatched.booleanValue()) {
            Application application = ApplicationManager.getApplication();
            if (application.isDispatchThread()) {
                this.invoke(listener2);
            } else {
                return;
            }
        }
    }

    private void assertDispatchThread() {
        Application application = ApplicationManager.getApplication();
        if (this.myAssertDispatchThread && !application.isUnitTestMode()) {
            application.assertIsDispatchThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(Method method2, Object[] args) {
        this.assertDispatchThread();
        if (this.myCurrentDispatchMethod != null) {
            LOG.error("Event cannot be raised when dispatching another event is in progress. Dispatching " + this.myCurrentDispatchMethod.getName());
        }
        method2.setAccessible(true);
        ++ourDispatchingEventsCounter;
        this.myCurrentDispatchMethod = method2;
        this.myCurrentDispatchArgs = args;
        try {
            List<T> listeners = this.getListeners();
            for (EventListener listener2 : listeners) {
                this.myListenersState.put(listener2, Boolean.FALSE);
            }
            for (EventListener listener2 : listeners) {
                this.invoke(listener2);
            }
        }
        finally {
            --ourDispatchingEventsCounter;
            this.myCurrentDispatchMethod = null;
            this.myCurrentDispatchArgs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(T listener2) {
        Boolean state = this.myListenersState.get(listener2);
        if (state == null || state.booleanValue()) {
            return;
        }
        this.myListenersState.put(listener2, Boolean.TRUE);
        try {
            this.myDispatchingListeners.push(listener2);
            this.myCurrentDispatchMethod.invoke(listener2, this.myCurrentDispatchArgs);
        }
        catch (AbstractMethodError abstractMethodError) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error(e.getCause());
        }
        finally {
            this.myDispatchingListeners.pop();
        }
    }

    public List<T> getListeners() {
        return this.myListeners;
    }
}

