/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.io.IOException;
import java.io.InputStream;

public class ScrambledInputStream
extends InputStream {
    private static final int MASK = 170;
    private final InputStream myOriginalStream;

    public ScrambledInputStream(InputStream originalStream) {
        this.myOriginalStream = originalStream;
    }

    @Override
    public int read() throws IOException {
        int b = this.myOriginalStream.read();
        if (b == -1) {
            return -1;
        }
        return b ^ 0xAA;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read2 = this.myOriginalStream.read(b, off, len);
        for (int i2 = 0; i2 < read2; ++i2) {
            int n = off + i2;
            b[n] = (byte)(b[n] ^ 0xAA);
        }
        return read2;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.myOriginalStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.myOriginalStream.available();
    }

    @Override
    public void close() throws IOException {
        this.myOriginalStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.myOriginalStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.myOriginalStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.myOriginalStream.markSupported();
    }
}

