/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.BiDirectionalEnumerator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InMemoryStorage
implements VcsLogStorage {
    private final BiDirectionalEnumerator<CommitId> myCommitIdEnumerator = new BiDirectionalEnumerator(1, ContainerUtil.canonicalStrategy());
    private final BiDirectionalEnumerator<VcsRef> myRefsEnumerator = new BiDirectionalEnumerator(1, ContainerUtil.canonicalStrategy());

    @Override
    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/InMemoryStorage", "getCommitIndex"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/InMemoryStorage", "getCommitIndex"));
        }
        return this.getOrPut(hash, root);
    }

    private int getOrPut(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/InMemoryStorage", "getOrPut"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/InMemoryStorage", "getOrPut"));
        }
        return this.myCommitIdEnumerator.enumerate((Object)new CommitId(hash, root));
    }

    @Override
    @NotNull
    public CommitId getCommitId(int commitIndex) {
        CommitId commitId = (CommitId)this.myCommitIdEnumerator.getValue(commitIndex);
        if (commitId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/InMemoryStorage", "getCommitId"));
        }
        return commitId;
    }

    @Override
    @Nullable
    public CommitId findCommitId(@NotNull Condition<CommitId> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/data/InMemoryStorage", "findCommitId"));
        }
        CommitId[] result2 = new CommitId[]{null};
        this.myCommitIdEnumerator.forEachValue(commitId -> {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/data/InMemoryStorage", "lambda$findCommitId$0"));
            }
            if (condition.value(commitId)) {
                result2[0] = commitId;
                return false;
            }
            return true;
        });
        return result2[0];
    }

    @Override
    public int getRefIndex(@NotNull VcsRef ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/data/InMemoryStorage", "getRefIndex"));
        }
        return this.myRefsEnumerator.enumerate((Object)ref);
    }

    @Override
    @Nullable
    public VcsRef getVcsRef(int refIndex) {
        return (VcsRef)this.myRefsEnumerator.getValue(refIndex);
    }

    @Override
    public void flush() {
    }
}

