/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import com.intellij.vcs.log.graph.impl.print.AbstractPrintElementGenerator;
import com.intellij.vcs.log.graph.impl.print.EdgesInRowGenerator;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrintElementGeneratorImpl
extends AbstractPrintElementGenerator {
    @NotNull
    private static final Logger LOG = Logger.getInstance(PrintElementGeneratorImpl.class);
    public static final int LONG_EDGE_SIZE = 30;
    private static final int LONG_EDGE_PART_SIZE = 1;
    private static final int VERY_LONG_EDGE_SIZE = 1000;
    private static final int VERY_LONG_EDGE_PART_SIZE = 250;
    private static final int CACHE_SIZE = 100;
    private static final boolean SHOW_ARROW_WHEN_SHOW_LONG_EDGES = true;
    private static final int SAMPLE_SIZE = 20000;
    private static final double K = 0.1;
    @NotNull
    private final SLRUMap<Integer, List<GraphElement>> myCache;
    @NotNull
    private final EdgesInRowGenerator myEdgesInRowGenerator;
    @NotNull
    private final Comparator<GraphElement> myGraphElementComparator;
    private final int myLongEdgeSize;
    private final int myVisiblePartSize;
    private final int myEdgeWithArrowSize;
    private int myRecommendedWidth;

    public PrintElementGeneratorImpl(@NotNull LinearGraph graph, @NotNull PrintElementManager printElementManager, boolean showLongEdges) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "<init>"));
        }
        if (printElementManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementManager", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "<init>"));
        }
        super(graph, printElementManager);
        this.myCache = new SLRUMap(100, 200);
        this.myRecommendedWidth = 0;
        this.myEdgesInRowGenerator = new EdgesInRowGenerator(graph);
        this.myGraphElementComparator = printElementManager.getGraphElementComparator();
        if (showLongEdges) {
            this.myLongEdgeSize = 1000;
            this.myVisiblePartSize = 250;
            this.myEdgeWithArrowSize = 30;
        } else {
            this.myLongEdgeSize = 30;
            this.myVisiblePartSize = 1;
            this.myEdgeWithArrowSize = Integer.MAX_VALUE;
        }
    }

    public PrintElementGeneratorImpl(@NotNull LinearGraph graph, @NotNull PrintElementManager printElementManager, int longEdgeSize, int visiblePartSize, int edgeWithArrowSize) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "<init>"));
        }
        if (printElementManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementManager", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "<init>"));
        }
        super(graph, printElementManager);
        this.myCache = new SLRUMap(100, 200);
        this.myRecommendedWidth = 0;
        this.myEdgesInRowGenerator = new EdgesInRowGenerator(graph);
        this.myGraphElementComparator = printElementManager.getGraphElementComparator();
        this.myLongEdgeSize = longEdgeSize;
        this.myVisiblePartSize = visiblePartSize;
        this.myEdgeWithArrowSize = edgeWithArrowSize;
    }

    public int getRecommendedWidth() {
        if (this.myRecommendedWidth <= 0) {
            int n = Math.min(20000, this.myLinearGraph.nodesCount());
            double sum = 0.0;
            double sumSquares = 0.0;
            int edgesCount = 0;
            HashSet currentNormalEdges = ContainerUtil.newHashSet();
            for (int i2 = 0; i2 < n; ++i2) {
                List<GraphEdge> adjacentEdges = this.myLinearGraph.getAdjacentEdges(i2, EdgeFilter.ALL);
                int upArrows = 0;
                int downArrows = 0;
                for (GraphEdge graphEdge : adjacentEdges) {
                    NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(graphEdge);
                    if (normalEdge != null) {
                        if (LinearGraphUtils.isEdgeUp(graphEdge, i2)) {
                            currentNormalEdges.remove(normalEdge);
                            continue;
                        }
                        currentNormalEdges.add(normalEdge);
                        continue;
                    }
                    if (graphEdge.getType() == GraphEdgeType.DOTTED_ARROW_UP) {
                        ++upArrows;
                        continue;
                    }
                    ++downArrows;
                }
                int newEdgesCount = 0;
                for (NormalEdge e3 : currentNormalEdges) {
                    if (this.isEdgeVisibleInRow(e3, i2)) {
                        ++newEdgesCount;
                        continue;
                    }
                    AbstractPrintElementGenerator.RowElementType arrow = this.getArrowType(e3, i2);
                    if (arrow == AbstractPrintElementGenerator.RowElementType.DOWN_ARROW) {
                        ++downArrows;
                        continue;
                    }
                    if (arrow != AbstractPrintElementGenerator.RowElementType.UP_ARROW) continue;
                    ++upArrows;
                }
                int n2 = Math.max(edgesCount + upArrows, newEdgesCount + downArrows);
                double weight = 2.0 / ((double)n * 1.1) * (1.0 + -0.9 * (double)i2 / (double)(n - 1));
                sum += (double)n2 * weight;
                sumSquares += (double)(n2 * n2) * weight;
                edgesCount = newEdgesCount;
            }
            double average = sum;
            double deviation = Math.sqrt(sumSquares - average * average);
            this.myRecommendedWidth = (int)Math.round(average + deviation);
        }
        return this.myRecommendedWidth;
    }

    @NotNull
    protected List<AbstractPrintElementGenerator.ShortEdge> getDownShortEdges(int rowIndex) {
        NullableFunction<GraphEdge, Integer> endPosition = this.createEndPositionFunction(rowIndex);
        ArrayList<AbstractPrintElementGenerator.ShortEdge> result2 = new ArrayList<AbstractPrintElementGenerator.ShortEdge>();
        List<GraphElement> visibleElements = this.getSortedVisibleElementsInRow(rowIndex);
        for (int startPosition = 0; startPosition < visibleElements.size(); ++startPosition) {
            GraphEdge edge;
            Integer endPos;
            GraphElement element = visibleElements.get(startPosition);
            if (element instanceof GraphNode) {
                int nodeIndex = ((GraphNode)element).getNodeIndex();
                for (GraphEdge edge2 : this.myLinearGraph.getAdjacentEdges(nodeIndex, EdgeFilter.ALL)) {
                    Integer endPos2;
                    if (!LinearGraphUtils.isEdgeDown(edge2, nodeIndex) || (endPos2 = (Integer)endPosition.fun((Object)edge2)) == null) continue;
                    result2.add(new AbstractPrintElementGenerator.ShortEdge(edge2, startPosition, endPos2));
                }
            }
            if (!(element instanceof GraphEdge) || (endPos = (Integer)endPosition.fun((Object)(edge = (GraphEdge)element))) == null) continue;
            result2.add(new AbstractPrintElementGenerator.ShortEdge(edge, startPosition, endPos));
        }
        ArrayList<AbstractPrintElementGenerator.ShortEdge> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getDownShortEdges"));
        }
        return arrayList;
    }

    @NotNull
    private NullableFunction<GraphEdge, Integer> createEndPositionFunction(int visibleRowIndex) {
        List<GraphElement> visibleElementsInNextRow = this.getSortedVisibleElementsInRow(visibleRowIndex + 1);
        HashMap<GraphElement, Integer> toPosition = new HashMap<GraphElement, Integer>();
        for (int position = 0; position < visibleElementsInNextRow.size(); ++position) {
            toPosition.put(visibleElementsInNextRow.get(position), position);
        }
        NullableFunction nullableFunction = edge -> {
            Integer downNodeIndex;
            Integer position = (Integer)toPosition.get(edge);
            if (position == null && (downNodeIndex = edge.getDownNodeIndex()) != null) {
                position = (Integer)toPosition.get(this.myLinearGraph.getGraphNode(downNodeIndex));
            }
            return position;
        };
        if (nullableFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "createEndPositionFunction"));
        }
        return nullableFunction;
    }

    @NotNull
    protected List<AbstractPrintElementGenerator.SimpleRowElement> getSimpleRowElements(int visibleRowIndex) {
        SmartList result2 = new SmartList();
        List<GraphElement> sortedVisibleElementsInRow = this.getSortedVisibleElementsInRow(visibleRowIndex);
        for (int position = 0; position < sortedVisibleElementsInRow.size(); ++position) {
            GraphEdge edge;
            AbstractPrintElementGenerator.RowElementType arrowType;
            GraphElement element = sortedVisibleElementsInRow.get(position);
            if (element instanceof GraphNode) {
                result2.add(new AbstractPrintElementGenerator.SimpleRowElement(element, AbstractPrintElementGenerator.RowElementType.NODE, position));
            }
            if (!(element instanceof GraphEdge) || (arrowType = this.getArrowType(edge = (GraphEdge)element, visibleRowIndex)) == null) continue;
            result2.add(new AbstractPrintElementGenerator.SimpleRowElement(edge, arrowType, position));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getSimpleRowElements"));
        }
        return smartList;
    }

    @Nullable
    private AbstractPrintElementGenerator.RowElementType getArrowType(@NotNull GraphEdge edge, int rowIndex) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getArrowType"));
        }
        NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge != null) {
            return this.getArrowType(normalEdge, rowIndex);
        }
        switch (edge.getType()) {
            case DOTTED_ARROW_DOWN: 
            case NOT_LOAD_COMMIT: {
                if (!LinearGraphUtils.intEqual(edge.getUpNodeIndex(), rowIndex - 1)) break;
                return AbstractPrintElementGenerator.RowElementType.DOWN_ARROW;
            }
            case DOTTED_ARROW_UP: {
                if (!LinearGraphUtils.intEqual(edge.getDownNodeIndex(), rowIndex + 1)) break;
                return AbstractPrintElementGenerator.RowElementType.UP_ARROW;
            }
            default: {
                LOG.error("Unknown special edge type " + (Object)((Object)edge.getType()) + " at row " + rowIndex);
            }
        }
        return null;
    }

    @Nullable
    private AbstractPrintElementGenerator.RowElementType getArrowType(@NotNull NormalEdge normalEdge, int rowIndex) {
        if (normalEdge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "normalEdge", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getArrowType"));
        }
        int edgeSize = normalEdge.down - normalEdge.up;
        int upOffset = rowIndex - normalEdge.up;
        int downOffset = normalEdge.down - rowIndex;
        if (edgeSize >= this.myLongEdgeSize) {
            if (upOffset == this.myVisiblePartSize) {
                LOG.assertTrue(downOffset != this.myVisiblePartSize, (Object)("Both up and down arrow at row " + rowIndex));
                return AbstractPrintElementGenerator.RowElementType.DOWN_ARROW;
            }
            if (downOffset == this.myVisiblePartSize) {
                return AbstractPrintElementGenerator.RowElementType.UP_ARROW;
            }
        }
        if (edgeSize >= this.myEdgeWithArrowSize) {
            if (upOffset == 1) {
                LOG.assertTrue(downOffset != 1, (Object)("Both up and down arrow at row " + rowIndex));
                return AbstractPrintElementGenerator.RowElementType.DOWN_ARROW;
            }
            if (downOffset == 1) {
                return AbstractPrintElementGenerator.RowElementType.UP_ARROW;
            }
        }
        return null;
    }

    private boolean isEdgeVisibleInRow(@NotNull GraphEdge edge, int visibleRowIndex) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "isEdgeVisibleInRow"));
        }
        NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge == null) {
            return false;
        }
        return this.isEdgeVisibleInRow(normalEdge, visibleRowIndex);
    }

    private boolean isEdgeVisibleInRow(@NotNull NormalEdge normalEdge, int visibleRowIndex) {
        if (normalEdge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "normalEdge", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "isEdgeVisibleInRow"));
        }
        return normalEdge.down - normalEdge.up < this.myLongEdgeSize || PrintElementGeneratorImpl.getAttachmentDistance(normalEdge, visibleRowIndex) <= this.myVisiblePartSize;
    }

    private void addSpecialEdges(@NotNull List<GraphElement> result2, int rowIndex) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "addSpecialEdges"));
        }
        if (rowIndex > 0) {
            for (GraphEdge edge : this.myLinearGraph.getAdjacentEdges(rowIndex - 1, EdgeFilter.SPECIAL)) {
                assert (!edge.getType().isNormalEdge());
                if (!LinearGraphUtils.isEdgeDown(edge, rowIndex - 1)) continue;
                result2.add(edge);
            }
        }
        if (rowIndex < this.myLinearGraph.nodesCount() - 1) {
            for (GraphEdge edge : this.myLinearGraph.getAdjacentEdges(rowIndex + 1, EdgeFilter.SPECIAL)) {
                assert (!edge.getType().isNormalEdge());
                if (!LinearGraphUtils.isEdgeUp(edge, rowIndex + 1)) continue;
                result2.add(edge);
            }
        }
    }

    @NotNull
    private List<GraphElement> getSortedVisibleElementsInRow(int rowIndex) {
        List graphElements = (List)this.myCache.get((Object)rowIndex);
        if (graphElements != null) {
            List list = graphElements;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getSortedVisibleElementsInRow"));
            }
            return list;
        }
        ArrayList<GraphElement> result2 = new ArrayList<GraphElement>();
        result2.add(this.myLinearGraph.getGraphNode(rowIndex));
        for (GraphEdge edge : this.myEdgesInRowGenerator.getEdgesInRow(rowIndex)) {
            if (!this.isEdgeVisibleInRow(edge, rowIndex)) continue;
            result2.add(edge);
        }
        this.addSpecialEdges(result2, rowIndex);
        Collections.sort(result2, this.myGraphElementComparator);
        this.myCache.put((Object)rowIndex, result2);
        ArrayList<GraphElement> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getSortedVisibleElementsInRow"));
        }
        return arrayList;
    }

    private static int getAttachmentDistance(@NotNull NormalEdge e1, int rowIndex) {
        if (e1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getAttachmentDistance"));
        }
        return Math.min(rowIndex - e1.up, e1.down - rowIndex);
    }
}

